/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import nuclearscience.common.entity.EntityParticle;

public class RenderParticle
extends EntityRenderer<EntityParticle> {
    private static final float MAX_SCALE = 0.02f;
    private static final float MIN_SCALE = 0.01f;
    private static final float DELTA_SCALE = 0.01f;

    public RenderParticle(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(EntityParticle entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float scale;
        matrixStackIn.m_85836_();
        float perc = (float)(500L - System.currentTimeMillis() % 1000L) / 500.0f;
        if (perc < 0.0f) {
            scale = 0.02f - 0.01f * (perc *= -1.0f);
        } else {
            perc = 1.0f - perc;
            scale = 0.01f + 0.01f * perc;
        }
        matrixStackIn.m_85841_(scale / 4.0f, scale / 4.0f, scale / 4.0f);
        int distance = entityIn.f_19853_.m_213780_().m_216332_(1, 10);
        long gameTime = entityIn.f_19853_.m_46467_();
        RenderParticle.renderStar(matrixStackIn, bufferIn, (float)gameTime + partialTicks, 250 / distance, 1.0f, 1.0f, 1.0f, 0.3f, false);
        RenderParticle.renderStar(matrixStackIn, bufferIn, (float)gameTime + 20.0f + partialTicks, 250 / distance, 1.0f, 1.0f, 1.0f, 0.3f, false);
        RenderParticle.renderStar(matrixStackIn, bufferIn, (float)gameTime + 40.0f + partialTicks, 250 / distance, 1.0f, 1.0f, 1.0f, 0.3f, false);
        RenderParticle.renderStar(matrixStackIn, bufferIn, (float)gameTime + 60.0f + partialTicks, 250 / distance, 1.0f, 1.0f, 1.0f, 0.3f, false);
        matrixStackIn.m_85849_();
    }

    public static void renderStar(PoseStack stack, MultiBufferSource bufferIn, float time, int starFrags, float r, float g, float b, float a, boolean star) {
        stack.m_85836_();
        try {
            float f5 = time / 200.0f;
            Random random = new Random(432L);
            VertexConsumer vertexconsumer2 = bufferIn.m_6299_(RenderType.m_110502_());
            stack.m_85836_();
            stack.m_85837_(0.0, -1.0, 0.0);
            for (int i = 0; i < starFrags; ++i) {
                stack.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
                stack.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
                stack.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f));
                stack.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
                stack.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
                stack.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f + f5 * 90.0f));
                float f3 = random.nextFloat() * 20.0f + 1.0f;
                float f4 = random.nextFloat() * 2.0f + 1.0f + (float)(star ? 0 : 100);
                Matrix4f matrix4f = stack.m_85850_().m_85861_();
                vertexconsumer2.m_85982_(matrix4f, 0.1f, 0.0f, 0.0f).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_85982_(matrix4f, -0.866f * f4, f3, -0.5f * f4).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_85982_(matrix4f, -0.866f * f4, f3, -0.5f * f4).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_85982_(matrix4f, -0.866f * f4, f3, -0.5f * f4).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_85982_(matrix4f, 0.0f, f3, 1.0f * f4).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
                vertexconsumer2.m_85982_(matrix4f, -0.866f * f4, f3, -0.5f * f4).m_6122_((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a)).m_5752_();
            }
            stack.m_85849_();
            if (bufferIn instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)bufferIn;
                source.m_109912_(RenderType.m_110502_());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        stack.m_85849_();
    }

    public ResourceLocation getTextureLocation(EntityParticle entity) {
        return InventoryMenu.f_39692_;
    }
}

