/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import nuclearscience.client.NuclearScienceClientRegister;
import nuclearscience.client.render.tile.RenderFissionReactorCore;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileFissionInterface;
import voltaic.client.VoltaicClientRegister;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;

public class RenderFissionInterface
extends AbstractTileRenderer<TileFissionInterface> {
    private static final double START_Y = 0.0;
    private static final double MAX_Y = 0.8125;
    private static final double FISSION_REACTOR_FLOOR_Y = 1.1125;
    private static final double FLOOR_Y = 0.0625;
    private static final double DELTA_FLOOR_Y = 1.05;
    public static final AABB FUEL_ROD_PISTON_1 = new AABB(0.1875, 0.0625, 0.1875, 0.25, 0.1125, 0.25);
    public static final AABB FUEL_ROD_PISTON_2 = new AABB(0.75, 0.0625, 0.1875, 0.8125, 0.1125, 0.25);
    public static final AABB FUEL_ROD_PISTON_3 = new AABB(0.75, 0.0625, 0.75, 0.8125, 0.1125, 0.8125);
    public static final AABB FUEL_ROD_PISTON_4 = new AABB(0.1875, 0.0625, 0.75, 0.25, 0.1125, 0.8125);
    public static final AABB TRITIUM_CELL_PISTON = new AABB(0.4375, 0.0625, 0.4375, 0.5625, 0.1125, 0.5625);
    public static final Color PISTON_HEAD_GRAY = new Color(92, 92, 92, 255);
    public static final Color PISTON_ROD_GRAY = new Color(140, 140, 140, 255);

    public RenderFissionInterface(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileFissionInterface tile, float partialTicks, PoseStack matrix, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrix.m_85836_();
        matrix.m_85837_(0.5, 0.5, 0.5);
        double insertion = (double)((Integer)tile.insertion.getValue()).intValue() / 100.0;
        matrix.m_85837_(0.0, 0.0 + 0.8125 * insertion, 0.0);
        RenderingUtils.renderModel((BakedModel)this.getModel(NuclearScienceClientRegister.MODEL_FISSIONINTERFACE_ROD), (BlockEntity)tile, (RenderType)RenderType.m_110451_(), (PoseStack)matrix, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrix.m_85849_();
        if (tile.clientAnimations.isEmpty() || !tile.reactor.valid() || !(tile.reactor.getSafe() instanceof TileFissionReactorCore)) {
            if (insertion > 0.0) {
                matrix.m_85836_();
                TextureAtlasSprite white = VoltaicClientRegister.whiteSprite();
                this.renderBox(matrix, FUEL_ROD_PISTON_1, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                this.renderBox(matrix, FUEL_ROD_PISTON_2, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                this.renderBox(matrix, FUEL_ROD_PISTON_3, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                this.renderBox(matrix, FUEL_ROD_PISTON_4, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                this.renderBox(matrix, TRITIUM_CELL_PISTON, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                matrix.m_85849_();
            }
            return;
        }
        TileFissionReactorCore core = (TileFissionReactorCore)((Object)tile.reactor.getSafe());
        ComponentInventory coreInv = (ComponentInventory)core.getComponent(IComponentType.Inventory);
        Long currTime = ((ComponentTickable)tile.getComponent(IComponentType.Tickable)).getTicks();
        TextureAtlasSprite fuelCell = NuclearScienceClientRegister.getSprite(NuclearScienceClientRegister.TEXTURE_FUELCELL);
        TextureAtlasSprite white = VoltaicClientRegister.whiteSprite();
        matrix.m_85836_();
        tile.clientAnimations.forEach((animation, recieved) -> {
            matrix.m_85836_();
            double perc = (double)(currTime - recieved) / (double)animation.animationTime;
            double doublePerc = perc * 2.0;
            double halfPerc = perc - 0.5;
            double doubleHalfPerc = halfPerc * 2.0;
            double oneMinusHalfPerc = 1.0 - doubleHalfPerc;
            switch (animation) {
                case FISSION_WASTE_1: {
                    if (perc > 0.5) {
                        double y = 1.05 * oneMinusHalfPerc;
                        AABB pistonRod = new AABB(0.203125, 0.0625, 0.203125, 0.234375, 0.0625 + y, 0.234375);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, RenderFissionReactorCore.FUEL_ROD_1, RenderFissionReactorCore.SPENT, fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, FUEL_ROD_PISTON_1, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    double y = 1.05 * doublePerc;
                    AABB pistonRod = new AABB(0.203125, 0.0625, 0.203125, 0.234375, 0.0625 + y, 0.234375);
                    this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, FUEL_ROD_PISTON_1, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    break;
                }
                case FISSION_WASTE_2: {
                    if (perc > 0.5) {
                        double y = 1.05 * oneMinusHalfPerc;
                        AABB pistonRod = new AABB(0.765625, 0.0625, 0.203125, 0.796875, 0.0625 + y, 0.234375);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, RenderFissionReactorCore.FUEL_ROD_2, RenderFissionReactorCore.SPENT, fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, FUEL_ROD_PISTON_2, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    double y = 1.05 * doublePerc;
                    AABB pistonRod = new AABB(0.765625, 0.0625, 0.203125, 0.796875, 0.0625 + y, 0.234375);
                    this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, FUEL_ROD_PISTON_2, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    break;
                }
                case FISSION_WASTE_3: {
                    if (perc > 0.5) {
                        double y = 1.05 * oneMinusHalfPerc;
                        AABB pistonRod = new AABB(0.765625, 0.0625, 0.765625, 0.796875, 0.0625 + y, 0.796875);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, RenderFissionReactorCore.FUEL_ROD_3, RenderFissionReactorCore.SPENT, fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, FUEL_ROD_PISTON_3, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    double y = 1.05 * doublePerc;
                    AABB pistonRod = new AABB(0.765625, 0.0625, 0.765625, 0.796875, 0.0625 + y, 0.796875);
                    this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, FUEL_ROD_PISTON_3, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    break;
                }
                case FISSION_WASTE_4: {
                    if (perc > 0.5) {
                        double y = 1.05 * oneMinusHalfPerc;
                        AABB pistonRod = new AABB(0.203125, 0.0625, 0.765625, 0.234375, 0.0625 + y, 0.796875);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, RenderFissionReactorCore.FUEL_ROD_4, RenderFissionReactorCore.SPENT, fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, FUEL_ROD_PISTON_4, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    double y = 1.05 * doublePerc;
                    AABB pistonRod = new AABB(0.203125, 0.0625, 0.765625, 0.234375, 0.0625 + y, 0.796875);
                    this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, FUEL_ROD_PISTON_4, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    break;
                }
                case FISSION_FUEL_1: {
                    if (perc < 0.5) {
                        double y = 1.05 * doublePerc;
                        AABB pistonRod = new AABB(0.203125, 0.0625, 0.203125, 0.234375, 0.0625 + y, 0.234375);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, RenderFissionReactorCore.FUEL_ROD_1, RenderFissionReactorCore.getColorFromFuel(coreInv.m_8020_(0)), fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, FUEL_ROD_PISTON_1, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    double y = 1.05 * oneMinusHalfPerc;
                    AABB pistonRod = new AABB(0.203125, 0.0625, 0.203125, 0.234375, 0.0625 + y, 0.234375);
                    this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, FUEL_ROD_PISTON_1, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    break;
                }
                case FISSION_FUEL_2: {
                    if (perc < 0.5) {
                        double y = 1.05 * doublePerc;
                        AABB pistonRod = new AABB(0.765625, 0.0625, 0.203125, 0.796875, 0.0625 + y, 0.234375);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, RenderFissionReactorCore.FUEL_ROD_2, RenderFissionReactorCore.getColorFromFuel(coreInv.m_8020_(1)), fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, FUEL_ROD_PISTON_2, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    double y = 1.05 * oneMinusHalfPerc;
                    AABB pistonRod = new AABB(0.765625, 0.0625, 0.203125, 0.796875, 0.0625 + y, 0.234375);
                    this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, FUEL_ROD_PISTON_2, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    break;
                }
                case FISSION_FUEL_3: {
                    if (perc < 0.5) {
                        double y = 1.05 * doublePerc;
                        AABB pistonRod = new AABB(0.765625, 0.0625, 0.765625, 0.796875, 0.0625 + y, 0.796875);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, RenderFissionReactorCore.FUEL_ROD_3, RenderFissionReactorCore.getColorFromFuel(coreInv.m_8020_(2)), fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, FUEL_ROD_PISTON_3, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    double y = 1.05 * oneMinusHalfPerc;
                    AABB pistonRod = new AABB(0.765625, 0.0625, 0.765625, 0.796875, 0.0625 + y, 0.796875);
                    this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, FUEL_ROD_PISTON_3, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    break;
                }
                case FISSION_FUEL_4: {
                    AABB pistonRod;
                    double y;
                    if (perc < 0.5) {
                        y = 1.05 * doublePerc;
                        pistonRod = new AABB(0.203125, 0.0625, 0.765625, 0.234375, 0.0625 + y, 0.796875);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, RenderFissionReactorCore.FUEL_ROD_4, RenderFissionReactorCore.getColorFromFuel(coreInv.m_8020_(3)), fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, FUEL_ROD_PISTON_4, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    } else {
                        y = 1.05 * oneMinusHalfPerc;
                        pistonRod = new AABB(0.203125, 0.0625, 0.765625, 0.234375, 0.0625 + y, 0.796875);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, FUEL_ROD_PISTON_4, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    }
                }
                case FISSION_TRITIUM_EXTRACT: {
                    AABB pistonRod;
                    double y;
                    if (perc > 0.5) {
                        y = 1.05 * oneMinusHalfPerc;
                        pistonRod = new AABB(0.453125, 0.0625, 0.453125, 0.546875, 0.0625 + y, 0.546875);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, RenderFissionReactorCore.TRITIUM_CELL, RenderFissionReactorCore.TRITIUM, fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, TRITIUM_CELL_PISTON, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    y = 1.05 * doublePerc;
                    pistonRod = new AABB(0.453125, 0.0625, 0.453125, 0.546875, 0.0625 + y, 0.546875);
                    this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, TRITIUM_CELL_PISTON, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    break;
                }
                case FISSION_DEUTERIUM_INSERT: {
                    if (perc < 0.5) {
                        double y = 1.05 * doublePerc;
                        AABB pistonRod = new AABB(0.453125, 0.0625, 0.453125, 0.546875, 0.0625 + y, 0.546875);
                        this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, RenderFissionReactorCore.TRITIUM_CELL, RenderFissionReactorCore.DEUTERIUM, fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, TRITIUM_CELL_PISTON, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    double y = 1.05 * oneMinusHalfPerc;
                    AABB pistonRod = new AABB(0.453125, 0.0625, 0.453125, 0.546875, 0.0625 + y, 0.546875);
                    this.renderBox(matrix, pistonRod, PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, TRITIUM_CELL_PISTON, PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                }
            }
            matrix.m_85849_();
        });
        matrix.m_85849_();
    }

    private void renderBox(PoseStack matrix, AABB box, Color color, TextureAtlasSprite texture, MultiBufferSource bufferIn, int combinedLightIn, boolean[] faces) {
        RenderingUtils.renderFilledBoxNoOverlay((PoseStack)matrix, (VertexConsumer)bufferIn.m_6299_(RenderType.m_110451_()), (AABB)box, (float)color.rFloat(), (float)color.gFloat(), (float)color.bFloat(), (float)color.aFloat(), (float)texture.m_118409_(), (float)texture.m_118411_(), (float)texture.m_118410_(), (float)texture.m_118412_(), (int)combinedLightIn, (boolean[])faces);
    }
}

