/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.phys.AABB;
import nuclearscience.client.NuclearScienceClientRegister;
import nuclearscience.client.render.tile.RenderFissionInterface;
import nuclearscience.client.render.tile.RenderFissionReactorCore;
import nuclearscience.common.tile.reactor.fusion.TileFusionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileFusionInterface;
import voltaic.client.VoltaicClientRegister;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;

public class RenderFusionInterface
extends AbstractTileRenderer<TileFusionInterface> {
    private static final double FISSION_REACTOR_FLOOR_Y = 1.0625;
    private static final double FLOOR_Y = 0.0625;
    private static final double DELTA_FLOOR_Y = 1.0;
    public static final AABB FUEL_CELL = new AABB(0.375, 0.125, 0.375, 0.625, 0.9375, 0.625);
    public static final AABB FUEL_CELL_PISTON = new AABB(0.3125, 0.0625, 0.3125, 0.6875, 0.125, 0.6875);

    public RenderFusionInterface(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileFusionInterface tile, float partialTicks, PoseStack matrix, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.reactor.valid() || !(tile.reactor.getSafe() instanceof TileFusionReactorCore)) {
            return;
        }
        tile.reactor.getSafe();
        Long currTime = ((ComponentTickable)tile.getComponent(IComponentType.Tickable)).getTicks();
        TextureAtlasSprite fuelCell = NuclearScienceClientRegister.getSprite(NuclearScienceClientRegister.TEXTURE_FUELCELL);
        TextureAtlasSprite white = VoltaicClientRegister.whiteSprite();
        if (tile.clientAnimations.isEmpty()) {
            matrix.m_85836_();
            this.renderBox(matrix, FUEL_CELL_PISTON, RenderFissionInterface.PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
            matrix.m_85849_();
            return;
        }
        matrix.m_85836_();
        tile.clientAnimations.forEach((animation, recieved) -> {
            matrix.m_85836_();
            double perc = (double)(currTime - recieved) / (double)animation.animationTime;
            double doublePerc = perc * 2.0;
            double halfPerc = perc - 0.5;
            double doubleHalfPerc = halfPerc * 2.0;
            double oneMinusHalfPerc = 1.0 - doubleHalfPerc;
            switch (animation) {
                case FUSION_TRITIUM_INSERT: {
                    if (perc < 0.5) {
                        double y = 1.0 * doublePerc;
                        AABB pistonRod = new AABB(0.4375, 0.0625, 0.4375, 0.5625, 0.0625 + y, 0.5625);
                        this.renderBox(matrix, pistonRod, RenderFissionInterface.PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, FUEL_CELL, RenderFissionReactorCore.TRITIUM, fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, FUEL_CELL_PISTON, RenderFissionInterface.PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    double y = 1.0 * oneMinusHalfPerc;
                    AABB pistonRod = new AABB(0.4375, 0.0625, 0.4375, 0.5625, 0.0625 + y, 0.5625);
                    this.renderBox(matrix, pistonRod, RenderFissionInterface.PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, FUEL_CELL_PISTON, RenderFissionInterface.PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    break;
                }
                case FUSION_DEUTERIUM_INSERT: {
                    if (perc < 0.5) {
                        double y = 1.0 * doublePerc;
                        AABB pistonRod = new AABB(0.4375, 0.0625, 0.4375, 0.5625, 0.0625 + y, 0.5625);
                        this.renderBox(matrix, pistonRod, RenderFissionInterface.PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        matrix.m_85837_(0.0, y, 0.0);
                        this.renderBox(matrix, FUEL_CELL, RenderFissionReactorCore.DEUTERIUM, fuelCell, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        this.renderBox(matrix, FUEL_CELL_PISTON, RenderFissionInterface.PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                        break;
                    }
                    double y = 1.0 * oneMinusHalfPerc;
                    AABB pistonRod = new AABB(0.4375, 0.0625, 0.4375, 0.5625, 0.0625 + y, 0.5625);
                    this.renderBox(matrix, pistonRod, RenderFissionInterface.PISTON_ROD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                    matrix.m_85837_(0.0, y, 0.0);
                    this.renderBox(matrix, FUEL_CELL_PISTON, RenderFissionInterface.PISTON_HEAD_GRAY, white, bufferIn, combinedLightIn, RenderingUtils.ALL_FACES);
                }
            }
            matrix.m_85849_();
        });
        matrix.m_85849_();
    }

    private void renderBox(PoseStack matrix, AABB box, Color color, TextureAtlasSprite texture, MultiBufferSource bufferIn, int combinedLightIn, boolean[] faces) {
        RenderingUtils.renderFilledBoxNoOverlay((PoseStack)matrix, (VertexConsumer)bufferIn.m_6299_(RenderType.m_110451_()), (AABB)box, (float)color.rFloat(), (float)color.gFloat(), (float)color.bFloat(), (float)color.aFloat(), (float)texture.m_118409_(), (float)texture.m_118411_(), (float)texture.m_118410_(), (float)texture.m_118412_(), (int)combinedLightIn, (boolean[])faces);
    }
}

