/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import nuclearscience.common.block.states.NuclearScienceBlockStates;
import nuclearscience.common.block.states.facing.FacingDirection;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.accelerator.TileElectromagneticGateway;
import nuclearscience.common.tile.accelerator.TileParticleInjector;
import nuclearscience.prefab.sound.SoundBarrierMethods;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceEntities;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.Location;

public class EntityParticle
extends Entity {
    private static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.m_135353_(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> TICKS_ALIVE = SynchedEntityData.m_135353_(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> SOURCE = SynchedEntityData.m_135353_(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> PASSED_THROUGH_GATEWAY = SynchedEntityData.m_135353_(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PASSED_THROUGH_SWITCH = SynchedEntityData.m_135353_(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Direction> SWITCH_DIRECTION = SynchedEntityData.m_135353_(EntityParticle.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    public static final float STARTING_SPEED = 0.02f;
    public static final float STRAIGHT_SPEED_INCREMENT = 0.0033333332f;
    public static final float TURN_SPEED_PENALTY = 0.9f;
    public static final float INVERT_SPEED_INCREMENT = -0.02f;
    public static final float MAX_SPEED = 2.0f;
    public static final float MIN_COLLISION_SPEED = 1.0f;
    private Direction facingDirection = Direction.UP;
    private Direction switchDirection = Direction.UP;
    public float speed = 0.02f;
    public BlockPos source = BlockEntityUtils.OUT_OF_REACH;
    public boolean passedThroughGate = false;
    private int ticksAlive = 0;
    private boolean passedThroughSwitch = false;
    private boolean firstTick = true;

    public EntityParticle(EntityType<?> entityTypeIn, Level worldIn) {
        super((EntityType)NuclearScienceEntities.ENTITY_PARTICLE.get(), worldIn);
    }

    public EntityParticle(Direction direction, Level worldIn, Location startPos, BlockPos ownerPos) {
        this((EntityType)NuclearScienceEntities.ENTITY_PARTICLE.get(), worldIn);
        this.m_146884_(new Vec3(startPos.x(), startPos.y(), startPos.z()));
        this.facingDirection = direction;
        this.f_19811_ = true;
        this.source = ownerPos;
        if (worldIn.f_46443_) {
            EntityParticle.m_20103_((double)4.0);
        }
    }

    protected void m_8097_() {
        if (this.facingDirection == null) {
            this.facingDirection = Direction.UP;
        }
        if (this.source == null) {
            this.source = BlockEntityUtils.OUT_OF_REACH;
        }
        if (this.switchDirection == null) {
            this.switchDirection = Direction.UP;
        }
        this.f_19804_.m_135372_(DIRECTION, (Object)this.facingDirection);
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(this.speed));
        this.f_19804_.m_135372_(TICKS_ALIVE, (Object)this.ticksAlive);
        this.f_19804_.m_135372_(SOURCE, (Object)this.source);
        this.f_19804_.m_135372_(PASSED_THROUGH_GATEWAY, (Object)this.passedThroughGate);
        this.f_19804_.m_135372_(PASSED_THROUGH_SWITCH, (Object)this.passedThroughSwitch);
        this.f_19804_.m_135372_(SWITCH_DIRECTION, (Object)this.switchDirection);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8119_() {
        boolean isServerside;
        boolean isClientside = this.f_19853_.m_5776_();
        boolean bl = isServerside = !isClientside;
        if (isServerside) {
            if (this.facingDirection == null) {
                this.facingDirection = Direction.UP;
            }
            this.f_19804_.m_135381_(DIRECTION, (Object)this.facingDirection);
            this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(this.speed));
            this.f_19804_.m_135381_(TICKS_ALIVE, (Object)this.ticksAlive);
            this.f_19804_.m_135381_(SOURCE, (Object)this.source);
            this.f_19804_.m_135381_(PASSED_THROUGH_GATEWAY, (Object)this.passedThroughGate);
            this.f_19804_.m_135381_(PASSED_THROUGH_SWITCH, (Object)this.passedThroughSwitch);
            this.f_19804_.m_135381_(SWITCH_DIRECTION, (Object)this.switchDirection);
            RadiationSystem.addRadiationSource((Level)this.f_19853_, (SimpleRadiationSource)new SimpleRadiationSource(1000.0, 1.0, 2, true, 0, this.m_20183_(), false, false));
        } else {
            this.facingDirection = (Direction)this.f_19804_.m_135370_(DIRECTION);
            this.speed = ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
            this.ticksAlive = (Integer)this.f_19804_.m_135370_(TICKS_ALIVE);
            this.source = (BlockPos)this.f_19804_.m_135370_(SOURCE);
            this.passedThroughGate = (Boolean)this.f_19804_.m_135370_(PASSED_THROUGH_GATEWAY);
            this.passedThroughSwitch = (Boolean)this.f_19804_.m_135370_(PASSED_THROUGH_SWITCH);
            this.switchDirection = (Direction)this.f_19804_.m_135370_(SWITCH_DIRECTION);
        }
        if (isServerside) {
            ++this.ticksAlive;
        }
        if (this.ticksAlive > NuclearConstants.PARTICLE_SURVIVAL_TICKS) {
            if (!isServerside) return;
            this.m_6089_();
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.speed, Explosion.BlockInteraction.BREAK);
            return;
        }
        if (this.facingDirection == null) return;
        if (this.facingDirection == Direction.UP) {
            return;
        }
        BlockEntity blockEntity = this.f_19853_.m_7702_(this.source);
        if (!(blockEntity instanceof TileParticleInjector)) {
            if (!isServerside) return;
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.speed, Explosion.BlockInteraction.BREAK);
            return;
        }
        TileParticleInjector injector = (TileParticleInjector)blockEntity;
        injector.addParticle(this);
        if (injector.handleCollision()) {
            return;
        }
        if (this.facingDirection == null) return;
        if (this.facingDirection == Direction.UP) return;
        if (this.facingDirection == Direction.DOWN) {
            return;
        }
        if (this.firstTick && isClientside) {
            this.firstTick = false;
            SoundBarrierMethods.playParticleSound(this);
        }
        int i = 0;
        int checks = (int)(Math.ceil(this.speed) * 2.0);
        float localSpeed = this.speed / (float)checks;
        while (i < checks) {
            Vec3 proposedMove;
            block59: {
                Direction nextDir;
                Direction oldDir;
                BlockState proposedMoveState;
                boolean startOfLoopStateIsBooster;
                BlockState startOfLoopState;
                block58: {
                    BlockPos proposedMoveBlockPos;
                    block54: {
                        block53: {
                            Direction clockwise;
                            Direction otherSwitchDirection;
                            block55: {
                                block56: {
                                    Direction counterClockwise;
                                    block57: {
                                        ++i;
                                        startOfLoopState = this.f_19853_.m_8055_(this.m_20183_());
                                        startOfLoopStateIsBooster = this.isBooster(startOfLoopState);
                                        boolean startofLoopStateIsDiode = this.isDiode(startOfLoopState);
                                        proposedMove = new Vec3(this.m_20185_() + (double)((float)this.facingDirection.m_122429_() * localSpeed), this.m_20186_(), this.m_20189_() + (double)((float)this.facingDirection.m_122431_() * localSpeed));
                                        if (startOfLoopStateIsBooster) {
                                            Direction boosterFacing = ((Direction)startOfLoopState.m_61143_((Property)VoltaicBlockStates.FACING)).m_122424_();
                                            FacingDirection boosterOrientation = (FacingDirection)((Object)startOfLoopState.m_61143_((Property)NuclearScienceBlockStates.FACINGDIRECTION));
                                            if (boosterOrientation == FacingDirection.RIGHT) {
                                                boosterFacing = boosterFacing.m_122427_();
                                            } else if (boosterOrientation == FacingDirection.LEFT) {
                                                boosterFacing = boosterFacing.m_122428_();
                                            }
                                            if (boosterFacing == this.facingDirection) {
                                                this.setSpeed(this.speed += 0.0033333332f);
                                            } else if (boosterFacing == this.facingDirection.m_122424_()) {
                                                this.setSpeed(this.speed += -0.02f);
                                            } else {
                                                this.setSpeed(this.speed *= 0.9f);
                                                this.facingDirection = boosterFacing;
                                                BlockPos floor = this.m_20183_();
                                                proposedMove = new Vec3((double)floor.m_123341_() + 0.5, (double)floor.m_123342_() + 0.5, (double)floor.m_123343_() + 0.5);
                                            }
                                        }
                                        if (this.speed < 0.0f) {
                                            this.setSpeed(this.speed *= -1.0f);
                                            this.facingDirection = this.facingDirection.m_122424_();
                                        }
                                        proposedMoveBlockPos = new BlockPos((int)Math.floor(proposedMove.m_7096_()), (int)Math.floor(proposedMove.m_7098_()), (int)Math.floor(proposedMove.m_7094_()));
                                        if (!startOfLoopStateIsBooster && !startofLoopStateIsDiode || this.passedThroughSwitch || !this.isSwitch(this.f_19853_.m_8055_(proposedMoveBlockPos))) break block54;
                                        if (!injector.particles[0].m_20148_().equals(this.m_20148_())) break block55;
                                        if (injector.particles[1] == null || !injector.particles[1].passedThroughSwitch) break block56;
                                        otherSwitchDirection = injector.particles[1].switchDirection;
                                        clockwise = this.facingDirection.m_122427_();
                                        counterClockwise = this.facingDirection.m_122428_();
                                        if (this.facingDirection == otherSwitchDirection || !this.f_19853_.m_8055_(proposedMoveBlockPos.m_121945_(this.facingDirection)).m_60795_()) break block57;
                                        this.switchDirection = this.facingDirection;
                                        this.passedThroughSwitch = true;
                                        break block53;
                                    }
                                    if (clockwise != otherSwitchDirection && this.f_19853_.m_8055_(proposedMoveBlockPos.m_121945_(clockwise)).m_60795_()) {
                                        this.switchDirection = clockwise;
                                        this.passedThroughSwitch = true;
                                        break block53;
                                    } else if (counterClockwise != otherSwitchDirection && this.f_19853_.m_8055_(proposedMoveBlockPos.m_121945_(counterClockwise)).m_60795_()) {
                                        this.switchDirection = counterClockwise;
                                        this.passedThroughSwitch = true;
                                        break block53;
                                    } else {
                                        if (!isServerside) return;
                                        this.f_19853_.m_46511_((Entity)this, proposedMove.m_7096_(), proposedMove.m_7098_(), proposedMove.m_7094_(), this.speed, Explosion.BlockInteraction.BREAK);
                                        this.m_6089_();
                                        return;
                                    }
                                }
                                Direction clockwise2 = this.facingDirection.m_122427_();
                                Direction counterClockwise = this.facingDirection.m_122428_();
                                if (this.f_19853_.m_8055_(proposedMoveBlockPos.m_121945_(this.facingDirection)).m_60795_()) {
                                    this.switchDirection = this.facingDirection;
                                    this.passedThroughSwitch = true;
                                    break block53;
                                } else if (this.f_19853_.m_8055_(proposedMoveBlockPos.m_121945_(clockwise2)).m_60795_()) {
                                    this.switchDirection = clockwise2;
                                    this.passedThroughSwitch = true;
                                    break block53;
                                } else {
                                    if (!this.f_19853_.m_8055_(proposedMoveBlockPos.m_121945_(counterClockwise)).m_60795_()) {
                                        if (!isServerside) return;
                                        this.f_19853_.m_46511_((Entity)this, proposedMove.m_7096_(), proposedMove.m_7098_(), proposedMove.m_7094_(), this.speed, Explosion.BlockInteraction.BREAK);
                                        this.m_6089_();
                                        return;
                                    }
                                    this.switchDirection = counterClockwise;
                                    this.passedThroughSwitch = true;
                                }
                                break block53;
                            }
                            if (!injector.particles[1].m_20148_().equals(this.m_20148_())) {
                                if (!isServerside) return;
                                this.f_19853_.m_46511_((Entity)this, proposedMove.m_7096_(), proposedMove.m_7098_(), proposedMove.m_7094_(), this.speed, Explosion.BlockInteraction.BREAK);
                                this.m_6089_();
                                return;
                            }
                            if (!injector.particles[0].passedThroughSwitch) {
                                if (!isServerside) return;
                                this.f_19853_.m_46511_((Entity)this, proposedMove.m_7096_(), proposedMove.m_7098_(), proposedMove.m_7094_(), this.speed, Explosion.BlockInteraction.BREAK);
                                this.m_6089_();
                                return;
                            }
                            otherSwitchDirection = injector.particles[0].switchDirection;
                            clockwise = this.facingDirection.m_122427_();
                            Direction counterClockwise = this.facingDirection.m_122428_();
                            if (this.facingDirection != otherSwitchDirection && this.f_19853_.m_8055_(proposedMoveBlockPos.m_121945_(this.facingDirection)).m_60795_()) {
                                this.switchDirection = this.facingDirection;
                                this.passedThroughSwitch = true;
                            } else if (clockwise != otherSwitchDirection && this.f_19853_.m_8055_(proposedMoveBlockPos.m_121945_(clockwise)).m_60795_()) {
                                this.switchDirection = clockwise;
                                this.passedThroughSwitch = true;
                            } else if (counterClockwise != otherSwitchDirection && this.f_19853_.m_8055_(proposedMoveBlockPos.m_121945_(counterClockwise)).m_60795_()) {
                                this.switchDirection = counterClockwise;
                                this.passedThroughSwitch = true;
                            } else {
                                if (!isServerside) return;
                                this.f_19853_.m_46511_((Entity)this, proposedMove.m_7096_(), proposedMove.m_7098_(), proposedMove.m_7094_(), this.speed, Explosion.BlockInteraction.BREAK);
                                this.m_6089_();
                                return;
                            }
                        }
                        if (this.switchDirection != this.facingDirection) {
                            this.facingDirection = this.switchDirection;
                            proposedMove = new Vec3((double)proposedMoveBlockPos.m_123341_() + 0.5, (double)proposedMoveBlockPos.m_123342_() + 0.5, (double)proposedMoveBlockPos.m_123343_() + 0.5);
                        }
                    }
                    if (!(proposedMoveState = this.f_19853_.m_8055_(proposedMoveBlockPos)).m_60795_() && !this.isSwitch(proposedMoveState) && !this.isGateway(proposedMoveState) && !this.isDiode(proposedMoveState)) break block58;
                    int amount = 0;
                    for (Direction dir : Direction.values()) {
                        if (!this.f_19853_.m_8055_(proposedMoveBlockPos.m_121945_(dir)).m_204336_(NuclearScienceTags.Blocks.PARTICLE_CONTAINMENT)) continue;
                        ++amount;
                    }
                    if (amount < 4) {
                        if (!isServerside) return;
                        this.f_19853_.m_46511_((Entity)this, proposedMove.m_7096_(), proposedMove.m_7098_(), proposedMove.m_7094_(), this.speed, Explosion.BlockInteraction.BREAK);
                        this.m_6089_();
                        return;
                    }
                    BlockPos inFrontOfUs = proposedMoveBlockPos.m_121945_(this.facingDirection);
                    BlockState inFrontOfUsState = this.f_19853_.m_8055_(inFrontOfUs);
                    boolean canPassThroughGateway = this.canPassThroughGateway(this.f_19853_.m_7702_(inFrontOfUs), inFrontOfUsState);
                    if (canPassThroughGateway && !this.passedThroughGate) {
                        this.f_19853_.m_5594_(null, proposedMoveBlockPos, SoundEvents.f_12012_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.passedThroughGate = true;
                        injector.timeSinceSpawn += 5;
                    }
                    if (!(!inFrontOfUsState.m_204336_(NuclearScienceTags.Blocks.PARTICLE_CONTAINMENT) || this.isBooster(inFrontOfUsState) || this.isSwitch(inFrontOfUsState) || canPassThroughGateway || this.canPassThroughDiode(inFrontOfUsState, this.facingDirection))) {
                        Direction checkRot = this.facingDirection.m_122427_();
                        BlockPos relative = proposedMoveBlockPos.m_121945_(checkRot);
                        inFrontOfUsState = this.f_19853_.m_8055_(relative);
                        if (inFrontOfUsState.m_60795_() || this.isBooster(inFrontOfUsState) && !this.passedThroughSwitch || this.isSwitch(inFrontOfUsState) || this.canPassThroughGateway(this.f_19853_.m_7702_(relative), inFrontOfUsState) || this.canPassThroughDiode(inFrontOfUsState, checkRot)) {
                            this.facingDirection = checkRot;
                            proposedMove = new Vec3((double)proposedMoveBlockPos.m_123341_() + 0.5, (double)proposedMoveBlockPos.m_123342_() + 0.5, (double)proposedMoveBlockPos.m_123343_() + 0.5);
                            if (!this.passedThroughGate && !this.passedThroughSwitch) {
                                this.setSpeed(this.speed *= 0.9f);
                            }
                            break block59;
                        } else {
                            checkRot = this.facingDirection.m_122428_();
                            relative = proposedMoveBlockPos.m_121945_(checkRot);
                            inFrontOfUsState = this.f_19853_.m_8055_(relative);
                            if (!(inFrontOfUsState.m_60795_() || this.isBooster(inFrontOfUsState) || this.passedThroughSwitch || this.isSwitch(inFrontOfUsState) || this.canPassThroughGateway(this.f_19853_.m_7702_(relative), inFrontOfUsState) || this.canPassThroughDiode(inFrontOfUsState, checkRot))) {
                                if (!isServerside) return;
                                this.f_19853_.m_46511_((Entity)this, proposedMove.m_7096_(), proposedMove.m_7098_(), proposedMove.m_7094_(), this.speed, Explosion.BlockInteraction.BREAK);
                                this.m_6089_();
                                return;
                            }
                            this.facingDirection = checkRot;
                            if (!this.passedThroughGate && !this.passedThroughSwitch) {
                                this.setSpeed(this.speed *= 0.9f);
                            }
                            proposedMove = new Vec3((double)proposedMoveBlockPos.m_123341_() + 0.5, (double)proposedMoveBlockPos.m_123342_() + 0.5, (double)proposedMoveBlockPos.m_123343_() + 0.5);
                        }
                    }
                    break block59;
                }
                boolean checkIsBooster = this.isBooster(proposedMoveState) && startOfLoopStateIsBooster;
                boolean explode = false;
                if (checkIsBooster && (oldDir = (Direction)startOfLoopState.m_61143_((Property)VoltaicBlockStates.FACING)) != (nextDir = (Direction)proposedMoveState.m_61143_((Property)VoltaicBlockStates.FACING))) {
                    FacingDirection face = (FacingDirection)((Object)startOfLoopState.m_61143_((Property)NuclearScienceBlockStates.FACINGDIRECTION));
                    if (face == FacingDirection.RIGHT) {
                        oldDir = oldDir.m_122427_();
                    } else if (face == FacingDirection.LEFT) {
                        oldDir = oldDir.m_122428_();
                    }
                    if (oldDir != nextDir) {
                        explode = true;
                    }
                }
                if (explode) {
                    if (!isServerside) return;
                    this.f_19853_.m_46511_((Entity)this, proposedMove.m_7096_(), proposedMove.m_7098_(), proposedMove.m_7094_(), this.speed, Explosion.BlockInteraction.BREAK);
                    this.m_6089_();
                    return;
                }
            }
            this.m_146884_(proposedMove);
        }
    }

    public boolean isBooster(BlockState state) {
        return state.m_60713_((Block)NuclearScienceBlocks.BLOCK_ELECTORMAGNETICBOOSTER.get());
    }

    public boolean isSwitch(BlockState state) {
        return state.m_60713_((Block)NuclearScienceBlocks.BLOCK_ELECTROMAGNETICSWITCH.get());
    }

    public boolean isGateway(BlockState state) {
        return state.m_60713_((Block)NuclearScienceBlocks.BLOCK_ELECTROMAGNETICGATEWAY.get());
    }

    public boolean isDiode(BlockState state) {
        return state.m_60713_((Block)NuclearScienceBlocks.BLOCK_ELECTROMAGNETICDIODE.get());
    }

    public boolean canPassThroughGateway(BlockEntity entity, BlockState state) {
        TileElectromagneticGateway gateway;
        return this.isGateway(state) && entity instanceof TileElectromagneticGateway && (gateway = (TileElectromagneticGateway)entity).mayPassThrough(this.speed);
    }

    public boolean canPassThroughDiode(BlockState state, Direction facing) {
        return this.isDiode(state) && state.m_61143_((Property)VoltaicBlockStates.FACING) == facing;
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_7378_(CompoundTag compound) {
        this.source = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("injector"));
        this.passedThroughGate = compound.m_128471_("passedthroughgate");
        this.ticksAlive = compound.m_128451_("ticksalive");
        this.facingDirection = Direction.values()[compound.m_128451_("facing")];
        this.switchDirection = Direction.values()[compound.m_128451_("switch")];
        this.speed = compound.m_128457_("speed");
        this.passedThroughSwitch = compound.m_128471_("passedthroughswitch");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("injector", (Tag)NbtUtils.m_129224_((BlockPos)this.source));
        compound.m_128379_("passedthroughgate", this.passedThroughGate);
        compound.m_128405_("ticksalive", this.ticksAlive);
        compound.m_128405_("facing", this.facingDirection.ordinal());
        compound.m_128350_("speed", this.speed);
        compound.m_128405_("switch", this.switchDirection.ordinal());
        compound.m_128379_("passedthroughswitch", this.passedThroughSwitch);
    }

    protected Component m_5677_() {
        return Component.m_237115_((String)"entity.particle");
    }

    public void setSpeed(float speed) {
        float sign = Math.signum(speed);
        if (speed > 2.0f || speed < -2.0f) {
            speed = 2.0f * sign;
        }
        this.speed = speed;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

