/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet.type.server;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.common.packet.type.server.ServerBarrierMethods;
import voltaic.api.codec.StreamCodec;

public class PacketDeleteFrequency {
    public static final StreamCodec<ByteBuf, PacketDeleteFrequency> CODEC = new StreamCodec<ByteBuf, PacketDeleteFrequency>(){

        public PacketDeleteFrequency decode(ByteBuf buf) {
            return new PacketDeleteFrequency((UUID)StreamCodec.UUID.decode((Object)buf), (TunnelFrequency)TunnelFrequency.STREAM_CODEC.decode((Object)buf));
        }

        public void encode(ByteBuf buf, PacketDeleteFrequency packet) {
            StreamCodec.UUID.encode((Object)buf, (Object)packet.requester);
            TunnelFrequency.STREAM_CODEC.encode((Object)buf, (Object)packet.frequency);
        }
    };
    private final UUID requester;
    private final TunnelFrequency frequency;

    public PacketDeleteFrequency(UUID requester, TunnelFrequency frequency) {
        this.requester = requester;
        this.frequency = frequency;
    }

    public static void handle(PacketDeleteFrequency message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ServerBarrierMethods.deleteFrequency(message.requester, message.frequency));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketDeleteFrequency pkt, FriendlyByteBuf buf) {
        CODEC.encode((Object)buf, (Object)pkt);
    }

    public static PacketDeleteFrequency decode(FriendlyByteBuf buf) {
        return (PacketDeleteFrequency)CODEC.decode((Object)buf);
    }
}

