/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.world.ForgeChunkManager;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.Voltaic;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileChunkloader
extends GenericTile {
    public TileChunkloader(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_CHUNKLOADER.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
    }

    public void tickServer(ComponentTickable tickable) {
    }

    private void updateChunks(boolean load, Level world, BlockPos pos) {
        int j;
        int i;
        int offset = 1;
        ChunkPos currChunkPos = world.m_46865_(pos).m_7697_();
        int lowerXOffset = currChunkPos.f_45578_ - offset;
        int lowerZOffset = currChunkPos.f_45579_ - offset;
        int delta = currChunkPos.f_45578_ + offset - lowerXOffset;
        BlockPos[][] ownerPos = new BlockPos[delta + 1][delta + 1];
        BlockPos bottomLeft = pos.m_7918_(-16 * offset, 0, -16 * offset);
        for (i = 0; i <= delta; ++i) {
            for (j = 0; j <= delta; ++j) {
                ownerPos[i][j] = bottomLeft.m_7918_(16 * i, 0, 16 * j);
            }
        }
        for (i = 0; i <= delta; ++i) {
            for (j = 0; j <= delta; ++j) {
                ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)world), (String)"nuclearscience", (BlockPos)ownerPos[i][j], (int)(lowerXOffset + i), (int)(lowerZOffset + j), (boolean)load, (boolean)true);
                String action = load ? "loading" : "unloading";
                Voltaic.LOGGER.info(action + " chunk at " + lowerXOffset + i + "," + lowerZOffset + j);
            }
        }
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.f_58857_.m_5776_()) {
            this.updateChunks(false, this.m_58904_(), this.m_58899_());
        }
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (!this.f_58857_.m_5776_()) {
            this.updateChunks(true, this.m_58904_(), this.m_58899_());
        }
    }
}

