/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import nuclearscience.common.inventory.container.ContainerFalloutScrubber;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.util.BlockPosVolume;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileFalloutScrubber
extends GenericTile {
    private static final int FLUID_USAGE_PER_TICK = 1;
    public static final int RANGE = 30;
    public static final double DISIPATION = 1.0;
    public final SingleProperty<Boolean> active = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "active", (Object)false));
    private final SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));
    private final BlockPosVolume area;

    public TileFalloutScrubber(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_FALLOUTSCRUBBER.get(), worldPos, blockState);
        this.area = new BlockPosVolume(worldPos.m_7918_(-30, -30, -30), worldPos.m_7918_(30, 30, 30));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).maxJoules(NuclearConstants.FALLOUT_SCRUBBER_USAGE_PER_TICK * 20.0).voltage(120.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentFluidHandlerMulti((GenericTile)this).setInputTanks(2, new int[]{100, 100}).setInputFluidTags(new TagKey[]{FluidTags.f_13131_, NuclearScienceTags.Fluids.DECONTAMINATION_FOAM}).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}));
        this.addComponent((IComponent)new ComponentContainerProvider("falloutscrubber", (GenericTile)this).createMenu((id, player) -> new ContainerFalloutScrubber((int)id, (Inventory)player, (Container)new SimpleContainer(new ItemStack[0]), (ContainerData)this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tickable) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            this.active.setValue((Object)false);
            RadiationSystem.removeDisipation((Level)this.m_58904_(), (BlockPosVolume)this.area);
            return;
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < NuclearConstants.FALLOUT_SCRUBBER_USAGE_PER_TICK) {
            this.active.setValue((Object)false);
            RadiationSystem.removeDisipation((Level)this.m_58904_(), (BlockPosVolume)this.area);
            return;
        }
        ComponentFluidHandlerMulti multi = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
        PropertyFluidTank[] tanks = multi.getInputTanks();
        if (tanks[0].isEmpty() || tanks[0].getFluidAmount() < 1 || tanks[1].isEmpty() || tanks[1].getFluidAmount() < 1) {
            this.active.setValue((Object)false);
            RadiationSystem.removeDisipation((Level)this.m_58904_(), (BlockPosVolume)this.area);
            return;
        }
        this.active.setValue((Object)true);
        tanks[0].drain(1, IFluidHandler.FluidAction.EXECUTE);
        tanks[1].drain(1, IFluidHandler.FluidAction.EXECUTE);
        electro.setJoulesStored(electro.getJoulesStored() - NuclearConstants.FALLOUT_SCRUBBER_USAGE_PER_TICK);
        RadiationSystem.addDisipation((Level)this.m_58904_(), (double)1.0, (BlockPosVolume)this.area);
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (!this.f_58857_.f_46443_) {
            this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_46753_(this.m_58899_()));
        }
    }
}

