/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.accelerator;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.entity.EntityParticle;
import nuclearscience.common.inventory.container.ContainerParticleInjector;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.Voltaic;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;
import voltaic.prefab.utilities.object.Location;

public class TileParticleInjector
extends GenericTile {
    public static final int INPUT_SLOT = 0;
    public static final int ELECTRO_CELL_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    public final EntityParticle[] particles = new EntityParticle[2];
    public int timeSinceSpawn = 0;
    public final SingleProperty<Boolean> usingGateway = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "usinggateway", (Object)false));
    public final SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasredstonesignal", (Object)false));

    public TileParticleInjector(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_PARTICLEINJECTOR.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickCommon(this::tickCommon));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(2).outputs(1)).valid((index, stack, i) -> index != 1 || stack.m_41720_() == NuclearScienceItems.ITEM_CELLELECTROMAGNETIC.get()).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1}).setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, new Integer[]{0, 1}).setDirectionsBySlot(Integer.valueOf(2), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.LEFT}));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(960.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).maxJoules(NuclearConstants.PARTICLEINJECTOR_USAGE_PER_PARTICLE));
        this.addComponent((IComponent)new ComponentContainerProvider("particleinjector", (GenericTile)this).createMenu((id, player) -> new ContainerParticleInjector((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private void tickCommon(ComponentTickable tickable) {
        if (this.particles[0] != null && !this.particles[0].m_6084_()) {
            this.particles[0] = null;
        }
        if (this.particles[1] != null && !this.particles[1].m_6084_()) {
            this.particles[1] = null;
        }
        if (this.particles[0] == null && this.particles[1] != null) {
            this.particles[0] = this.particles[1];
            this.particles[1] = null;
        }
    }

    private void tickServer(ComponentTickable componentTickable) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            return;
        }
        RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)((ComponentInventory)this.getComponent(IComponentType.Inventory)), (int)NuclearConstants.PARTICLE_INJECTOR_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)true, (boolean)false);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = inv.m_8020_(0);
        if (electro.getJoulesStored() < NuclearConstants.PARTICLEINJECTOR_USAGE_PER_PARTICLE || input.m_41619_()) {
            return;
        }
        if (this.timeSinceSpawn > 0) {
            --this.timeSinceSpawn;
            return;
        }
        if (((Boolean)this.usingGateway.getValue()).booleanValue() && this.particles[0] != null && !this.particles[0].passedThroughGate) {
            return;
        }
        if (!((Boolean)this.usingGateway.getValue()).booleanValue() && !this.f_58857_.m_8055_(this.f_58858_.m_121945_(this.getFacing())).m_60713_((Block)NuclearScienceBlocks.BLOCK_ELECTORMAGNETICBOOSTER.get())) {
            return;
        }
        if (this.particles[0] != null && this.particles[1] != null) {
            return;
        }
        ItemStack resultStack = inv.m_8020_(2);
        if (resultStack.m_41613_() >= resultStack.m_41741_()) {
            return;
        }
        this.timeSinceSpawn = NuclearConstants.DEFAULT_PARTICLE_COOLDOWN_TICKS;
        input.m_41774_(1);
        Direction dir = this.getFacing();
        EntityParticle particle = new EntityParticle(dir, this.f_58857_, new Location((double)((float)this.f_58858_.m_123341_() + 0.5f + (float)dir.m_122429_()), (double)((float)this.f_58858_.m_123342_() + 0.5f + (float)dir.m_122430_()), (double)((float)this.f_58858_.m_123343_() + 0.5f + (float)dir.m_122431_())), this.m_58899_());
        this.addParticle(particle);
        this.f_58857_.m_7967_((Entity)particle);
        electro.setJoulesStored(electro.getJoulesStored() - NuclearConstants.PARTICLEINJECTOR_USAGE_PER_PARTICLE);
    }

    public boolean handleCollision() {
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack resultStack = inv.m_8020_(2);
        ItemStack cellStack = inv.m_8020_(1);
        if (this.particles[0] == null || this.particles[1] == null) {
            return false;
        }
        EntityParticle one = this.particles[0];
        EntityParticle two = this.particles[1];
        if (one.m_20270_(two) >= 1.0f) {
            return false;
        }
        BlockPos pos = one.m_20183_();
        if (!this.f_58857_.m_5776_()) {
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.0f, 1.0f);
            one.m_142687_(Entity.RemovalReason.KILLED);
            two.m_142687_(Entity.RemovalReason.KILLED);
            Random random = Voltaic.RANDOM;
            for (int i = 0; i < 50; ++i) {
                double d0 = (double)pos.m_123341_() + random.nextDouble();
                double d1 = (double)pos.m_123342_() + random.nextDouble();
                double d2 = (double)pos.m_123343_() + random.nextDouble();
                double d3 = ((double)random.nextFloat() - 0.5) * 0.5;
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, 1, 0.0, 0.0, 0.0, d3);
            }
            if (!cellStack.m_41619_() && resultStack.m_41613_() < resultStack.m_41741_() && one.speed >= 1.0f && two.speed >= 1.0f) {
                double speedOfMax = Math.pow((double)(one.speed + two.speed) / 4.0, 2.0);
                if (speedOfMax > 0.999) {
                    if (resultStack.m_41720_() == NuclearScienceItems.ITEM_CELLDARKMATTER.get()) {
                        resultStack.m_41764_(resultStack.m_41613_() + 1);
                        cellStack.m_41774_(1);
                    } else if (resultStack.m_41619_()) {
                        inv.m_6836_(2, new ItemStack((ItemLike)NuclearScienceItems.ITEM_CELLDARKMATTER.get()));
                        cellStack.m_41774_(1);
                    }
                } else if (speedOfMax > this.f_58857_.f_46441_.m_188500_()) {
                    if (resultStack.m_41720_() == NuclearScienceItems.ITEM_CELLANTIMATTERSMALL.get()) {
                        resultStack.m_41764_(resultStack.m_41613_() + 1);
                        cellStack.m_41774_(1);
                    } else if (resultStack.m_41619_()) {
                        inv.m_6836_(2, new ItemStack((ItemLike)NuclearScienceItems.ITEM_CELLANTIMATTERSMALL.get()));
                        cellStack.m_41774_(1);
                    }
                }
            }
            this.particles[1] = null;
            this.particles[0] = null;
        }
        return true;
    }

    public void addParticle(EntityParticle particle) {
        if (this.particles[0] == null && this.particles[1] == null) {
            this.particles[0] = particle;
        }
        if (this.particles[0] != null) {
            if (this.particles[0].m_20148_().equals(particle.m_20148_())) {
                return;
            }
            if (this.particles[1] == null) {
                this.particles[1] = particle;
            }
        }
        if (this.particles[1] != null) {
            if (this.particles[1].m_20148_().equals(particle.m_20148_())) {
                return;
            }
            if (this.particles[0] == null) {
                this.particles[0] = particle;
            }
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("timesincespawn", this.timeSinceSpawn);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.timeSinceSpawn = compound.m_128451_("timesincespawn");
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (!this.f_58857_.m_5776_()) {
            this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_46753_(this.m_58899_()));
        }
    }
}

