/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.fission;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import nuclearscience.api.turbine.ISteamReceiver;
import nuclearscience.common.block.BlockMeltedReactor;
import nuclearscience.common.inventory.container.ContainerFissionReactorCore;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.reactor.fission.IFissionControlRod;
import nuclearscience.registers.NuclearScienceBlocks;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceRecipies;
import nuclearscience.registers.NuclearScienceSounds;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.common.recipe.VoltaicRecipe;
import voltaic.common.recipe.categories.item2item.Item2ItemRecipe;
import voltaic.common.recipe.recipeutils.CountableIngredient;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.registers.VoltaicDamageTypes;

public class TileFissionReactorCore
extends GenericTile {
    public static final int FUEL_ROD_COUNT = 4;
    public static final int DUETERIUM_SLOT = 4;
    public static final int OUTPUT_SLOT = 5;
    public static final int MELTDOWN_TEMPERATURE_ACTUAL = 5611;
    public static final int MELTDOWN_TEMPERATURE_CALC = 4407;
    public static final double WATER_TEMPERATURE = 10.0;
    public static final double AIR_TEMPERATURE = 15.0;
    public static final int STEAM_GEN_DIAMETER = 5;
    public static final int STEAM_GEN_HEIGHT = 2;
    private ISteamReceiver[][][] cachedReceivers = new ISteamReceiver[5][2][5];
    public SingleProperty<Double> temperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "temperature", (Object)15.0));
    public SingleProperty<Integer> fuelCount = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "fuelCount", (Object)0));
    public SingleProperty<Boolean> hasDeuterium = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasDeuterium", (Object)false));
    private CachedTileOutput controlRodCache;
    private int ticksOverheating = 0;
    private List<VoltaicRecipe> cachedRecipes;

    public TileFissionReactorCore(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_REACTORCORE.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickCommon(this::tickCommon).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(5).outputs(1)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1, 2, 3, 4}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BOTTOM, new Integer[]{5}));
        this.addComponent((IComponent)new ComponentContainerProvider("reactorcore", (GenericTile)this).createMenu((id, player) -> new ContainerFissionReactorCore((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        boolean hasWater;
        double decrease = ((Double)this.temperature.getValue() - 15.0) / 3000.0;
        if ((Integer)this.fuelCount.getValue() == 0) {
            decrease *= 25.0;
        }
        boolean bl = hasWater = !this.m_58900_().m_60819_().m_76178_();
        if (hasWater) {
            decrease += ((Double)this.temperature.getValue() - 10.0) / 5000.0;
        }
        if (decrease != 0.0) {
            this.temperature.setValue((Object)((Double)this.temperature.getValue() - (decrease < 0.001 && decrease > 0.0 ? 0.001 : (decrease > -0.001 && decrease < 0.0 ? -0.001 : decrease))));
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        if ((Integer)this.fuelCount.getValue() > 0) {
            Iterator iterator;
            double totstrength = (Double)this.temperature.getValue() * 10.0;
            int range = (int)(Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0);
            RadiationSystem.addRadiationSource((Level)this.m_58904_(), (SimpleRadiationSource)new SimpleRadiationSource(totstrength, 1.0, range, true, 1, this.m_58899_(), true, false));
            if (this.f_58857_.m_213780_().m_188501_() < 0.01f) {
                SoundEvent sound = switch (this.f_58857_.f_46441_.m_216332_(1, 6)) {
                    case 2 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_2.get();
                    case 3 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_3.get();
                    case 4 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_4.get();
                    case 5 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_5.get();
                    case 6 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_6.get();
                    default -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_1.get();
                };
                this.f_58857_.m_5594_(null, this.m_58899_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (this.f_58857_.m_6106_().m_6793_() % 10L == 0L && (Double)this.temperature.getValue() > 100.0) {
                AABB bb = AABB.m_165882_((Vec3)new Vec3((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()), (double)4.0, (double)4.0, (double)4.0);
                List list = this.f_58857_.m_45976_(LivingEntity.class, bb);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    LivingEntity living = (LivingEntity)iterator.next();
                    if (!this.f_58857_.m_8055_(living.m_20097_()).m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                    living.m_6469_(DamageSource.f_19312_, 3.0f);
                }
            }
            if (this.controlRodCache == null) {
                this.controlRodCache = new CachedTileOutput(this.m_58904_(), this.f_58858_.m_7495_());
            }
            if (tickable.getTicks() % 10L == 0L && !this.controlRodCache.valid()) {
                this.controlRodCache.update(this.f_58858_.m_7495_());
            }
            int insertion = 0;
            if (this.controlRodCache.valid() && (iterator = this.controlRodCache.getSafe()) instanceof IFissionControlRod) {
                IFissionControlRod rod = (IFissionControlRod)((Object)iterator);
                insertion = rod.getInsertion();
            }
            double insertDecimal = 1.0 - (double)insertion / 100.0;
            if ((double)this.f_58857_.f_46441_.m_188501_() < insertDecimal) {
                for (int slot = 0; slot < 4; ++slot) {
                    ItemStack fuelRod = inv.m_8020_(slot);
                    fuelRod.m_41721_((int)((long)(fuelRod.m_41773_() + 1) + Math.round((Double)this.temperature.getValue()) / 4407L));
                    if (fuelRod.m_41619_() || fuelRod.m_41773_() < fuelRod.m_41776_()) continue;
                    inv.m_6836_(slot, new ItemStack((ItemLike)NuclearScienceItems.ITEM_FUELSPENT.get()));
                }
            }
            this.temperature.setValue((Object)((Double)this.temperature.getValue() + (4407.0 * insertDecimal * (0.25 * ((double)((Integer)this.fuelCount.getValue()).intValue() / 2.0) + this.f_58857_.f_46441_.m_188500_() / 5.0) - (Double)this.temperature.getValue()) / (200.0 + 20.0 * (hasWater ? 4.0 : 1.0))));
            if ((Double)this.temperature.getValue() > (double)(5611 + this.f_58857_.f_46441_.m_188503_(50)) && (Integer)this.fuelCount.getValue() > 0) {
                ++this.ticksOverheating;
                if (this.ticksOverheating > 200) {
                    this.meltdown();
                }
            }
        } else {
            this.ticksOverheating = 0;
        }
        this.temperature.setValue((Object)Math.max(15.0, (Double)this.temperature.getValue()));
        if (((Boolean)this.hasDeuterium.getValue()).booleanValue() && (Integer)this.fuelCount.getValue() > 0 && (double)this.f_58857_.f_46441_.m_188501_() < 1.0 / (5288400.0 / (Double)this.temperature.getValue())) {
            this.processFissReact(inv);
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        if (tickable.getTicks() % 20L == 0L) {
            this.f_58857_.m_5518_().m_7174_(this.f_58858_);
        }
        this.produceSteam();
    }

    public void meltdown() {
        int radius = 2;
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPos ppos = new BlockPos(this.f_58858_.m_123341_() + i, this.f_58858_.m_123342_() + j, this.f_58858_.m_123343_() + k);
                    BlockState state = this.f_58857_.m_8055_(ppos);
                    if (state.m_60734_() != Blocks.f_49990_) continue;
                    this.f_58857_.m_46597_(ppos, Blocks.f_50016_.m_49966_());
                }
            }
        }
        this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
        Explosion actual = new Explosion(this.f_58857_, null, VoltaicDamageTypes.RADIATION, null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 20.0f, true, Explosion.BlockInteraction.NONE);
        radius = 3 * (Integer)this.fuelCount.getValue();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    double distance;
                    BlockPos ppos = new BlockPos(this.f_58858_.m_123341_() + i, this.f_58858_.m_123342_() + j, this.f_58858_.m_123343_() + k);
                    BlockState state = this.f_58857_.m_8055_(ppos);
                    if (!(state.m_60734_().getExplosionResistance(state, (BlockGetter)this.f_58857_, ppos, actual) < (float)radius) || !((distance = Math.sqrt(i * i + j * j + k * k)) < (double)radius) || !((double)this.f_58857_.f_46441_.m_188501_() < 1.0 - 1.0E-4 * distance * distance * distance) || !((double)this.f_58857_.f_46441_.m_188501_() < 0.9)) continue;
                    this.f_58857_.m_8055_(ppos).onBlockExploded(this.f_58857_, ppos, actual);
                }
            }
        }
        this.f_58857_.m_46511_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 20.0f, Explosion.BlockInteraction.BREAK);
        this.f_58857_.m_46597_(this.f_58858_, ((BlockMeltedReactor)((Object)NuclearScienceBlocks.BLOCK_MELTEDREACTOR.get())).m_49966_());
    }

    protected void produceSteam() {
        if ((Double)this.temperature.getValue() <= 400.0) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5; ++k) {
                    boolean isFaceWater;
                    boolean isReactor2d;
                    boolean bl = isReactor2d = i - 2 == 0 && k - 2 == 0;
                    if (isReactor2d && j == 0) {
                        if (this.f_58857_.f_46443_ || !((double)this.f_58857_.f_46441_.m_188501_() < (Double)this.temperature.getValue() / 4407000.0) || !this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)BlockStateProperties.f_61362_)) continue;
                        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    int offsetX = this.f_58858_.m_123341_() + i - 2;
                    int offsetY = this.f_58858_.m_123342_() + j;
                    int offsetZ = this.f_58858_.m_123343_() + k - 2;
                    BlockPos offpos = new BlockPos(offsetX, offsetY, offsetZ);
                    if (!TileFissionReactorCore.isStillWater(this.m_58904_(), offpos)) continue;
                    boolean bl2 = isFaceWater = TileFissionReactorCore.isStillWater(this.f_58857_, new BlockPos(offsetX, this.f_58858_.m_123342_(), this.f_58858_.m_123343_())) || TileFissionReactorCore.isStillWater(this.f_58857_, new BlockPos(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), offsetZ)) || isReactor2d;
                    if (!isFaceWater) continue;
                    if (!this.f_58857_.f_46443_) {
                        ISteamReceiver turbine = this.cachedReceivers[i][j][k];
                        if (turbine != null) {
                            if (turbine.isStillValid()) {
                                this.cachedReceivers[i][j][k] = null;
                            }
                            double temp = (Double)this.temperature.getValue();
                            turbine.receiveSteam((int)temp, (int)(NuclearConstants.FISSIONREACTOR_MAXENERGYTARGET / (500.0 * (5611.0 / (Double)this.temperature.getValue()))));
                        }
                        if ((double)this.f_58857_.f_46441_.m_188501_() < (Double)this.temperature.getValue() / 4407000.0) {
                            this.f_58857_.m_46597_(offpos, Blocks.f_50016_.m_49966_());
                            continue;
                        }
                        if (turbine != null && !turbine.isStillValid()) continue;
                        BlockEntity above = this.f_58857_.m_7702_(new BlockPos(offsetX, offsetY + 1, offsetZ));
                        if (above instanceof ISteamReceiver) {
                            ISteamReceiver trb;
                            this.cachedReceivers[i][j][k] = trb = (ISteamReceiver)above;
                            continue;
                        }
                        this.cachedReceivers[i][j][k] = null;
                        continue;
                    }
                    if (!this.f_58857_.f_46443_ || !((double)this.f_58857_.f_46441_.m_188501_() < (Double)this.temperature.getValue() / 16833.0)) continue;
                    double offsetFX = (double)offsetX + this.f_58857_.f_46441_.m_188500_() / 2.0 * (double)(this.f_58857_.f_46441_.m_188499_() ? -1 : 1);
                    double offsetFY = (double)offsetY + this.f_58857_.f_46441_.m_188500_() / 2.0 * (double)(this.f_58857_.f_46441_.m_188499_() ? -1 : 1);
                    double offsetFZ = (double)offsetZ + this.f_58857_.f_46441_.m_188500_() / 2.0 * (double)(this.f_58857_.f_46441_.m_188499_() ? -1 : 1);
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, offsetFX + 0.5, offsetFY + (double)0.2f, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                    if (this.f_58857_.f_46441_.m_188503_(3) != 0) continue;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void processFissReact(ComponentInventory inv) {
        ItemStack input = inv.m_8020_(4);
        ItemStack output = inv.m_8020_(5);
        if (input.m_41619_()) {
            return;
        }
        if (this.cachedRecipes == null || this.cachedRecipes.isEmpty()) {
            this.cachedRecipes = VoltaicRecipe.findRecipesbyType((RecipeType)((RecipeType)NuclearScienceRecipies.FISSION_REACTOR_TYPE.get()), (Level)this.f_58857_);
        }
        for (VoltaicRecipe iRecipe : this.cachedRecipes) {
            Item2ItemRecipe recipe = (Item2ItemRecipe)iRecipe;
            for (CountableIngredient ing : recipe.getCountedIngredients()) {
                if (!ing.test(input)) continue;
                if (output.m_41619_()) {
                    inv.m_6836_(5, recipe.getItemRecipeOutput().m_41777_());
                    input.m_41774_(((CountableIngredient)recipe.getCountedIngredients().get(0)).getStackSize());
                    continue;
                }
                if (output.m_41613_() > output.m_41741_() + recipe.getItemRecipeOutput().m_41613_()) continue;
                output.m_41769_(recipe.getItemRecipeOutput().m_41613_());
                input.m_41774_(((CountableIngredient)recipe.getCountedIngredients().get(0)).getStackSize());
            }
        }
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (slot == -1 || slot < 4) {
            this.fuelCount.setValue((Object)0);
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = inv.m_8020_(i);
                int fuelValue = 0;
                if (stack.m_41720_() == NuclearScienceItems.ITEM_FUELLEUO2.get()) {
                    fuelValue = 2;
                } else if (stack.m_41720_() == NuclearScienceItems.ITEM_FUELHEUO2.get()) {
                    fuelValue = 3;
                } else if (stack.m_41720_() == NuclearScienceItems.ITEM_FUELPLUTONIUM.get()) {
                    fuelValue = 2;
                }
                this.fuelCount.setValue((Object)((Integer)this.fuelCount.getValue() + fuelValue));
            }
        }
        if (slot == -1 || slot == 4) {
            this.hasDeuterium.setValue((Object)(!inv.m_8020_(4).m_41619_() ? 1 : 0));
        }
    }

    public static boolean isStillWater(Level world, BlockPos pos) {
        FluidState fluidState = world.m_6425_(pos);
        return fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_();
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ticksoverheating", this.ticksOverheating);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.ticksOverheating = compound.m_128451_("ticksoverheating");
    }

    public static double getActualTemp(double temperature) {
        return temperature / 4.0 + 15.0;
    }
}

