/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import nuclearscience.common.tile.TileChemicalExtractor;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.utilities.RenderingUtils;

public class RenderChemicalExtractor
extends AbstractTileRenderer<TileChemicalExtractor> {
    private static final float DELTA_Y = 0.4375f;

    public RenderChemicalExtractor(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileChemicalExtractor tile, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int overlay) {
        matrix.m_85836_();
        Direction facing = tile.getFacing();
        ComponentFluidHandlerMulti multi = (ComponentFluidHandlerMulti)tile.getComponent(IComponentType.FluidHandler);
        VertexConsumer builder = buffer.m_6299_(Sheets.m_110792_());
        PropertyFluidTank input = multi.getInputTanks()[0];
        if (input.isEmpty()) {
            matrix.m_85849_();
            return;
        }
        AABB box = null;
        int i = 0;
        float maxY = 0.4375f * ((float)input.getFluidAmount() / 5000.0f) + 0.3125f;
        if (facing == Direction.NORTH || facing != Direction.EAST && facing == Direction.SOUTH) {
            box = new AABB(0.16875, 0.3125, 0.1375, 0.26875, (double)maxY, 0.2375);
            for (i = 0; i < 4; ++i) {
                RenderingUtils.renderFluidBox((PoseStack)matrix, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                box = box.m_82386_(0.1875, 0.0, 0.0);
            }
            box = new AABB(0.16875, 0.3125, 0.7625, 0.26875, (double)maxY, 0.8625);
            for (i = 0; i < 4; ++i) {
                RenderingUtils.renderFluidBox((PoseStack)matrix, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                box = box.m_82386_(0.1875, 0.0, 0.0);
            }
        } else {
            box = new AABB(0.1375, 0.3125, 0.16875, 0.2375, (double)maxY, 0.26875);
            for (i = 0; i < 4; ++i) {
                RenderingUtils.renderFluidBox((PoseStack)matrix, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                box = box.m_82386_(0.0, 0.0, 0.1875);
            }
            box = new AABB(0.7625, 0.3125, 0.16875, 0.8625, (double)maxY, 0.26875);
            for (i = 0; i < 4; ++i) {
                RenderingUtils.renderFluidBox((PoseStack)matrix, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)input.getFluid(), (int)combinedLight, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
                box = box.m_82386_(0.0, 0.0, 0.1875);
            }
        }
        matrix.m_85849_();
    }
}

