/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import nuclearscience.client.screen.util.GenericInterfaceBoundScreen;
import nuclearscience.common.inventory.container.ContainerThermometerModule;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileThermometerModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileFissionInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileMSInterface;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentCustomRender;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenThermometerModule
extends GenericInterfaceBoundScreen<ContainerThermometerModule> {
    public ScreenComponentButton<?> modeButton;
    public ScreenComponentButton<?> invertButton;
    public ScreenComponentEditBox targetTempBox;
    private boolean hidden = false;
    private boolean needsUpdate = true;

    public ScreenThermometerModule(ContainerThermometerModule container, Inventory inv, Component title) {
        super(container, inv, title, true, false);
        for (int i = 0; i < ((ContainerThermometerModule)this.m_6262_()).f_38839_.size(); ++i) {
            ((SlotGeneric)((ContainerThermometerModule)this.m_6262_()).f_38839_.get(i)).setActive(false);
        }
        this.addComponent((AbstractScreenComponent)new ScreenComponentCustomRender(0, 0, graphics -> {
            if (this.hidden) {
                return;
            }
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.f_97732_).getSafeHost();
            if (tile == null) {
                this.modeButton.setVisible(false);
                this.invertButton.setVisible(false);
                this.targetTempBox.setVisible(false);
                return;
            }
            GenericTileInterface.InterfaceType type = GenericTileInterface.InterfaceType.values()[(Integer)tile.interfaceType.getValue()];
            Font font = this.getFontRenderer();
            int guiWidth = (int)this.getGuiWidth();
            int guiHeight = (int)this.getGuiHeight();
            graphics.m_280509_(guiWidth + 17, guiHeight + 17, guiWidth + 159, guiHeight + 149, new Color(112, 112, 112, 255).color());
            if (!((Boolean)tile.linked.getValue()).booleanValue() || type == GenericTileInterface.InterfaceType.NONE || ((BlockPos)tile.interfaceLocation.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
                graphics.m_280614_(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                this.modeButton.setVisible(false);
                this.invertButton.setVisible(false);
                this.targetTempBox.setVisible(false);
                return;
            }
            BlockEntity blockEntity = tile.m_58904_().m_7702_((BlockPos)tile.interfaceLocation.getValue());
            double currTemp = 0.0;
            switch (type) {
                case FISSION: {
                    if (!(blockEntity instanceof TileFissionInterface)) {
                        graphics.m_280614_(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                        this.modeButton.setVisible(false);
                        this.invertButton.setVisible(false);
                        this.targetTempBox.setVisible(false);
                        return;
                    }
                    TileFissionInterface fissionInterface = (TileFissionInterface)blockEntity;
                    if (fissionInterface.reactor == null || !fissionInterface.reactor.valid() || !(fissionInterface.reactor.getSafe() instanceof TileFissionReactorCore)) {
                        graphics.m_280614_(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                        this.modeButton.setVisible(false);
                        this.invertButton.setVisible(false);
                        this.targetTempBox.setVisible(false);
                        return;
                    }
                    TileFissionReactorCore fissionCore = (TileFissionReactorCore)((Object)((Object)fissionInterface.reactor.getSafe()));
                    currTemp = TileFissionReactorCore.getActualTemp((Double)fissionCore.temperature.getValue());
                    break;
                }
                case MS: {
                    if (!(blockEntity instanceof TileMSInterface)) {
                        graphics.m_280614_(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                        this.modeButton.setVisible(false);
                        this.invertButton.setVisible(false);
                        this.targetTempBox.setVisible(false);
                        return;
                    }
                    TileMSInterface msInterface = (TileMSInterface)blockEntity;
                    if (msInterface.reactor == null || !msInterface.reactor.valid() || !(msInterface.reactor.getSafe() instanceof TileMSReactorCore)) {
                        graphics.m_280614_(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                        this.modeButton.setVisible(false);
                        this.invertButton.setVisible(false);
                        this.targetTempBox.setVisible(false);
                        return;
                    }
                    TileMSReactorCore msCore = (TileMSReactorCore)((Object)((Object)msInterface.reactor.getSafe()));
                    currTemp = (Double)msCore.temperature.getValue();
                    break;
                }
                default: {
                    graphics.m_280614_(font, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), guiWidth + 20, guiHeight + 20, Color.TEXT_GRAY.color(), false);
                    this.modeButton.setVisible(false);
                    this.invertButton.setVisible(false);
                    this.targetTempBox.setVisible(false);
                    return;
                }
            }
            this.modeButton.setVisible(true);
            this.invertButton.setVisible(true);
            this.targetTempBox.setVisible(true);
            graphics.m_280480_(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
            graphics.m_280614_(font, (Component)NuclearTextUtils.gui("logisticsnetwork.temperature", ChatFormatter.getChatDisplayShort((double)currTemp, (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS).m_130940_(ChatFormatting.GOLD)), guiWidth + 20, guiHeight + 45, Color.TEXT_GRAY.color(), false);
            MutableComponent text = NuclearTextUtils.gui("logisticsnetwork.outputmode", new Object[0]);
            int width = font.m_92852_((FormattedText)text);
            int maxWidth = 68;
            int offset = (maxWidth - width) / 2;
            graphics.m_280614_(font, (Component)text, guiWidth + 20 + offset, guiHeight + 60, Color.TEXT_GRAY.color(), false);
            text = NuclearTextUtils.gui("logisticsnetwork.signalmode", new Object[0]);
            width = font.m_92852_((FormattedText)text);
            offset = (maxWidth - width) / 2;
            graphics.m_280614_(font, (Component)text, guiWidth + 20 + offset + maxWidth, guiHeight + 60, Color.TEXT_GRAY.color(), false);
            graphics.m_280614_(font, (Component)NuclearTextUtils.gui("logisticsnetwork.targettemp", new Object[0]), guiWidth + 20, guiHeight + 100, Color.TEXT_GRAY.color(), false);
            graphics.m_280614_(font, (Component)DisplayUnits.TEMPERATURE_CELCIUS.getSymbol().m_6881_().m_130940_(ChatFormatting.WHITE), guiWidth + 20 + 120 + 2, guiHeight + 113, Color.TEXT_GRAY.color(), false);
            graphics.m_280614_(font, (Component)NuclearTextUtils.gui("logisticsnetwork.signalstrength", Component.m_237113_((String)("" + tile.redstoneSignal.getValue())).m_130940_(ChatFormatting.WHITE)), guiWidth + 20, guiHeight + 135, Color.TEXT_GRAY.color(), false);
        }));
        this.modeButton = new ScreenComponentButton(20, 70, 68, 20).setLabel(() -> {
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.f_97732_).getSafeHost();
            if (tile == null) {
                return Component.m_237119_();
            }
            return switch (TileThermometerModule.Mode.values()[(Integer)tile.mode.getValue()]) {
                case TileThermometerModule.Mode.BUILD_UP -> NuclearTextUtils.gui("logisticsnetwork.modebuildup", new Object[0]);
                case TileThermometerModule.Mode.CONSTANT -> NuclearTextUtils.gui("logisticsnetwork.modeconstant", new Object[0]);
                default -> Component.m_237119_();
            };
        }).setOnPress(button -> {
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.f_97732_).getSafeHost();
            if (tile == null) {
                return;
            }
            int currMode = (Integer)tile.mode.getValue();
            currMode = currMode >= TileThermometerModule.Mode.values().length - 1 ? 0 : ++currMode;
            tile.mode.setValue((Object)currMode);
        });
        this.addComponent((AbstractScreenComponent)this.modeButton);
        this.invertButton = new ScreenComponentButton(88, 70, 68, 20).setLabel(() -> {
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.f_97732_).getSafeHost();
            if (tile == null) {
                return Component.m_237119_();
            }
            return (Boolean)tile.inverted.getValue() != false ? NuclearTextUtils.gui("logisticsnetwork.signalinverted", new Object[0]) : NuclearTextUtils.gui("logisticsnetwork.signalnormal", new Object[0]);
        }).setOnPress(button -> {
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.f_97732_).getSafeHost();
            if (tile == null) {
                return;
            }
            tile.inverted.setValue((Object)((Boolean)tile.inverted.getValue() == false ? 1 : 0));
        });
        this.addComponent((AbstractScreenComponent)this.invertButton);
        this.targetTempBox = new ScreenComponentEditBox(20, 110, 120, 15, this.getFontRenderer()).setFilter(ScreenComponentEditBox.POSITIVE_DECIMAL).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(20).setResponder(val -> {
            TileThermometerModule tile = (TileThermometerModule)((ContainerThermometerModule)this.f_97732_).getSafeHost();
            if (tile == null) {
                return;
            }
            double temp = 0.0;
            try {
                temp = Double.parseDouble(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (temp < 0.0) {
                temp = 0.0;
            }
            tile.targetTemperature.setValue((Object)temp);
        });
        this.addEditBox(this.targetTempBox);
    }

    @Override
    public void updateNonSelectorVisibility(boolean visible) {
        this.modeButton.setVisible(visible);
        this.invertButton.setVisible(visible);
        this.hidden = !visible;
        this.targetTempBox.setVisible(visible);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        TileThermometerModule module = (TileThermometerModule)((ContainerThermometerModule)this.m_6262_()).getSafeHost();
        if (this.needsUpdate && module != null) {
            this.targetTempBox.setValue("" + module.targetTemperature.getValue());
            this.needsUpdate = false;
        }
    }
}

