/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.item;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import nuclearscience.prefab.utils.NuclearTextUtils;
import nuclearscience.registers.NuclearScienceSounds;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.item.IItemElectric;
import voltaic.api.radiation.util.IRadiationRecipient;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.item.ItemElectric;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class ItemGeigerCounter
extends ItemElectric {
    public static final double POWER_USAGE = 20.0;

    public ItemGeigerCounter(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab, Function<Item, Item> getBatteryItem) {
        super(properties, creativeTab, getBatteryItem);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            if (!worldIn.f_46443_) {
                boolean noPower = this.getJoulesStored(stack) < 20.0;
                IRadiationRecipient capability = (IRadiationRecipient)player.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONRECIPIENT).orElse((Object)CapabilityUtils.EMPTY_RADIATION_REPIPIENT);
                if (capability == CapabilityUtils.EMPTY_RADIATION_REPIPIENT) {
                    return;
                }
                RadioactiveObject recievedRads = capability.getRecievedRadiation((LivingEntity)player);
                if (isSelected || player.m_6844_(EquipmentSlot.OFFHAND).m_41720_() instanceof ItemGeigerCounter) {
                    if (noPower) {
                        player.m_5661_((Component)NuclearTextUtils.chatMessage("geigercounter.nopower", new Object[0]), true);
                    } else {
                        player.m_5661_((Component)ChatFormatter.getChatDisplay((double)recievedRads.amount(), (IDisplayUnit)DisplayUnits.RAD, (int)3, (boolean)true), true);
                    }
                }
                if (!noPower && recievedRads.amount() > 0.0 && (double)(worldIn.f_46441_.m_188501_() * 50.0f) * 60.995 / 3.0 < recievedRads.amount()) {
                    SoundEvent sound = switch (worldIn.f_46441_.m_216332_(1, 6)) {
                        case 2 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_2.get();
                        case 3 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_3.get();
                        case 4 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_4.get();
                        case 5 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_5.get();
                        case 6 -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_6.get();
                        default -> (SoundEvent)NuclearScienceSounds.SOUND_GEIGERCOUNTER_1.get();
                    };
                    worldIn.m_5594_(null, player.m_20183_(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                    IItemElectric.setEnergyStored((ItemStack)stack, (double)(this.getJoulesStored(stack) - 20.0));
                    player.m_150109_().m_6836_(itemSlot, stack);
                    player.m_150109_().m_6596_();
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }
}

