/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet.type.server;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import nuclearscience.api.quantumtunnel.FrequencyType;
import nuclearscience.common.packet.type.server.ServerBarrierMethods;
import voltaic.api.codec.StreamCodec;

public class PacketCreateNewFreqeuency {
    public static final StreamCodec<ByteBuf, PacketCreateNewFreqeuency> CODEC = new StreamCodec<ByteBuf, PacketCreateNewFreqeuency>(){

        public PacketCreateNewFreqeuency decode(ByteBuf buf) {
            return new PacketCreateNewFreqeuency((UUID)StreamCodec.UUID.decode((Object)buf), (String)StreamCodec.STRING.decode((Object)buf), FrequencyType.values()[(Integer)StreamCodec.INT.decode((Object)buf)]);
        }

        public void encode(ByteBuf buf, PacketCreateNewFreqeuency packet) {
            StreamCodec.UUID.encode((Object)buf, (Object)packet.creator);
            StreamCodec.STRING.encode((Object)buf, (Object)packet.name);
            StreamCodec.INT.encode((Object)buf, (Object)packet.type.ordinal());
        }
    };
    private final UUID creator;
    private final FrequencyType type;
    private final String name;

    public PacketCreateNewFreqeuency(UUID creator, String name, FrequencyType type) {
        this.creator = creator;
        this.type = type;
        this.name = name;
    }

    public static void handle(PacketCreateNewFreqeuency message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ServerBarrierMethods.createNewPacket(message.creator, message.type, message.name));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketCreateNewFreqeuency pkt, FriendlyByteBuf buf) {
        CODEC.encode((Object)buf, (Object)pkt);
    }

    public static PacketCreateNewFreqeuency decode(FriendlyByteBuf buf) {
        return (PacketCreateNewFreqeuency)CODEC.decode((Object)buf);
    }
}

