/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.fission;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;
import nuclearscience.common.block.BlockIrradiated;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileMeltedReactor
extends GenericTile {
    public static final float RADIATION_RADIUS = 30.0f;
    public static final float START_RADIATION = 4.383E7f;
    public int radiation = 43830000;
    public int temperature = 6000;

    public TileMeltedReactor(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_MELTEDREACTOR.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
    }

    protected void tickServer(ComponentTickable tickable) {
        BlockState state;
        BlockPos pos;
        double distanceSq;
        double d5;
        double d4;
        double d3;
        double z2;
        double y2;
        BlockState state2;
        long ticks = tickable.getTicks();
        if (ticks % 3L == 0L && ((state2 = this.f_58857_.m_8055_(this.f_58858_.m_7495_())).m_60795_() || state2.m_60734_() instanceof LiquidBlock)) {
            this.f_58857_.m_46597_(this.f_58858_.m_7495_(), this.m_58900_());
            this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
            BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (tile instanceof TileMeltedReactor) {
                TileMeltedReactor newTile = (TileMeltedReactor)tile;
                newTile.radiation = this.radiation;
            }
            return;
        }
        if (this.temperature > 0) {
            --this.temperature;
            double x2 = (double)this.f_58858_.m_123341_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 30.0 / 2.0;
            y2 = (double)this.f_58858_.m_123342_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 30.0 / 2.0;
            z2 = (double)this.f_58858_.m_123343_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 30.0 / 2.0;
            d3 = (double)this.f_58858_.m_123341_() - x2;
            distanceSq = d3 * d3 + (d4 = (double)this.f_58858_.m_123342_() - y2) * d4 + (d5 = (double)this.f_58858_.m_123343_() - z2) * d5;
            if (distanceSq < 900.0 && this.f_58857_.f_46441_.m_188500_() > distanceSq / 900.0) {
                pos = new BlockPos((int)Math.floor(x2), (int)Math.floor(y2), (int)Math.floor(z2));
                state = this.f_58857_.m_8055_(pos);
                if (state.m_60795_()) {
                    if (!this.f_58857_.m_8055_(pos.m_7495_()).m_60795_()) {
                        this.f_58857_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    }
                } else if (state.m_204336_(BlockTags.f_13061_)) {
                    if (this.temperature > 2100) {
                        this.f_58857_.m_46597_(pos, Blocks.f_50652_.m_49966_());
                    }
                } else if (state.m_204336_(Tags.Blocks.COBBLESTONE)) {
                    this.f_58857_.m_46597_(pos, Blocks.f_49991_.m_49966_());
                } else if (this.f_58857_.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
                    this.f_58857_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                } else if (state.m_204336_(BlockTags.f_13029_)) {
                    this.f_58857_.m_46597_(pos, Blocks.f_50058_.m_49966_());
                }
            }
        }
        if (this.radiation > 0) {
            --this.radiation;
            double x2 = (double)this.f_58858_.m_123341_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 30.0 / 2.0;
            y2 = (double)this.f_58858_.m_123342_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 30.0 / 2.0;
            z2 = (double)this.f_58858_.m_123343_() + 0.5 + (this.f_58857_.f_46441_.m_188500_() - 0.5) * 30.0 / 2.0;
            d3 = (double)this.f_58858_.m_123341_() - x2;
            distanceSq = d3 * d3 + (d4 = (double)this.f_58858_.m_123342_() - y2) * d4 + (d5 = (double)this.f_58858_.m_123343_() - z2) * d5;
            if (distanceSq < 900.0 && this.f_58857_.f_46441_.m_188500_() > distanceSq / 900.0 && BlockIrradiated.isValidPlacement(state = this.f_58857_.m_8055_(pos = new BlockPos((int)Math.floor(x2), (int)Math.floor(y2), (int)Math.floor(z2))))) {
                this.f_58857_.m_46597_(pos, BlockIrradiated.getIrradiatedBlockstate(state));
            }
        }
        double totstrength = 120000.0f * ((float)this.radiation / 4.383E7f);
        int range = (int)(Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0);
        RadiationSystem.addRadiationSource((Level)this.m_58904_(), (SimpleRadiationSource)new SimpleRadiationSource(totstrength, 1.0, range, true, 1, this.m_58899_(), true, false));
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128405_("rads", this.radiation);
        compound.m_128405_("temp", this.temperature);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.radiation = compound.m_128451_("rads");
        this.temperature = compound.m_128451_("temp");
        super.m_142466_(compound);
    }
}

