/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork.interfaces;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.common.tile.reactor.fusion.TileFusionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileSupplyModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;

public class TileFusionInterface
extends GenericTileInterface {
    public TileFusionInterface(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_FUSIONINTERFACE.get(), worldPos, blockState);
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        int accepted;
        ItemStack stack;
        int i;
        boolean inserted;
        boolean checkTritium;
        super.tickServer(tickable);
        if (!this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.m_58901_()) {
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (!network.isControllerActive()) {
            return;
        }
        TileSupplyModule supplyModule = network.getSupplyModule((BlockPos)this.supplyModuleLocation.getValue());
        if (!this.reactor.valid() || supplyModule == null || !(this.reactor.getSafe() instanceof TileFusionReactorCore)) {
            return;
        }
        TileFusionReactorCore core = (TileFusionReactorCore)((Object)this.reactor.getSafe());
        ComponentInventory supplyInv = (ComponentInventory)supplyModule.getComponent(IComponentType.Inventory);
        boolean isInsertingTritium = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FUSION_TRITIUM_INSERT);
        boolean isInsertingDeuterium = this.serverAnimations.containsKey((Object)GenericTileInterface.InterfaceAnimation.FUSION_DEUTERIUM_INSERT);
        boolean checkDeuterium = !core.isDeuteriumFull();
        boolean bl = checkTritium = !core.isTritiumFull();
        if (!checkDeuterium && !checkTritium) {
            this.handleServerAnimations(tickable);
            return;
        }
        if (!isInsertingTritium && checkDeuterium) {
            inserted = false;
            for (i = 0; i < 9; ++i) {
                stack = supplyInv.m_8020_(i);
                if (stack.m_41619_() || !stack.m_204117_(NuclearScienceTags.Items.CELL_DEUTERIUM)) continue;
                accepted = core.addDeuteriumCells(stack.m_41613_());
                if (accepted > 0) {
                    supplyInv.m_7407_(i, accepted);
                    inserted = true;
                    isInsertingDeuterium = true;
                }
                if (core.isDeuteriumFull()) break;
            }
            if (inserted) {
                this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FUSION_DEUTERIUM_INSERT.ordinal());
            }
        }
        if (!isInsertingDeuterium && checkTritium) {
            inserted = false;
            for (i = 0; i < 9; ++i) {
                stack = supplyInv.m_8020_(i);
                if (stack.m_41619_() || !stack.m_204117_(NuclearScienceTags.Items.CELL_TRITIUM)) continue;
                accepted = core.addTritiumCells(stack.m_41613_());
                if (accepted > 0) {
                    supplyInv.m_7407_(i, accepted);
                    inserted = true;
                }
                if (core.isTritiumFull()) break;
            }
            if (inserted) {
                this.queuedAnimations.addValue((Object)GenericTileInterface.InterfaceAnimation.FUSION_TRITIUM_INSERT.ordinal());
            }
        }
        this.handleServerAnimations(tickable);
    }

    @Override
    public Direction getReactorDirection() {
        return Direction.UP;
    }

    @Override
    public GenericTileInterface.InterfaceType getInterfaceType() {
        return GenericTileInterface.InterfaceType.FUSION;
    }

    @Override
    public Direction getCableLocation() {
        return Direction.DOWN;
    }
}

