/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.moltensalt;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import nuclearscience.api.turbine.ISteamReceiver;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.object.Location;

public class TileHeatExchanger
extends GenericTile {
    public static final int STEAM_GEN_DIAMETER = 5;
    public static final int STEAM_GEN_HEIGHT = 2;
    private ISteamReceiver[][][] cachedReceivers = new ISteamReceiver[5][2][5];
    public SingleProperty<Double> temperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "temperature", (Object)0.0));

    public TileHeatExchanger(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_HEATEXCHANGER.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickCommon(this::tickCommon).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
    }

    private void tickServer(ComponentTickable componentTickable) {
        this.temperature.setValue((Object)((Double)this.temperature.getValue() * 0.9));
        if ((Double)this.temperature.getValue() > 100.0) {
            Location source = new Location((double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f));
            AABB bb = AABB.m_165882_((Vec3)new Vec3(source.x(), source.y(), source.z()), (double)4.0, (double)4.0, (double)4.0);
            List list = this.f_58857_.m_45976_(LivingEntity.class, bb);
            for (LivingEntity living : list) {
                if (!this.f_58857_.m_8055_(living.m_20097_()).m_60819_().m_205070_(FluidTags.f_13131_)) continue;
                living.m_6469_(living.m_269291_().m_269063_(), 3.0f);
            }
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        if ((Double)this.temperature.getValue() > 100.0) {
            this.produceSteam();
        }
    }

    protected void produceSteam() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5; ++k) {
                    boolean isFaceWater;
                    boolean isReactor2d;
                    boolean bl = isReactor2d = i - 2 == 0 && k - 2 == 0;
                    if (isReactor2d && j == 0) {
                        if (this.f_58857_.f_46443_ || !((double)this.f_58857_.f_46441_.m_188501_() < (Double)this.temperature.getValue() / 1000000.0) || !this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)BlockStateProperties.f_61362_)) continue;
                        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    int offsetX = this.f_58858_.m_123341_() + i - 2;
                    int offsetY = this.f_58858_.m_123342_() + j;
                    int offsetZ = this.f_58858_.m_123343_() + k - 2;
                    BlockPos offpos = new BlockPos(offsetX, offsetY, offsetZ);
                    if (!TileFissionReactorCore.isStillWater(this.m_58904_(), offpos)) continue;
                    boolean bl2 = isFaceWater = TileFissionReactorCore.isStillWater(this.m_58904_(), new BlockPos(offsetX, this.f_58858_.m_123342_(), this.f_58858_.m_123343_())) || TileFissionReactorCore.isStillWater(this.m_58904_(), new BlockPos(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), offsetZ)) || isReactor2d;
                    if (!isFaceWater) continue;
                    if (!this.f_58857_.f_46443_) {
                        ISteamReceiver turbine = this.cachedReceivers[i][j][k];
                        if (turbine != null) {
                            if (turbine.isStillValid()) {
                                this.cachedReceivers[i][j][k] = null;
                            }
                            turbine.receiveSteam((int)(NuclearConstants.MSRREACTOR_MAXENERGYTARGET / (500.0 * (1000.0 / (Double)this.temperature.getValue()))), ((Double)this.temperature.getValue()).intValue());
                        }
                        if ((double)this.f_58857_.f_46441_.m_188501_() < (Double)this.temperature.getValue() / 1000000.0) {
                            this.f_58857_.m_46597_(offpos, Blocks.f_50016_.m_49966_());
                            continue;
                        }
                        if (turbine != null && !turbine.isStillValid()) continue;
                        BlockEntity above = this.f_58857_.m_7702_(new BlockPos(offsetX, offsetY + 1, offsetZ));
                        if (above instanceof ISteamReceiver) {
                            ISteamReceiver ab;
                            this.cachedReceivers[i][j][k] = ab = (ISteamReceiver)above;
                            continue;
                        }
                        this.cachedReceivers[i][j][k] = null;
                        continue;
                    }
                    if (!this.f_58857_.f_46443_ || !((double)this.f_58857_.f_46441_.m_188501_() < (Double)this.temperature.getValue() / 3000.0)) continue;
                    double offsetFX = (double)offsetX + this.f_58857_.f_46441_.m_188500_() / 2.0 * (double)(this.f_58857_.f_46441_.m_188499_() ? -1 : 1);
                    double offsetFY = (double)offsetY + this.f_58857_.f_46441_.m_188500_() / 2.0 * (double)(this.f_58857_.f_46441_.m_188499_() ? -1 : 1);
                    double offsetFZ = (double)offsetZ + this.f_58857_.f_46441_.m_188500_() / 2.0 * (double)(this.f_58857_.f_46441_.m_188499_() ? -1 : 1);
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, offsetFX + 0.5, offsetFY + (double)0.2f, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                    if (this.f_58857_.f_46441_.m_188503_(3) != 0) continue;
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public Double receiveHeat(Double perReceiver) {
        this.temperature.setValue((Object)perReceiver);
        return perReceiver;
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }
}

