/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.moltensalt;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.inventory.container.ContainerMoltenSaltSupplier;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileMoltenSaltSupplier
extends GenericTile {
    public static final double AMT_PER_SALT = 250.0;
    public static final double AMT_PER_WASTE = 300.0;
    protected CachedTileOutput output;
    public final SingleProperty<Double> reactorWaste = (SingleProperty)this.property((AbstractProperty)((SingleProperty)new SingleProperty(PropertyTypes.DOUBLE, "reactorwaste", (Object)0.0).setNoSave()));

    public TileMoltenSaltSupplier(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_MOLTENSALTSUPPLIER.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(NuclearConstants.MOLTENSALTSUPPLIER_VOLTAGE).extractPower((x, y) -> TransferPack.EMPTY).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules(NuclearConstants.MOLTENSALTSUPPLIER_USAGE_PER_TICK * 20.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1).outputs(1)).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.TOP}).setDirectionsBySlot(Integer.valueOf(1), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).valid((slot, stack, i) -> stack.m_41720_() == NuclearScienceItems.ITEM_LIFHT4PUF3.get()));
        this.addComponent((IComponent)new ComponentContainerProvider("moltensaltsupplier", (GenericTile)this).createMenu((id, player) -> new ContainerMoltenSaltSupplier((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro;
        boolean enoughPower;
        Direction dir = this.getFacing();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(dir.m_122424_()));
        }
        boolean bl = enoughPower = (electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).getJoulesStored() >= NuclearConstants.MOLTENSALTSUPPLIER_USAGE_PER_TICK;
        if (!enoughPower) {
            return;
        }
        if (BlockEntityUtils.isLit((GenericTile)this) ^ enoughPower) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)enoughPower);
        }
        electro.joules(electro.getJoulesStored() - NuclearConstants.MOLTENSALTSUPPLIER_USAGE_PER_TICK);
        if (tickable.getTicks() % 40L == 0L) {
            this.output.update(this.f_58858_.m_121945_(dir.m_122424_()));
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack fuel = inv.m_8020_(0);
        if (!this.output.valid() || !(this.output.getSafe() instanceof TileMSReactorCore)) {
            this.reactorWaste.setValue((Object)0.0);
            return;
        }
        TileMSReactorCore core = (TileMSReactorCore)((Object)this.output.getSafe());
        this.reactorWaste.setValue(core.currentWaste.getValue());
        if (fuel.m_41619_()) {
            return;
        }
        if (core.getFacing() != dir) {
            return;
        }
        if (1000.0 - (Double)core.currentFuel.getValue() >= 250.0) {
            fuel.m_41774_(1);
            core.currentFuel.setValue((Object)((Double)core.currentFuel.getValue() + 250.0));
        }
        if ((Double)core.currentWaste.getValue() < 300.0) {
            return;
        }
        ItemStack waste = inv.m_8020_(1);
        if (waste.m_41613_() >= waste.m_41741_()) {
            return;
        }
        if (waste.m_41619_()) {
            inv.m_6836_(1, new ItemStack((ItemLike)NuclearScienceItems.ITEM_FISSILE_SALT.get()));
        } else {
            waste.m_41769_(1);
            inv.m_6836_(1, waste);
        }
        core.currentWaste.setValue((Object)((Double)core.currentWaste.getValue() - 300.0));
    }
}

