/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.world;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class QuantumCapacitorData
extends SavedData {
    public static final String DATANAME = "quantumcapacitordata";
    public HashMap<UUID, HashMap<Integer, Double>> powermapping = new HashMap();

    public static QuantumCapacitorData load(CompoundTag source) {
        QuantumCapacitorData data = new QuantumCapacitorData();
        data.powermapping.clear();
        ListTag list = source.m_128437_("list", 10);
        for (Tag en : list) {
            CompoundTag compound = (CompoundTag)en;
            UUID id = compound.m_128342_("uuid");
            ListTag entryList = compound.m_128437_("entrylist", 10);
            HashMap<Integer, Double> info = new HashMap<Integer, Double>();
            for (Tag entryInside : entryList) {
                CompoundTag inside = (CompoundTag)entryInside;
                int frequency = inside.m_128451_("frequency");
                double joules = inside.m_128459_("joules");
                info.put(frequency, joules);
            }
            data.powermapping.put(id, info);
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag source) {
        ListTag list = new ListTag();
        source.m_128365_("list", (Tag)list);
        for (Map.Entry<UUID, HashMap<Integer, Double>> en : this.powermapping.entrySet()) {
            CompoundTag compound = new CompoundTag();
            compound.m_128362_("uuid", en.getKey());
            ListTag entrylist = new ListTag();
            compound.m_128365_("entrylist", (Tag)entrylist);
            for (Map.Entry<Integer, Double> entryInside : en.getValue().entrySet()) {
                CompoundTag inside = new CompoundTag();
                inside.m_128405_("frequency", entryInside.getKey().intValue());
                inside.m_128347_("joules", entryInside.getValue().doubleValue());
                entrylist.add((Object)inside);
            }
            list.add((Object)compound);
        }
        return source;
    }

    public static QuantumCapacitorData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)world;
            DimensionDataStorage storage = sl.m_8895_();
            QuantumCapacitorData instance = (QuantumCapacitorData)storage.m_164861_(QuantumCapacitorData::load, QuantumCapacitorData::new, DATANAME);
            if (instance == null) {
                instance = new QuantumCapacitorData();
                storage.m_164855_(DATANAME, (SavedData)instance);
            }
            return instance;
        }
        return null;
    }

    public boolean m_77764_() {
        return true;
    }

    public double getJoules(UUID uuid, int frequency) {
        if (this.powermapping.containsKey(uuid)) {
            HashMap<Integer, Double> value = this.powermapping.get(uuid);
            if (value.containsKey(frequency)) {
                return value.get(frequency);
            }
            value.put(frequency, 0.0);
            return 0.0;
        }
        this.powermapping.put(uuid, new HashMap());
        this.powermapping.get(uuid).put(frequency, 0.0);
        return 0.0;
    }

    public void setJoules(UUID uuid, int frequency, double value) {
        this.getJoules(uuid, frequency);
        this.powermapping.get(uuid).put(frequency, value);
    }
}

