/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.prefab.screen.component.logisticsnetwork;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import nuclearscience.client.screen.util.GenericInterfaceBoundScreen;
import nuclearscience.common.inventory.container.util.GenericInterfaceBoundContainer;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileInterfaceBound;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.screen.component.logisticsnetwork.ButtonInterfaceType;
import nuclearscience.prefab.screen.component.logisticsnetwork.ScreenComponentBoundInterface;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.math.Color;

public class WrapperBindInterface {
    private final GenericInterfaceBoundScreen<?> screen;
    public ScreenComponentButton<?> button;
    private ScreenComponentBoundInterface boundInterface;
    private ScreenComponentSimpleLabel label;
    private ScreenComponentButton<?> enable;
    private ScreenComponentButton<?> disable;
    private ButtonInterfaceType[] interfaceButtons = new ButtonInterfaceType[5];
    private int topRowIndex = 0;
    private int lastRowCount = 0;
    private static final int BUTTON_COUNT = 5;

    public WrapperBindInterface(GenericInterfaceBoundScreen<?> screen, int x, int y, int tabX, int tabY, boolean needsButton, boolean updateSlots) {
        int i;
        this.screen = screen;
        if (needsButton) {
            this.button = (ScreenComponentButton)new ScreenComponentButton((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, tabX, tabY).setOnPress(but -> {
                ScreenComponentButton button = but;
                boolean bl = button.isPressed = !button.isPressed;
                if (button.isPressed) {
                    screen.updateNonSelectorVisibility(false);
                    this.updateVisibility(true);
                    if (updateSlots) {
                        this.hideSlots();
                        screen.playerInvLabel.setVisible(false);
                    }
                    screen.binderSlider.setVisible(true);
                } else {
                    screen.updateNonSelectorVisibility(true);
                    this.updateVisibility(false);
                    if (updateSlots) {
                        this.showSlots();
                        screen.playerInvLabel.setVisible(true);
                    }
                    screen.binderSlider.setVisible(false);
                }
            }).onTooltip((graphics, but, xAxis, yAxis) -> {
                ScreenComponentButton button = (ScreenComponentButton)but;
                ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
                tooltips.add(NuclearTextUtils.tooltip("logisticsnetwork.linkinterface", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
                if (!button.isPressed) {
                    tooltips.add(ElectroTextUtils.tooltip((String)"inventoryio.presstoshow", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
                } else {
                    tooltips.add(ElectroTextUtils.tooltip((String)"inventoryio.presstohide", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
                }
                graphics.m_280666_(screen.getFontRenderer(), tooltips, xAxis, yAxis);
            }).setIcon((ITexture)NuclearIconTypes.LINK);
            screen.addComponent((AbstractScreenComponent)this.button);
        }
        this.boundInterface = new ScreenComponentBoundInterface(x + 10, y + 19, 114, 20);
        this.label = new ScreenComponentSimpleLabel(x + 10, y + 45, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("logisticsnetwork.network", new Object[0]));
        this.enable = (ScreenComponentButton)new ScreenComponentButton(x + 127, y + 19, 20, 20).setOnPress(but -> {
            GenericTileInterfaceBound tile = (GenericTileInterfaceBound)((GenericInterfaceBoundContainer)screen.m_6262_()).getSafeHost();
            if (tile == null || this.boundInterface.getInterface() == null || ((BlockPos)tile.interfaceLocation.getValue()).equals((Object)this.boundInterface.getInterface().pos())) {
                return;
            }
            tile.interfaceLocation.setValue((Object)this.boundInterface.getInterface().pos());
            tile.interfaceType.setValue((Object)this.boundInterface.getInterface().type().ordinal());
        }).onTooltip((graphics, button, xAxis, yAxis) -> graphics.m_280557_(screen.getFontRenderer(), (Component)NuclearTextUtils.gui("quantumtunnel.enable", new Object[0]), xAxis, yAxis)).setIcon((ITexture)NuclearIconTypes.ENABLE);
        this.disable = (ScreenComponentButton)new ScreenComponentButton(x + 150, y + 19, 20, 20).setOnPress(but -> {
            GenericTileInterfaceBound tile = (GenericTileInterfaceBound)((GenericInterfaceBoundContainer)screen.m_6262_()).getSafeHost();
            if (tile == null) {
                return;
            }
            tile.interfaceLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
            tile.interfaceType.setValue((Object)GenericTileInterface.InterfaceType.NONE.ordinal());
        }).onTooltip((graphics, button, xAxis, yAxis) -> graphics.m_280557_(screen.getFontRenderer(), (Component)NuclearTextUtils.gui("quantumtunnel.disable", new Object[0]), xAxis, yAxis)).setIcon((ITexture)NuclearIconTypes.DISABLE);
        int butOffX = 10;
        int butOffY = 57;
        for (i = 0; i < 5; ++i) {
            this.interfaceButtons[i] = (ButtonInterfaceType)new ButtonInterfaceType(x + butOffX, y + butOffY + 20 * i, 139, 20).setOnPress(but -> {
                ButtonInterfaceType button = (ButtonInterfaceType)but;
                GenericTileInterfaceBound tile = (GenericTileInterfaceBound)((GenericInterfaceBoundContainer)screen.m_6262_()).getSafeHost();
                if (tile == null || button.getInterface() == null) {
                    this.boundInterface.setInterface(null);
                    return;
                }
                this.boundInterface.setInterface(button.getInterface());
            });
        }
        screen.addComponent((AbstractScreenComponent)this.boundInterface);
        screen.addComponent((AbstractScreenComponent)this.enable);
        screen.addComponent((AbstractScreenComponent)this.disable);
        screen.addComponent((AbstractScreenComponent)this.label);
        for (i = 0; i < 5; ++i) {
            screen.addComponent((AbstractScreenComponent)this.interfaceButtons[i]);
        }
        if (needsButton) {
            this.updateVisibility(false);
        }
    }

    public void tick() {
        if (!this.screen.binderSlider.isVisible()) {
            return;
        }
        GenericTileInterfaceBound tile = (GenericTileInterfaceBound)((GenericInterfaceBoundContainer)this.screen.m_6262_()).getSafeHost();
        if (tile == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        this.lastRowCount = tile.clientInterfaces.size();
        for (int i = 0; i < 5; ++i) {
            ButtonInterfaceType button = this.interfaceButtons[i];
            int index = this.topRowIndex + i;
            if (index < tile.clientInterfaces.size()) {
                button.setInterface(tile.clientInterfaces.get(index));
                continue;
            }
            button.setInterface(null);
        }
        ScreenComponentVerticalSlider slider = this.screen.binderSlider;
        if (this.lastRowCount > 5) {
            slider.updateActive(true);
            if (!slider.isSliderHeld()) {
                int moveRoom = this.screen.binderSlider.height - 15 - 2;
                double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                slider.setSliderYOffset((int)((double)moveRoom * moved));
            }
        } else {
            slider.updateActive(false);
            slider.setSliderYOffset(0);
            this.topRowIndex = 0;
        }
    }

    public void handleMouseScroll(int dir) {
        if (Screen.m_96637_()) {
            dir *= 4;
        }
        int lastRowIndex = this.lastRowCount - 1;
        if (this.lastRowCount > 5) {
            if (this.topRowIndex >= this.lastRowCount) {
                this.topRowIndex = lastRowIndex - 4;
            }
            this.topRowIndex = Mth.m_14045_((int)(this.topRowIndex += dir), (int)0, (int)(lastRowIndex - 4));
        } else {
            this.topRowIndex = 0;
        }
    }

    public Consumer<Integer> getSliderClickedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.binderSlider;
            if (slider.isSliderActive()) {
                int sliderY = slider.yLocation;
                int sliderHeight = slider.height;
                int mouseHeight = mouseY - sliderY;
                if (mouseHeight >= sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else if (mouseHeight <= 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else {
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                    int moveRoom = slider.height - 15 - 2;
                    double moved = (double)this.topRowIndex / ((double)this.lastRowCount - 5.0);
                    slider.setSliderYOffset((int)((double)moveRoom * moved));
                }
            }
        };
    }

    public Consumer<Integer> getSliderDraggedConsumer() {
        return mouseY -> {
            ScreenComponentVerticalSlider slider = this.screen.binderSlider;
            if (slider.isSliderActive()) {
                int sliderY = slider.yLocation;
                int sliderHeight = slider.height;
                if (mouseY <= sliderY + 2) {
                    this.topRowIndex = 0;
                    slider.setSliderYOffset(0);
                } else if (mouseY >= sliderY + sliderHeight - 2 - 15) {
                    this.topRowIndex = this.lastRowCount - 5;
                    slider.setSliderYOffset(sliderHeight - 2 - 15);
                } else {
                    int mouseHeight = mouseY - sliderY;
                    slider.setSliderYOffset(mouseHeight);
                    double heightRatio = (double)mouseHeight / (double)sliderHeight;
                    this.topRowIndex = (int)Math.round((double)(this.lastRowCount - 5) * heightRatio);
                }
            }
        };
    }

    public void updateVisibility(boolean show) {
        this.boundInterface.setVisible(show);
        this.label.setVisible(show);
        this.enable.setVisible(show);
        this.disable.setVisible(show);
        for (ButtonInterfaceType button : this.interfaceButtons) {
            button.setVisible(show);
        }
    }

    public void hideSlots() {
        for (int i = 0; i < ((GenericInterfaceBoundContainer)this.screen.m_6262_()).f_38839_.size(); ++i) {
            ((SlotGeneric)((GenericInterfaceBoundContainer)this.screen.m_6262_()).f_38839_.get(i)).setActive(false);
        }
    }

    public void showSlots() {
        for (int i = 0; i < ((GenericInterfaceBoundContainer)this.screen.m_6262_()).f_38839_.size(); ++i) {
            ((SlotGeneric)((GenericInterfaceBoundContainer)this.screen.m_6262_()).f_38839_.get(i)).setActive(true);
        }
    }
}

