/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.quantumtunnel;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import nuclearscience.api.quantumtunnel.ICapabilityTunnelMap;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.registers.NuclearScienceCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapabilityTunnelMap
implements ICapabilityTunnelMap,
ICapabilitySerializable<CompoundTag> {
    private final HashMap<TunnelFrequency, TunnelFrequencyBuffer> map = new HashMap();
    private final LazyOptional<ICapabilityTunnelMap> lazyOptional = LazyOptional.of(() -> this);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == NuclearScienceCapabilities.CAPABILITY_TUNNELMAP) {
            return this.lazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag data = new CompoundTag();
        int size = this.map.size();
        data.m_128405_("size", size);
        int i = 0;
        for (Map.Entry<TunnelFrequency, TunnelFrequencyBuffer> entry : this.map.entrySet()) {
            CompoundTag store = new CompoundTag();
            TunnelFrequency.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getKey()).result().ifPresent(tag -> store.m_128365_("id", tag));
            TunnelFrequencyBuffer.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getValue()).result().ifPresent(tag -> store.m_128365_("buffer", tag));
            data.m_128365_("" + i, (Tag)store);
            ++i;
        }
        return data;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (NuclearScienceCapabilities.CAPABILITY_TUNNELMAP == null) {
            return;
        }
        this.map.clear();
        int size = nbt.m_128451_("size");
        for (int i = 0; i < size; ++i) {
            CompoundTag stored = nbt.m_128469_("" + i);
            Optional freq = TunnelFrequency.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128423_("id")).result();
            Optional val = TunnelFrequencyBuffer.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)stored.m_128469_("buffer")).result();
            if (!freq.isPresent() || !val.isPresent()) continue;
            this.map.put((TunnelFrequency)((Pair)freq.get()).getFirst(), (TunnelFrequencyBuffer)((Pair)val.get()).getFirst());
        }
    }

    @Override
    public HashMap<TunnelFrequency, TunnelFrequencyBuffer> getMap() {
        return this.map;
    }
}

