/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import nuclearscience.client.NuclearScienceClientRegister;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileControlRodModule;
import org.jetbrains.annotations.NotNull;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.Color;

public class RenderControlRodModule
extends AbstractTileRenderer<TileControlRodModule> {
    private static final double MAX_DELTA = 0.8125;

    public RenderControlRodModule(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull TileControlRodModule tile, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        Direction facing = tile.getFacing();
        int sign = 1;
        if (facing == Direction.WEST || facing == Direction.EAST) {
            sign = -1;
        }
        stack.m_85845_(new Quaternion(0.0f, facing.m_122435_() - (float)(sign * 90), 0.0f, true));
        double insertion = (double)((Integer)tile.insertion.getValue()).intValue() / 100.0;
        stack.m_85837_(0.0, 0.0, -0.8125 * insertion);
        RenderingUtils.renderModel((BakedModel)this.getModel(NuclearScienceClientRegister.MODEL_CONTROLRODMODULE_ROD), (BlockEntity)tile, (RenderType)RenderType.m_110451_(), (PoseStack)stack, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        stack.m_85849_();
        if (!((Boolean)tile.linked.getValue()).booleanValue()) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        this.rotateMatrix(stack, facing);
        stack.m_85837_(0.0, 0.175, 0.1775);
        MutableComponent transfer = ChatFormatter.getChatDisplayShort((double)((double)((Integer)tile.insertion.getValue()).intValue() / 100.0 * 100.0), (IDisplayUnit)DisplayUnits.PERCENTAGE);
        float scale = 0.0215f / ((float)font.m_92852_((FormattedText)transfer) / 16.0f);
        stack.m_85841_(-scale, -scale, -scale);
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        float textX = (float)(-font.m_92852_((FormattedText)transfer)) / 2.0f;
        font.m_92841_((Component)transfer, textX, 0.0f, Color.WHITE.color(), false, matrix4f, bufferIn, false, 0, combinedLightIn);
        stack.m_85849_();
    }

    private void rotateMatrix(PoseStack stack, Direction dir) {
        switch (dir) {
            case EAST: {
                stack.m_85845_(new Quaternion(0.0f, -90.0f, 0.0f, true));
                break;
            }
            case SOUTH: {
                stack.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                break;
            }
            case WEST: {
                stack.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                break;
            }
        }
    }
}

