/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import nuclearscience.common.tile.TileNuclearBoiler;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.utilities.RenderingUtils;

public class RenderNuclearBoiler
extends AbstractTileRenderer<TileNuclearBoiler> {
    private static final float DELTA_Y = 0.225f;

    public RenderNuclearBoiler(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileNuclearBoiler tile, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int light, int overlay) {
        matrix.m_85836_();
        Direction facing = tile.getFacing();
        VertexConsumer builder = buffer.m_6299_(Sheets.m_110792_());
        PropertyFluidTank input = ((ComponentFluidHandlerMulti)tile.getComponent(IComponentType.FluidHandler)).getInputTanks()[0];
        if (!input.isEmpty()) {
            this.drawFluidInput(matrix, builder, input.getFluid(), facing, (float)input.getFluidAmount() / 5000.0f, light, overlay);
        }
        matrix.m_85849_();
        matrix.m_85836_();
        PropertyFluidTank output = ((ComponentFluidHandlerMulti)tile.getComponent(IComponentType.FluidHandler)).getOutputTanks()[0];
        if (!output.isEmpty()) {
            this.drawFluidOutput(matrix, builder, output.getFluid(), facing, (float)output.getFluidAmount() / 5000.0f, light, overlay);
        }
        matrix.m_85849_();
    }

    private void drawFluidInput(PoseStack stack, VertexConsumer builder, FluidStack fluid, Direction facing, float height, int light, int overlay) {
        AABB box = null;
        float maxY = 0.225f * height + 0.5125f;
        box = facing == Direction.NORTH ? new AABB(0.54375, 0.5125, 0.3875, 0.70625, (double)maxY, 0.6125) : (facing == Direction.EAST ? new AABB(0.3875, 0.5125, 0.54375, 0.6125, (double)maxY, 0.70625) : (facing == Direction.SOUTH ? new AABB(0.29375, 0.5125, 0.3875, 0.45625, (double)maxY, 0.6125) : new AABB(0.3875, 0.5125, 0.29375, 0.6125, (double)maxY, 0.45625)));
        RenderingUtils.renderFluidBox((PoseStack)stack, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)fluid, (int)light, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
    }

    private void drawFluidOutput(PoseStack stack, VertexConsumer builder, FluidStack fluid, Direction facing, float height, int light, int overlay) {
        AABB box = null;
        float maxY = 0.225f * height + 0.5125f;
        box = facing == Direction.NORTH ? new AABB(0.29375, 0.5125, 0.3875, 0.45625, (double)maxY, 0.6125) : (facing == Direction.EAST ? new AABB(0.3875, 0.5125, 0.29375, 0.6125, (double)maxY, 0.45625) : (facing == Direction.SOUTH ? new AABB(0.54375, 0.5125, 0.3875, 0.70625, (double)maxY, 0.6125) : new AABB(0.3875, 0.5125, 0.54375, 0.6125, (double)maxY, 0.70625)));
        RenderingUtils.renderFluidBox((PoseStack)stack, (Minecraft)this.minecraft(), (VertexConsumer)builder, (AABB)box, (FluidStack)fluid, (int)light, (int)overlay, (boolean[])RenderingUtils.ALL_FACES);
    }
}

