/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileThermometerModule;
import org.jetbrains.annotations.NotNull;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.math.Color;

public class RenderThermometerModule
extends AbstractTileRenderer<TileThermometerModule> {
    public RenderThermometerModule(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull TileThermometerModule tile, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!((Boolean)tile.linked.getValue()).booleanValue()) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        Direction facing = tile.getFacing();
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        this.rotateMatrix(stack, facing);
        stack.m_85836_();
        stack.m_85837_(0.0, 0.175, -0.46875);
        MutableComponent transfer = ChatFormatter.getChatDisplayShort((double)((Double)tile.trackedTemperature.getValue()), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS);
        int width = font.m_92852_((FormattedText)transfer);
        float scale = 0.0215f / ((float)width / 24.0f);
        stack.m_85841_(-scale, -scale, -scale);
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        float textX = (float)(-width) / 2.0f;
        font.m_92841_((Component)transfer, textX, 0.0f, Color.WHITE.color(), false, matrix4f, bufferIn, false, 0, combinedLightIn);
        stack.m_85849_();
        stack.m_85836_();
        stack.m_85837_(0.0, -0.0625, -0.46875);
        transfer = ChatFormatter.getChatDisplayShort((double)((Double)tile.targetTemperature.getValue()), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS);
        width = font.m_92852_((FormattedText)transfer);
        scale = 0.0215f / ((float)width / 24.0f);
        stack.m_85841_(-scale, -scale, -scale);
        matrix4f = stack.m_85850_().m_85861_();
        textX = (float)(-width) / 2.0f;
        font.m_92841_((Component)transfer, textX, 0.0f, Color.WHITE.color(), false, matrix4f, bufferIn, false, 0, combinedLightIn);
        stack.m_85849_();
        stack.m_85849_();
    }

    private void rotateMatrix(PoseStack stack, Direction dir) {
        switch (dir) {
            case EAST: {
                stack.m_85845_(new Quaternion(0.0f, -90.0f, 0.0f, true));
                break;
            }
            case SOUTH: {
                stack.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                break;
            }
            case WEST: {
                stack.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                break;
            }
        }
    }
}

