/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import nuclearscience.client.screen.util.GenericInterfaceBoundScreen;
import nuclearscience.common.inventory.container.ContainerMonitorModule;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.reactor.fission.TileFissionReactorCore;
import nuclearscience.common.tile.reactor.fusion.TileFusionReactorCore;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileMonitorModule;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileFissionInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileFusionInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.TileMSInterface;
import nuclearscience.common.tile.reactor.moltensalt.TileFreezePlug;
import nuclearscience.common.tile.reactor.moltensalt.TileMSReactorCore;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.slot.item.SlotGeneric;
import voltaic.prefab.screen.component.types.ScreenComponentCustomRender;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.prefab.utilities.math.Color;

public class ScreenMonitorModule
extends GenericInterfaceBoundScreen<ContainerMonitorModule> {
    private boolean hidden = false;
    private static final ITexture EMPTY_FUEL = NuclearIconTypes.FUEL_CELL_DARK;

    public ScreenMonitorModule(ContainerMonitorModule container, Inventory inv, Component title) {
        super(container, inv, title, true, false);
        for (int i = 0; i < ((ContainerMonitorModule)this.m_6262_()).f_38839_.size(); ++i) {
            ((SlotGeneric)((ContainerMonitorModule)this.m_6262_()).f_38839_.get(i)).setActive(false);
        }
        this.addComponent((AbstractScreenComponent)new ScreenComponentCustomRender(0, 0, poseStack -> {
            if (this.hidden) {
                return;
            }
            TileMonitorModule tile = (TileMonitorModule)((ContainerMonitorModule)this.f_97732_).getSafeHost();
            if (tile == null) {
                return;
            }
            GenericTileInterface.InterfaceType type = GenericTileInterface.InterfaceType.values()[(Integer)tile.interfaceType.getValue()];
            Font font = this.getFontRenderer();
            int guiWidth = (int)this.getGuiWidth();
            int guiHeight = (int)this.getGuiHeight();
            ScreenMonitorModule.m_93172_((PoseStack)poseStack, (int)(guiWidth + 17), (int)(guiHeight + 17), (int)(guiWidth + 159), (int)(guiHeight + 149), (int)new Color(112, 112, 112, 255).color());
            if (!((Boolean)tile.linked.getValue()).booleanValue() || type == GenericTileInterface.InterfaceType.NONE || ((BlockPos)tile.interfaceLocation.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH)) {
                font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                return;
            }
            BlockEntity blockEntity = tile.m_58904_().m_7702_((BlockPos)tile.interfaceLocation.getValue());
            switch (type) {
                case FISSION: {
                    if (!(blockEntity instanceof TileFissionInterface)) {
                        font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileFissionInterface fissionInterface = (TileFissionInterface)blockEntity;
                    if (fissionInterface.reactor == null || !fissionInterface.reactor.valid() || !(fissionInterface.reactor.getSafe() instanceof TileFissionReactorCore)) {
                        font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileFissionReactorCore fissionCore = (TileFissionReactorCore)((Object)((Object)fissionInterface.reactor.getSafe()));
                    Minecraft.m_91087_().m_91291_().m_115123_(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.temperature", ChatFormatter.getChatDisplayShort((double)TileFissionReactorCore.getActualTemp((Double)fissionCore.temperature.getValue()), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS).m_130940_(ChatFormatting.GOLD)), (float)(guiWidth + 20), (float)(guiHeight + 45), Color.TEXT_GRAY.color());
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.fuel", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 65), Color.TEXT_GRAY.color());
                    ComponentInventory inventory = (ComponentInventory)fissionCore.getComponent(IComponentType.Inventory);
                    List fuels = inventory.getItems().subList(0, 4);
                    int i = 0;
                    int empty = 0;
                    for (ItemStack item : fuels) {
                        if (item.m_41619_()) {
                            RenderingUtils.bindTexture((ResourceLocation)EMPTY_FUEL.getLocation());
                            ScreenMonitorModule.m_93133_((PoseStack)poseStack, (int)(guiWidth + 20 + i * 20 + 2), (int)(guiHeight + 75 + 2), (float)EMPTY_FUEL.textureU(), (float)EMPTY_FUEL.textureV(), (int)EMPTY_FUEL.textureWidth(), (int)EMPTY_FUEL.textureHeight(), (int)EMPTY_FUEL.imageWidth(), (int)EMPTY_FUEL.imageHeight());
                            ++empty;
                        } else {
                            Minecraft.m_91087_().m_91291_().m_115123_(item, guiWidth + 20 + i * 20, guiHeight + 75);
                            Minecraft.m_91087_().m_91291_().m_115169_(font, item, guiWidth + 20 + i * 20, guiHeight + 75);
                        }
                        ++i;
                    }
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.other", new Object[0]), (float)(guiWidth + 110), (float)(guiHeight + 65), Color.TEXT_GRAY.color());
                    ItemStack deuterium = inventory.m_8020_(4);
                    if (deuterium.m_41619_()) {
                        RenderingUtils.bindTexture((ResourceLocation)EMPTY_FUEL.getLocation());
                        ScreenMonitorModule.m_93133_((PoseStack)poseStack, (int)(guiWidth + 110 + 2), (int)(guiHeight + 75 + 2), (float)EMPTY_FUEL.textureU(), (float)EMPTY_FUEL.textureV(), (int)EMPTY_FUEL.textureWidth(), (int)EMPTY_FUEL.textureHeight(), (int)EMPTY_FUEL.imageWidth(), (int)EMPTY_FUEL.imageHeight());
                    } else {
                        Minecraft.m_91087_().m_91291_().m_115123_(deuterium, guiWidth + 110, guiHeight + 75);
                        Minecraft.m_91087_().m_91291_().m_115169_(font, deuterium, guiWidth + 110, guiHeight + 75);
                    }
                    ItemStack tritium = (ItemStack)inventory.getOutputContents().get(0);
                    if (tritium.m_41619_()) {
                        RenderingUtils.bindTexture((ResourceLocation)EMPTY_FUEL.getLocation());
                        ScreenMonitorModule.m_93133_((PoseStack)poseStack, (int)(guiWidth + 130 + 2), (int)(guiHeight + 75 + 2), (float)EMPTY_FUEL.textureU(), (float)EMPTY_FUEL.textureV(), (int)EMPTY_FUEL.textureWidth(), (int)EMPTY_FUEL.textureHeight(), (int)EMPTY_FUEL.imageWidth(), (int)EMPTY_FUEL.imageHeight());
                    } else {
                        Minecraft.m_91087_().m_91291_().m_115123_(tritium, guiWidth + 130, guiHeight + 75);
                        Minecraft.m_91087_().m_91291_().m_115169_(font, tritium, guiWidth + 130, guiHeight + 75);
                    }
                    MutableComponent status = NuclearTextUtils.gui("logisticsnetwork.statusgood", new Object[0]).m_130940_(ChatFormatting.GREEN);
                    if (empty == 4) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusnofuel", new Object[0]).m_130940_(ChatFormatting.YELLOW);
                    } else if ((Double)fissionCore.temperature.getValue() > 5611.0) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusoverheat", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                    }
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.status", status), (float)(guiWidth + 20), (float)(guiHeight + 105), Color.TEXT_GRAY.color());
                    break;
                }
                case MS: {
                    if (!(blockEntity instanceof TileMSInterface)) {
                        font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileMSInterface msInterface = (TileMSInterface)blockEntity;
                    if (msInterface.reactor == null || !msInterface.reactor.valid() || !(msInterface.reactor.getSafe() instanceof TileMSReactorCore)) {
                        font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileMSReactorCore msCore = (TileMSReactorCore)((Object)((Object)msInterface.reactor.getSafe()));
                    Minecraft.m_91087_().m_91291_().m_115123_(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.temperature", ChatFormatter.getChatDisplayShort((double)((Double)msCore.temperature.getValue()), (IDisplayUnit)DisplayUnits.TEMPERATURE_CELCIUS).m_130940_(ChatFormatting.GOLD)), (float)(guiWidth + 20), (float)(guiHeight + 45), Color.TEXT_GRAY.color());
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.fuel", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 65), Color.TEXT_GRAY.color());
                    font.m_92889_(poseStack, (Component)VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)((Double)msCore.currentFuel.getValue() / 1000.0), (IDisplayUnit)DisplayUnits.BUCKETS), (Component)ChatFormatter.getChatDisplayShort((double)1.0, (IDisplayUnit)DisplayUnits.BUCKETS)), (float)(guiWidth + 30), (float)(guiHeight + 75), Color.WHITE.color());
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.waste", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 90), Color.TEXT_GRAY.color());
                    font.m_92889_(poseStack, (Component)VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)((Double)msCore.currentWaste.getValue() / 1000.0), (IDisplayUnit)DisplayUnits.BUCKETS), (Component)ChatFormatter.getChatDisplayShort((double)1.0, (IDisplayUnit)DisplayUnits.BUCKETS)), (float)(guiWidth + 30), (float)(guiHeight + 100), Color.WHITE.color());
                    MutableComponent status = NuclearTextUtils.gui("logisticsnetwork.statusgood", new Object[0]).m_130940_(ChatFormatting.GREEN);
                    if (!(msCore.clientPlugCache.getSafe() instanceof TileFreezePlug)) {
                        status = NuclearTextUtils.gui("msreactor.status.nofreezeplug", new Object[0]).m_130940_(ChatFormatting.RED);
                    } else {
                        TileFreezePlug plug;
                        Object patt11574$temp = msCore.clientPlugCache.getSafe();
                        if (patt11574$temp instanceof TileFreezePlug && !(plug = (TileFreezePlug)((Object)((Object)patt11574$temp))).isFrozen()) {
                            status = NuclearTextUtils.gui("msreactor.warning.freezeoff", new Object[0]).m_130940_(ChatFormatting.YELLOW);
                        } else if (((Boolean)msCore.wasteIsFull.getValue()).booleanValue()) {
                            status = NuclearTextUtils.gui("msreactor.status.wastefull", new Object[0]).m_130940_(ChatFormatting.YELLOW);
                        } else if ((Double)msCore.temperature.getValue() > 1000.0) {
                            status = NuclearTextUtils.gui("logisticsnetwork.statusoverheat", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD});
                        }
                    }
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.status", status), (float)(guiWidth + 20), (float)(guiHeight + 115), Color.TEXT_GRAY.color());
                    break;
                }
                case FUSION: {
                    if (!(blockEntity instanceof TileFusionInterface)) {
                        font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileFusionInterface fusionInterface = (TileFusionInterface)blockEntity;
                    if (fusionInterface.reactor == null || !fusionInterface.reactor.valid() || !(fusionInterface.reactor.getSafe() instanceof TileFusionReactorCore)) {
                        font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.unlinked", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 20), Color.TEXT_GRAY.color());
                        return;
                    }
                    TileFusionReactorCore fusionCore = (TileFusionReactorCore)((Object)((Object)fusionInterface.reactor.getSafe()));
                    ComponentElectrodynamic electro = (ComponentElectrodynamic)fusionCore.getComponent(IComponentType.Electrodynamic);
                    Minecraft.m_91087_().m_91291_().m_115123_(GenericTileInterface.getItemFromType(type), guiWidth + 80, guiHeight + 20);
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.deuterium", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 45), Color.TEXT_GRAY.color());
                    font.m_92889_(poseStack, (Component)VoltaicTextUtils.ratio((Component)new TextComponent("" + fusionCore.deuterium.getValue()), (Component)new TextComponent("" + NuclearConstants.FUSIONREACTOR_MAXSTORAGE)), (float)(guiWidth + 30), (float)(guiHeight + 55), Color.WHITE.color());
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.tritium", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 70), Color.TEXT_GRAY.color());
                    font.m_92889_(poseStack, (Component)VoltaicTextUtils.ratio((Component)new TextComponent("" + fusionCore.tritium.getValue()), (Component)new TextComponent("" + NuclearConstants.FUSIONREACTOR_MAXSTORAGE)), (float)(guiWidth + 30), (float)(guiHeight + 80), Color.WHITE.color());
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.power", new Object[0]), (float)(guiWidth + 20), (float)(guiHeight + 95), Color.TEXT_GRAY.color());
                    font.m_92889_(poseStack, (Component)ChatFormatter.getChatDisplayShort((double)(Math.min(1.0, electro.getJoulesStored() / NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK) * 100.0), (IDisplayUnit)DisplayUnits.PERCENTAGE), (float)(guiWidth + 30), (float)(guiHeight + 105), Color.WHITE.color());
                    MutableComponent status = NuclearTextUtils.gui("logisticsnetwork.statusgood", new Object[0]).m_130940_(ChatFormatting.GREEN);
                    if ((Integer)fusionCore.tritium.getValue() < 1 || (Integer)fusionCore.deuterium.getValue() < 1) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusnofuel", new Object[0]).m_130940_(ChatFormatting.RED);
                    } else if (electro.getJoulesStored() < NuclearConstants.FUSIONREACTOR_USAGE_PER_TICK) {
                        status = NuclearTextUtils.gui("logisticsnetwork.statusnopower", new Object[0]).m_130940_(ChatFormatting.YELLOW);
                    }
                    font.m_92889_(poseStack, (Component)NuclearTextUtils.gui("logisticsnetwork.status", status), (float)(guiWidth + 20), (float)(guiHeight + 120), Color.TEXT_GRAY.color());
                    break;
                }
            }
        }));
    }

    @Override
    public void updateNonSelectorVisibility(boolean visible) {
        this.hidden = !visible;
    }
}

