/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import nuclearscience.common.entity.EntityParticle;
import nuclearscience.common.inventory.container.ContainerParticleInjector;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.accelerator.TileElectromagneticGateway;
import nuclearscience.common.tile.accelerator.TileParticleInjector;
import nuclearscience.compatibility.jei.utils.NuclearJeiTextures;
import nuclearscience.prefab.screen.component.NuclearArrows;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.utils.NuclearDisplayUnits;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.types.wrapper.WrapperInventoryIO;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.math.Color;

public class ScreenParticleInjector
extends GenericScreen<ContainerParticleInjector> {
    public ScreenParticleInjector(ContainerParticleInjector container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.f_97727_ += 10;
        this.f_97731_ += 10;
        this.addComponent((AbstractScreenComponent)new ScreenComponentGeneric((ITexture)NuclearArrows.PARTICLE_INJECTOR_ARROWS, 44, 24));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(this.f_97728_, this.f_97729_ + 20, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("particleinjector.matter", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(this.f_97728_, this.f_97729_ + 56, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("particleinjector.cells", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getElectricInformation, -25, 2).wattage(NuclearConstants.PARTICLEINJECTOR_USAGE_PER_PARTICLE));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, -25, 54).setOnPress(button -> {
            TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.f_97732_).getSafeHost();
            if (injector == null) {
                return;
            }
            injector.usingGateway.setValue((Object)((Boolean)injector.usingGateway.getValue() == false ? 1 : 0));
        }).setIcon((ITexture)NuclearIconTypes.GATEWAY).onTooltip((poseStack, button, x, y) -> {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.f_97732_).getSafeHost();
            if (injector == null) {
                return;
            }
            list.add(NuclearTextUtils.tooltip("particleinjector.gatewaymode", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            if (((Boolean)injector.usingGateway.getValue()).booleanValue()) {
                list.add(NuclearTextUtils.tooltip("particleinjector.gatewayenabled", new Object[0]).m_130940_(ChatFormatting.GREEN).m_7532_());
            } else {
                list.add(NuclearTextUtils.tooltip("particleinjector.gatewaydisabled", new Object[0]).m_130940_(ChatFormatting.RED).m_7532_());
            }
            this.displayTooltips(poseStack, list, x, y);
        }));
        new WrapperInventoryIO((GenericScreen)this, -25, 28, 75, 82, 8, 72);
        this.addComponent((AbstractScreenComponent)new ScreenComponentGeneric((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR_RIGHT, this.f_97726_ - 1, 2).setIcon((ITexture)NuclearJeiTextures.PARTICLEACCELERATOR_DMATOM).onTooltip((poseStack, component, x, y) -> {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.f_97732_).getSafeHost();
            if (injector == null) {
                return;
            }
            EntityParticle one = injector.particles[0];
            float oneSpeed = 0.0f;
            if (one != null && one.m_6084_() && !one.m_146910_()) {
                oneSpeed = one.speed;
            }
            list.add(NuclearTextUtils.tooltip("particleinjector.particle1speed", ChatFormatter.getChatDisplayShort((double)TileElectromagneticGateway.getLightSpeedPerc(oneSpeed), (IDisplayUnit)DisplayUnits.PERCENTAGE).m_130946_(" ").m_7220_(NuclearDisplayUnits.SPEEDOFLIGHT.getSymbol()).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            EntityParticle two = injector.particles[1];
            float twoSpeed = 0.0f;
            if (two != null && two.m_6084_() && !two.m_146910_()) {
                twoSpeed = two.speed;
            }
            list.add(NuclearTextUtils.tooltip("particleinjector.particle2speed", ChatFormatter.getChatDisplayShort((double)TileElectromagneticGateway.getLightSpeedPerc(twoSpeed), (IDisplayUnit)DisplayUnits.PERCENTAGE).m_130946_(" ").m_7220_(NuclearDisplayUnits.SPEEDOFLIGHT.getSymbol()).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            this.m_96617_(poseStack, list, x, y);
        }));
    }

    private List<? extends FormattedCharSequence> getElectricInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileParticleInjector injector = (TileParticleInjector)((ContainerParticleInjector)this.f_97732_).getSafeHost();
        if (injector == null) {
            return list;
        }
        ComponentElectrodynamic el = (ComponentElectrodynamic)injector.getComponent(IComponentType.Electrodynamic);
        list.add(NuclearTextUtils.tooltip("particleinjector.charge", ChatFormatter.getChatDisplayShort((double)el.getJoulesStored(), (IDisplayUnit)DisplayUnits.JOULES).m_130940_(ChatFormatting.GRAY), ChatFormatter.getChatDisplayShort((double)NuclearConstants.PARTICLEINJECTOR_USAGE_PER_PARTICLE, (IDisplayUnit)DisplayUnits.JOULES).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        list.add(ElectroTextUtils.gui((String)"machine.voltage", (Object[])new Object[]{ChatFormatter.getChatDisplayShort((double)el.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        return list;
    }
}

