/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.common.inventory.container.ContainerQuantumTunnel;
import nuclearscience.common.tile.TileQuantumTunnel;
import nuclearscience.prefab.screen.component.NuclearIconTypes;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperEditFrequency;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperIOEditor;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperNewFrequency;
import nuclearscience.prefab.screen.component.quantumtunnel.WrapperQuantumTunnelFrequencies;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.types.ScreenComponentVerticalSlider;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentGuiTab;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.object.TransferPack;

public class ScreenQuantumTunnel
extends GenericScreen<ContainerQuantumTunnel> {
    public WrapperQuantumTunnelFrequencies frequencyWrapper;
    public WrapperIOEditor ioWrapper;
    public WrapperNewFrequency newFrequencyWrapper;
    public WrapperEditFrequency editFrequencyWrapper;
    public ScreenComponentVerticalSlider slider;

    public ScreenQuantumTunnel(ContainerQuantumTunnel container, Inventory playerInventory, Component title) {
        super((GenericContainer)container, playerInventory, title);
        this.f_97727_ += 35;
        this.frequencyWrapper = new WrapperQuantumTunnelFrequencies(this, 0, 0);
        this.slider = new ScreenComponentVerticalSlider(5, 64, 125).setClickConsumer(this.frequencyWrapper.getSliderClickedConsumer()).setDragConsumer(this.frequencyWrapper.getSliderDraggedConsumer());
        this.addComponent((AbstractScreenComponent)this.slider);
        this.ioWrapper = new WrapperIOEditor(this, -25, 28, 80, 28, 8, 23);
        this.newFrequencyWrapper = new WrapperNewFrequency(this, -25, 2, 0, 15);
        this.editFrequencyWrapper = new WrapperEditFrequency(this, 0, 10);
        this.addComponent((AbstractScreenComponent)new ScreenComponentGuiTab((ITexture)ScreenComponentGuiTab.GuiInfoTabTextures.REGULAR, (ITexture)NuclearIconTypes.BUFFER, () -> {
            TileQuantumTunnel tile = (TileQuantumTunnel)((ContainerQuantumTunnel)this.m_6262_()).getSafeHost();
            if (tile == null) {
                return Collections.emptyList();
            }
            TunnelFrequencyBuffer buffer = tile.clientBuffer;
            ArrayList<FormattedCharSequence> info = new ArrayList<FormattedCharSequence>();
            info.add(NuclearTextUtils.tooltip("quantumtunnel.buffer", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}).m_7532_());
            ItemStack item = buffer.getBufferedItem();
            info.add(new TranslatableComponent(item.m_41778_()).m_7532_());
            info.add(new TextComponent(" " + item.m_41613_()).m_130940_(ChatFormatting.GRAY).m_7532_());
            FluidStack fluid = buffer.getBufferedFluid();
            info.add(new TranslatableComponent(fluid.getTranslationKey()).m_7532_());
            info.add(new TextComponent(" ").m_7220_((Component)ChatFormatter.formatFluidMilibuckets((double)fluid.getAmount()).m_130940_(ChatFormatting.GRAY)).m_7532_());
            TransferPack energy = buffer.getBufferedEnergy();
            info.add(ChatFormatter.getChatDisplayShort((double)energy.getJoules(), (IDisplayUnit)DisplayUnits.JOULES).m_7532_());
            info.add(new TextComponent(" ").m_7220_((Component)ChatFormatter.getChatDisplayShort((double)energy.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_7532_());
            return info;
        }, -25, 54));
    }

    protected void m_181908_() {
        super.m_181908_();
        this.frequencyWrapper.tick();
    }

    protected void initializeComponents() {
        super.initializeComponents();
        this.playerInvLabel.setVisible(false);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.frequencyWrapper != null) {
            if (pDelta > 0.0) {
                this.frequencyWrapper.handleMouseScroll(-1);
            } else if (pDelta < 0.0) {
                this.frequencyWrapper.handleMouseScroll(1);
            }
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.slider != null && this.slider.isVisible()) {
            this.slider.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.slider != null && this.slider.isVisible()) {
            this.slider.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)pKeyCode, (int)pScanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.newFrequencyWrapper.nameEditBox.isFocused()) {
            return false;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.slider.isVisible()) {
            return this.slider.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }
}

