/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import nuclearscience.common.inventory.container.ContainerTeleporter;
import nuclearscience.common.item.ItemFrequencyCard;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.TileTeleporter;
import nuclearscience.prefab.utils.NuclearTextUtils;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.button.ScreenComponentButton;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.utilities.math.Color;

public class ScreenTeleporter
extends GenericScreen<ContainerTeleporter> {
    private final ScreenComponentEditBox xBox;
    private final ScreenComponentEditBox yBox;
    private final ScreenComponentEditBox zBox;
    private boolean needsUpdate = true;

    public ScreenTeleporter(ContainerTeleporter container, Inventory inv, Component title) {
        super((GenericContainer)container, inv, title);
        this.f_97727_ += 50;
        this.f_97731_ += 50;
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 20, 10, Color.TEXT_GRAY, () -> {
            TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.m_6262_()).getSafeHost();
            if (tile == null) {
                return new TextComponent("");
            }
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)((ResourceLocation)tile.dimension.getValue()));
            if (ElectroTextUtils.dimensionExists((ResourceKey)dimension)) {
                return ElectroTextUtils.dimension((ResourceKey)dimension, (Object[])new Object[0]);
            }
            return new TextComponent(dimension.m_135782_().m_135815_());
        }));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 33, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("teleporter.x", new Object[0])));
        this.xBox = new ScreenComponentEditBox(40, 30, 60, 13, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(9).setResponder(this::updateX).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.xBox);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 49, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("teleporter.y", new Object[0])));
        this.yBox = new ScreenComponentEditBox(40, 46, 60, 13, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(9).setResponder(this::updateY).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.yBox);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(30, 65, 10, Color.TEXT_GRAY, (Component)NuclearTextUtils.gui("teleporter.z", new Object[0])));
        this.zBox = new ScreenComponentEditBox(40, 62, 60, 13, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(9).setResponder(this::updateZ).setFilter(ScreenComponentEditBox.INTEGER);
        this.addEditBox(this.zBox);
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(50, 78, 100, 20).setOnPress(button -> {
            TileTeleporter tile = (TileTeleporter)container.getSafeHost();
            if (tile == null) {
                return;
            }
            ItemStack input = ((ComponentInventory)tile.getComponent(IComponentType.Inventory)).m_8020_(0);
            if (input.m_41619_() || !input.m_41782_() || input.m_41783_().m_128441_("loc")) {
                return;
            }
            tile.destination.setValue((Object)ItemFrequencyCard.readBlockPos(input));
            if (input.m_41783_().m_128441_("dimension")) {
                tile.dimension.setValue(ItemFrequencyCard.readDimension(input));
            }
        }).setLabel((Component)NuclearTextUtils.gui("teleporter.import", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentButton(30, 100, 120, 20).setOnPress(button -> {
            TileTeleporter tile = (TileTeleporter)container.getSafeHost();
            if (tile == null) {
                return;
            }
            tile.destination.setValue((Object)tile.m_58899_());
            tile.dimension.setValue((Object)Level.f_46428_.m_135782_());
            this.xBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.f_97732_).getSafeHost()).destination.getValue()).m_123341_());
            this.yBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.f_97732_).getSafeHost()).destination.getValue()).m_123342_());
            this.zBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.f_97732_).getSafeHost()).destination.getValue()).m_123343_());
        }).setLabel((Component)NuclearTextUtils.gui("teleporter.reset", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(-25, 2).wattage(NuclearConstants.TELEPORTER_USAGE_PER_TELEPORT / 20.0));
        this.xBox.setFocus(false);
        this.yBox.setFocus(false);
        this.zBox.setFocus(false);
    }

    private void updateX(String val) {
        this.xBox.setFocus(true);
        this.yBox.setFocus(false);
        this.zBox.setFocus(false);
        this.handleX(val);
    }

    private void updateY(String val) {
        this.xBox.setFocus(false);
        this.yBox.setFocus(true);
        this.zBox.setFocus(false);
        this.handleY(val);
    }

    private void updateZ(String val) {
        this.xBox.setFocus(false);
        this.yBox.setFocus(false);
        this.zBox.setFocus(true);
        this.handleZ(val);
    }

    private void handleX(String freq) {
        if (freq.isEmpty()) {
            return;
        }
        Integer x = 0;
        try {
            x = Integer.parseInt(this.xBox.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.f_97732_).getSafeHost();
        if (tile == null) {
            return;
        }
        BlockPos dest = (BlockPos)tile.destination.getValue();
        tile.destination.setValue((Object)new BlockPos(x.intValue(), dest.m_123342_(), dest.m_123343_()));
    }

    private void handleY(String out) {
        if (out.isEmpty()) {
            return;
        }
        Integer y = 0;
        try {
            y = Integer.parseInt(this.yBox.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.f_97732_).getSafeHost();
        if (tile == null) {
            return;
        }
        BlockPos dest = (BlockPos)tile.destination.getValue();
        tile.destination.setValue((Object)new BlockPos(dest.m_123341_(), y.intValue(), dest.m_123343_()));
    }

    private void handleZ(String out) {
        if (out.isEmpty()) {
            return;
        }
        Integer z = 0;
        try {
            z = Integer.parseInt(this.zBox.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        TileTeleporter tile = (TileTeleporter)((ContainerTeleporter)this.f_97732_).getSafeHost();
        if (tile == null) {
            return;
        }
        BlockPos dest = (BlockPos)tile.destination.getValue();
        tile.destination.setValue((Object)new BlockPos(dest.m_123341_(), dest.m_123342_(), z.intValue()));
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (this.needsUpdate && ((ContainerTeleporter)this.f_97732_).getSafeHost() != null) {
            this.needsUpdate = false;
            this.xBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.f_97732_).getSafeHost()).destination.getValue()).m_123341_());
            this.yBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.f_97732_).getSafeHost()).destination.getValue()).m_123342_());
            this.zBox.setValue("" + ((BlockPos)((TileTeleporter)((ContainerTeleporter)this.f_97732_).getSafeHost()).destination.getValue()).m_123343_());
        }
    }
}

