/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.block.subtype.SubtypeIrradiatedBlock;
import nuclearscience.registers.NuclearScienceBlocks;
import voltaic.api.radiation.util.IRadiationManager;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class BlockIrradiated
extends Block {
    public final SubtypeIrradiatedBlock subtype;

    public BlockIrradiated(SubtypeIrradiatedBlock subtype) {
        super(subtype.properties);
        this.subtype = subtype;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        IRadiationManager manager = (IRadiationManager)level.getCapability(VoltaicCapabilities.CAPABILITY_RADIATIONMANAGER).orElse((Object)CapabilityUtils.EMPTY_MANAGER);
        if (manager == CapabilityUtils.EMPTY_MANAGER) {
            return;
        }
        int radius = manager.getReachOfSource((Level)level, pos);
        if (radius <= 0) {
            return;
        }
        BlockState other = level.m_8055_(pos);
        pos = pos.m_142082_(level.f_46441_.nextInt(-radius, radius + 1), level.f_46441_.nextInt(-radius, radius + 1), level.f_46441_.nextInt(-radius, radius + 1));
        if (BlockIrradiated.isValidPlacement(other)) {
            level.m_46597_(pos, BlockIrradiated.getIrradiatedBlockstate(other));
        }
    }

    public static boolean isValidPlacement(BlockState state) {
        return state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_50440_) || state.m_204336_(BlockTags.f_13106_);
    }

    public static BlockState getIrradiatedBlockstate(BlockState state) {
        if (state.m_204336_(BlockTags.f_144274_)) {
            return ((BlockIrradiated)((Object)NuclearScienceBlocks.BLOCKS_IRRADIATED.getValue((Object)SubtypeIrradiatedBlock.soil))).m_49966_();
        }
        if (state.m_60713_(Blocks.f_50440_)) {
            return ((BlockIrradiated)((Object)NuclearScienceBlocks.BLOCKS_IRRADIATED.getValue((Object)SubtypeIrradiatedBlock.grass))).m_49966_();
        }
        if (state.m_204336_(BlockTags.f_13106_)) {
            return ((BlockIrradiated)((Object)NuclearScienceBlocks.BLOCKS_IRRADIATED.getValue((Object)SubtypeIrradiatedBlock.petrifiedwood))).m_49966_();
        }
        return state;
    }
}

