/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.item;

import electrodynamics.common.item.gear.tools.ItemCanister;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import nuclearscience.registers.NuclearScienceItems;
import voltaic.api.radiation.RadiationSystem;
import voltaic.api.radiation.SimpleRadiationSource;
import voltaic.api.radiation.util.RadioactiveObject;
import voltaic.common.reloadlistener.RadioactiveFluidRegister;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.ItemUtils;

public class ItemCanisterLead
extends ItemCanister {
    public static final int RAD_RANGE = 10;
    public static List<ResourceLocation> TAG_NAMES = new ArrayList<ResourceLocation>();

    public ItemCanisterLead(Item.Properties oroperties, Supplier<CreativeModeTab> creativeTab) {
        super(oroperties, creativeTab);
        INVENTORY_TICK_CONSUMERS.add((stack, world, entity, slot, isSelected) -> {
            if (ItemUtils.testItems((Item)stack.m_41720_(), (Item[])new Item[]{(Item)NuclearScienceItems.ITEM_CANISTERLEAD.get()})) {
                return;
            }
            IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
            if (cap == CapabilityUtils.EMPTY_FLUID_ITEM) {
                return;
            }
            FluidStack fluidStack = cap.getFluidInTank(0);
            if (fluidStack.isEmpty()) {
                return;
            }
            RadioactiveObject radiation = RadioactiveFluidRegister.getValue((Fluid)fluidStack.getFluid());
            if (radiation.amount() <= 0.0) {
                return;
            }
            double radiationMultiplier = (double)fluidStack.getAmount() / (double)cap.getTankCapacity(0);
            RadiationSystem.addRadiationSource((Level)world, (SimpleRadiationSource)new SimpleRadiationSource(radiation.amount() * radiationMultiplier, radiation.strength(), 10, true, 0, entity.m_20097_(), false));
        });
    }
}

