/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet.type.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.common.packet.type.client.ClientBarrierMethods;
import voltaic.api.codec.StreamCodec;

public class PacketSetClientTunnelFrequencies {
    public static final StreamCodec<FriendlyByteBuf, PacketSetClientTunnelFrequencies> CODEC = new StreamCodec<FriendlyByteBuf, PacketSetClientTunnelFrequencies>(){

        public PacketSetClientTunnelFrequencies decode(FriendlyByteBuf buf) {
            HashMap<UUID, HashSet<TunnelFrequency>> data = new HashMap<UUID, HashSet<TunnelFrequency>>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                UUID id = (UUID)StreamCodec.UUID.decode((Object)buf);
                HashSet<TunnelFrequency> set = new HashSet<TunnelFrequency>();
                int setSize = buf.readInt();
                for (int j = 0; j < setSize; ++j) {
                    set.add((TunnelFrequency)TunnelFrequency.STREAM_CODEC.decode((Object)buf));
                }
                data.put(id, set);
            }
            return new PacketSetClientTunnelFrequencies(data, (TunnelFrequencyBuffer)TunnelFrequencyBuffer.STREAM_CODEC.decode((Object)buf), (BlockPos)StreamCodec.BLOCK_POS.decode((Object)buf));
        }

        public void encode(FriendlyByteBuf buf, PacketSetClientTunnelFrequencies packet) {
            buf.writeInt(packet.frequencies.size());
            for (Map.Entry<UUID, HashSet<TunnelFrequency>> entry : packet.frequencies.entrySet()) {
                StreamCodec.UUID.encode((Object)buf, (Object)entry.getKey());
                buf.writeInt(entry.getValue().size());
                for (TunnelFrequency freq : entry.getValue()) {
                    TunnelFrequency.STREAM_CODEC.encode((Object)buf, (Object)freq);
                }
            }
            TunnelFrequencyBuffer.STREAM_CODEC.encode((Object)buf, (Object)packet.currBuffer);
            StreamCodec.BLOCK_POS.encode((Object)buf, (Object)packet.tilePos);
        }
    };
    private final HashMap<UUID, HashSet<TunnelFrequency>> frequencies;
    private final TunnelFrequencyBuffer currBuffer;
    private final BlockPos tilePos;

    public PacketSetClientTunnelFrequencies(HashMap<UUID, HashSet<TunnelFrequency>> frequencies, TunnelFrequencyBuffer currBuffer, BlockPos tilePos) {
        this.frequencies = frequencies;
        this.currBuffer = currBuffer;
        this.tilePos = tilePos;
    }

    public static void handle(PacketSetClientTunnelFrequencies message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ClientBarrierMethods.handleSetClientTunnelFrequencies(message.frequencies, message.currBuffer, message.tilePos));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSetClientTunnelFrequencies pkt, FriendlyByteBuf buf) {
        CODEC.encode((Object)buf, (Object)pkt);
    }

    public static PacketSetClientTunnelFrequencies decode(FriendlyByteBuf buf) {
        return (PacketSetClientTunnelFrequencies)CODEC.decode((Object)buf);
    }
}

