/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.reloadlistener;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import nuclearscience.common.packet.type.client.PacketSetClientAtomicAssemblerWhitelistVals;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import voltaic.Voltaic;

public class AtomicAssemblerWhitelistRegister
extends SimplePreparableReloadListener<JsonObject> {
    public static AtomicAssemblerWhitelistRegister INSTANCE = null;
    public static final String KEY = "values";
    public static final String FOLDER = "machines";
    public static final String FILE_NAME = "atomic_assembler_whitelist";
    protected static final String JSON_EXTENSION = ".json";
    protected static final int JSON_EXTENSION_LENGTH = ".json".length();
    private static final Gson GSON = new Gson();
    private final HashSet<Item> whitelistedItems = new HashSet();
    private final HashSet<TagKey<Item>> tags = new HashSet();
    private final Logger logger = Voltaic.LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonObject prepare(ResourceManager manager, ProfilerFiller profiler) {
        JsonObject blacklistedItems = new JsonObject();
        ArrayList resources = new ArrayList(manager.m_6540_(FOLDER, AtomicAssemblerWhitelistRegister::isStringJsonFile));
        Collections.reverse(resources);
        JsonArray combinedArray = new JsonArray();
        for (ResourceLocation entry : resources) {
            String namespace = entry.m_135827_();
            String filePath = entry.m_135815_();
            String dataPath = filePath.substring(FOLDER.length() + 1, filePath.length() - JSON_EXTENSION_LENGTH);
            ResourceLocation jsonFile = new ResourceLocation(namespace, dataPath);
            try {
                for (Resource resource : manager.m_7396_(jsonFile)) {
                    try {
                        InputStream inputStream = resource.m_6679_();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                            JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                            combinedArray.addAll(json.get(KEY).getAsJsonArray());
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (IOException | RuntimeException exception) {
                        this.logger.error("Data loader for {} could not read data {} from file {} in data pack {}", (Object)FOLDER, (Object)jsonFile, (Object)entry, (Object)resource.m_7843_(), (Object)exception);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException exception) {
                this.logger.error("Data loader for {} could not read data {} from file {}", (Object)FOLDER, (Object)jsonFile, (Object)entry, (Object)exception);
            }
        }
        blacklistedItems.add(KEY, (JsonElement)combinedArray);
        return blacklistedItems;
    }

    protected void apply(JsonObject json, ResourceManager manager, ProfilerFiller profiler) {
        this.whitelistedItems.clear();
        this.tags.clear();
        ArrayList list = (ArrayList)GSON.fromJson((JsonElement)json.get(KEY).getAsJsonArray(), ArrayList.class);
        list.forEach(key -> {
            if (key.charAt(0) == '#') {
                this.tags.add((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation(key.substring(1))));
            } else {
                this.whitelistedItems.add((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(key)));
            }
        });
    }

    public void generateTagValues() {
        this.tags.forEach(tag -> {
            for (ItemStack item : Ingredient.m_204132_((TagKey)tag).m_43908_()) {
                this.whitelistedItems.add(item.m_41720_());
            }
        });
        this.tags.clear();
    }

    public void setClientValues(HashSet<Item> fuels) {
        this.whitelistedItems.clear();
        this.whitelistedItems.addAll(fuels);
    }

    public AtomicAssemblerWhitelistRegister subscribeAsSyncable(SimpleChannel channel) {
        MinecraftForge.EVENT_BUS.addListener(this.getDatapackSyncListener(channel));
        return this;
    }

    public HashSet<Item> getWhitelist() {
        return this.whitelistedItems;
    }

    public boolean isWhitelisted(Item item) {
        return this.whitelistedItems.contains(item);
    }

    private Consumer<OnDatapackSyncEvent> getDatapackSyncListener(SimpleChannel channel) {
        return event -> {
            this.generateTagValues();
            ServerPlayer player = event.getPlayer();
            PacketSetClientAtomicAssemblerWhitelistVals packet = new PacketSetClientAtomicAssemblerWhitelistVals(this.whitelistedItems);
            PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
            channel.send(target, (Object)packet);
        };
    }

    private static boolean isStringJsonFile(String filename) {
        return filename.endsWith("atomic_assembler_whitelist.json");
    }
}

