/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import nuclearscience.common.inventory.container.ContainerAtomicAssembler;
import nuclearscience.common.reloadlistener.AtomicAssemblerBlacklistRegister;
import nuclearscience.common.reloadlistener.AtomicAssemblerWhitelistRegister;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileAtomicAssembler
extends GenericTile {
    public final SingleProperty<Integer> progress = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "progress", (Object)0));

    public TileAtomicAssembler(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_ATOMICASSEMBLER.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickCommon(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).maxJoules(NuclearConstants.ATOMICASSEMBLER_USAGE_PER_TICK * 20.0).voltage(NuclearConstants.ATOMICASSEMBLER_VOLTAGE).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(7).outputs(1)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1, 2, 3, 4, 5}).setDirectionsBySlot(Integer.valueOf(6), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.BACK}).setDirectionsBySlot(Integer.valueOf(7), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.FRONT}).valid((slot, stack, i) -> slot == 6 || slot < 6 && stack.m_150930_((Item)NuclearScienceItems.ITEM_CELLDARKMATTER.get())));
        this.addComponent((IComponent)new ComponentContainerProvider("atomicassembler", (GenericTile)this).createMenu((id, player) -> new ContainerAtomicAssembler((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tickable) {
        boolean validItem;
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = inv.m_8020_(6);
        if (input.m_41619_()) {
            this.progress.setValue((Object)0);
            return;
        }
        if (tickable.getTicks() % 2L == 0L) {
            RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)inv, (int)NuclearConstants.ATOMIC_ASSEMBLER_RADIATION_RADIUS, (boolean)true, (int)0, (boolean)false);
        }
        ItemStack output = inv.m_8020_(7);
        boolean bl = validItem = this.validateDupeItem(input) && (output.m_41619_() || ItemStack.m_150942_((ItemStack)input, (ItemStack)output) && output.m_41613_() + 1 <= output.m_41741_());
        if (!validItem) {
            this.progress.setValue((Object)0);
            return;
        }
        for (int index = 0; index < 6; ++index) {
            ItemStack dmCell = inv.m_8020_(index);
            if (dmCell.m_41619_() || dmCell.m_41720_() != NuclearScienceItems.ITEM_CELLDARKMATTER.get()) {
                this.progress.setValue((Object)0);
                return;
            }
            if (dmCell.m_41773_() < dmCell.m_41776_()) continue;
            this.progress.setValue((Object)0);
            inv.m_6836_(index, ItemStack.f_41583_);
            return;
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < NuclearConstants.ATOMICASSEMBLER_USAGE_PER_TICK) {
            return;
        }
        this.progress.setValue((Object)((Integer)this.progress.getValue() + 1));
        electro.joules(electro.getJoulesStored() - NuclearConstants.ATOMICASSEMBLER_USAGE_PER_TICK);
        if ((Integer)this.progress.getValue() < NuclearConstants.ATOMICASSEMBLER_REQUIRED_TICKS) {
            return;
        }
        this.progress.setValue((Object)0);
        for (int index = 0; index < 6; ++index) {
            ItemStack dmCell = inv.m_8020_(index);
            dmCell.m_41721_(dmCell.m_41773_() + 1);
            if (dmCell.m_41773_() < dmCell.m_41776_()) continue;
            inv.m_6836_(index, ItemStack.f_41583_);
        }
        if (output.m_41619_()) {
            inv.m_6836_(7, new ItemStack((ItemLike)input.m_41720_()));
        } else {
            output.m_41764_(output.m_41613_() + 1);
        }
    }

    private boolean validateDupeItem(ItemStack stack) {
        if (AtomicAssemblerWhitelistRegister.INSTANCE.isWhitelisted(stack.m_41720_())) {
            return true;
        }
        if (AtomicAssemblerBlacklistRegister.INSTANCE.isBlacklisted(stack.m_41720_())) {
            return false;
        }
        if (stack.m_41782_()) {
            return false;
        }
        return !ItemUtils.testItems((Item)stack.m_41720_(), (Item[])new Item[]{(Item)NuclearScienceItems.ITEM_CELLDARKMATTER.get()}) || stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER) == CapabilityUtils.EMPTY_ITEM_HANDLER;
    }
}

