/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import nuclearscience.client.event.levelstage.HandlerCloudChamber;
import nuclearscience.common.inventory.container.ContainerCloudChamber;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.radiation.RadiationSystem;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.ListProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileCloudChamber
extends GenericTile {
    public static final int HORR_RADIUS = 30;
    private static final int VERT_RADIUS = 30;
    public final ListProperty<BlockPos> sources = (ListProperty)this.property((AbstractProperty)new ListProperty(PropertyTypes.BLOCK_POS_LIST, "sources", new ArrayList()));
    public final SingleProperty<Boolean> active = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "active", (Object)false));
    public final SingleProperty<Boolean> sourcesDetected = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "detectedsources", (Object)false));
    private final SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));

    public TileCloudChamber(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_CLOUDCHAMBER.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(120.0).maxJoules(NuclearConstants.CLOUD_CHAMBER_ENERGY_USAGE_PER_TICK * 20.0));
        this.addComponent((IComponent)new ComponentFluidHandlerSimple(100, fluidStack -> fluidStack.getFluid().m_205067_(NuclearScienceTags.Fluids.METHANOL), (GenericTile)this, "methanolstorage").setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}));
        this.addComponent((IComponent)new ComponentContainerProvider("cloudchamber", (GenericTile)this).createMenu((id, player) -> new ContainerCloudChamber((int)id, (Inventory)player, (Container)new SimpleContainer(new ItemStack[0]), (ContainerData)this.getCoordsArray())));
    }

    private void tickClient(ComponentTickable tickable) {
        if (((Boolean)this.sourcesDetected.getValue()).booleanValue()) {
            HandlerCloudChamber.addSources(this);
        } else {
            HandlerCloudChamber.removeSources(this);
        }
    }

    private void tickServer(ComponentTickable tickable) {
        this.sources.wipeList();
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            this.active.setValue((Object)false);
            this.sourcesDetected.setValue((Object)false);
            return;
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < NuclearConstants.CLOUD_CHAMBER_ENERGY_USAGE_PER_TICK) {
            this.active.setValue((Object)false);
            this.sourcesDetected.setValue((Object)false);
            return;
        }
        ComponentFluidHandlerSimple fluid = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        if (fluid.isEmpty() || (double)fluid.getFluidAmount() < NuclearConstants.CLOUD_CHAMBER_ENERGY_USAGE_PER_TICK) {
            this.active.setValue((Object)false);
            this.sourcesDetected.setValue((Object)false);
            return;
        }
        this.active.setValue((Object)true);
        electro.setJoulesStored(electro.getJoulesStored() - NuclearConstants.CLOUD_CHAMBER_ENERGY_USAGE_PER_TICK);
        fluid.drain(NuclearConstants.CLOUD_CHAMBER_FLUID_USAGE_PER_TICK, IFluidHandler.FluidAction.EXECUTE);
        List sources = RadiationSystem.getRadiationSources((Level)this.m_58904_());
        ArrayList accepted = new ArrayList();
        BlockPos pos = this.m_58899_();
        sources.forEach(source -> {
            int deltaX = source.m_123341_() - pos.m_123341_();
            int deltaY = source.m_123342_() - pos.m_123342_();
            int deltaZ = source.m_123343_() - pos.m_123343_();
            if (Math.abs(deltaY) > 30 || Math.abs(deltaX) > 30 || Math.abs(deltaZ) > 30) {
                return;
            }
            accepted.add(source);
        });
        this.sourcesDetected.setValue((Object)(!accepted.isEmpty() ? 1 : 0));
        if (accepted.isEmpty()) {
            return;
        }
        this.sources.addValues(accepted);
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (!this.f_58857_.f_46443_) {
            this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_46753_(this.m_58899_()));
        }
    }
}

