/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import nuclearscience.common.inventory.container.ContainerNuclearBoiler;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.TileGasCentrifuge;
import nuclearscience.registers.NuclearScienceRecipies;
import nuclearscience.registers.NuclearScienceSounds;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileNuclearBoiler
extends GenericTile
implements ITickableSound {
    public static final int MAX_FLUID_TANK_CAPACITY = 5000;
    public static final int MAX_GAS_TANK_CAPACITY = 5000;
    public static final int MAX_TEMPERATURE = 1000;
    public static final int MAX_PRESSURE = 10;
    private boolean isSoundPlaying = false;

    public TileNuclearBoiler(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_CHEMICALBOILER.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(240.0));
        this.addComponent((IComponent)new ComponentFluidHandlerMulti((GenericTile)this).setTanks(1, 1, new int[]{5000}, TileNuclearBoiler.arr((int[])new int[]{5000})).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT}).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT}).setRecipeType((RecipeType)NuclearScienceRecipies.NUCLEAR_BOILER_TYPE.get()));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(1, 1, 0, 0).bucketInputs(1).gasOutputs(1).upgrades(3)).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.TOP}).validUpgrades(ContainerNuclearBoiler.VALID_UPGRADES).valid(TileNuclearBoiler.machineValidator()));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess((component, procNumber) -> component.outputToFluidPipe().consumeBucket().dispenseBucket().canProcessFluidItem2FluidRecipe(procNumber.intValue(), (RecipeType)NuclearScienceRecipies.NUCLEAR_BOILER_TYPE.get())).process(ComponentProcessor::processFluidItem2FluidRecipe));
        this.addComponent((IComponent)new ComponentContainerProvider("nuclearboiler", (GenericTile)this).createMenu((id, player) -> new ContainerNuclearBoiler((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        TileGasCentrifuge centrifuge;
        ComponentFluidHandlerMulti centrifugeHandler;
        Level world = this.m_58904_();
        if (((ComponentTickable)this.getComponent(IComponentType.Tickable)).getTicks() % 2L == 0L) {
            RadiationUtils.handleRadioactiveFluids((GenericTile)this, (ComponentFluidHandlerMulti)((ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler)), (int)NuclearConstants.NUCLEAR_BOILER_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)false);
            RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)((ComponentInventory)this.getComponent(IComponentType.Inventory)), (int)NuclearConstants.NUCLEAR_BOILER_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)false);
        }
        Direction centrifugeDir = this.getFacing().m_122428_();
        BlockEntity tile = world.m_7702_(this.m_58899_().m_142300_(centrifugeDir));
        if (tile != null && tile instanceof TileGasCentrifuge && (centrifugeHandler = (ComponentFluidHandlerMulti)(centrifuge = (TileGasCentrifuge)tile).getComponent(IComponentType.FluidHandler)) != null && centrifuge.getFacing() == centrifugeDir) {
            ComponentFluidHandlerMulti boilerHandler = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
            PropertyFluidTank boilerTank = boilerHandler.getOutputTanks()[0];
            PropertyFluidTank centrifugeTank = centrifugeHandler.getInputTanks()[0];
            int accepted = centrifugeTank.fill(boilerTank.getFluid(), IFluidHandler.FluidAction.SIMULATE);
            centrifugeTank.fill(new FluidStack(boilerTank.getFluid().getFluid(), accepted), IFluidHandler.FluidAction.EXECUTE);
            boilerTank.drain(accepted, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected void tickClient(ComponentTickable tickable) {
        boolean running = ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0);
        if (running && this.f_58857_.f_46441_.nextDouble() < 0.15) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.nextDouble(), (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.nextDouble() * 0.4 + 0.5, (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.nextDouble(), 0.0, 0.0, 0.0);
        }
        if (this.shouldPlaySound() && !this.isSoundPlaying) {
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)NuclearScienceSounds.SOUND_NUCLEARBOILER.get()), (BlockEntity)this, (boolean)true);
            this.isSoundPlaying = true;
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(1.0);
    }
}

