/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import nuclearscience.api.quantumtunnel.FrequencyConnectionManager;
import nuclearscience.api.quantumtunnel.TunnelFrequency;
import nuclearscience.api.quantumtunnel.TunnelFrequencyBuffer;
import nuclearscience.api.quantumtunnel.TunnelFrequencyManager;
import nuclearscience.common.inventory.container.ContainerQuantumTunnel;
import nuclearscience.prefab.NuclearPropertyTypes;
import nuclearscience.registers.NuclearScienceTiles;
import org.jetbrains.annotations.NotNull;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;
import voltaic.registers.VoltaicCapabilities;

public class TileQuantumTunnel
extends GenericTile {
    public static final int DOWN_MASK = 15;
    public static final int UP_MASK = 240;
    public static final int NORTH_MASK = 3840;
    public static final int SOUTH_MASK = 61440;
    public static final int WEST_MASK = 983040;
    public static final int EAST_MASK = 0xF00000;
    public SingleProperty<TunnelFrequency> frequency = (SingleProperty)this.property((AbstractProperty)new SingleProperty(NuclearPropertyTypes.TUNNEL_FREQUENCY, "frequency", (Object)TunnelFrequency.NO_FREQUENCY));
    public SingleProperty<Integer> inputDirections = ((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "inputdirections", (Object)0))).onChange((prop, val) -> {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
        } else {
            this.refreshCapabilities();
        }
    });
    public SingleProperty<Integer> outputDirections = ((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "outputdirections", (Object)0))).onChange((prop, val) -> {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
        } else {
            this.refreshCapabilities();
        }
    });
    private CachedTileOutput[] outputCache = new CachedTileOutput[6];
    private ItemHandler[] itemHandlers = new ItemHandler[6];
    private FluidHandler[] fluidHandlers = new FluidHandler[6];
    private ElectrodynamicHandler[] electrodynamicHandlers = new ElectrodynamicHandler[6];
    private FEHandler[] feHandlers = new FEHandler[6];
    public HashMap<UUID, HashSet<TunnelFrequency>> clientFrequencies = new HashMap();
    public TunnelFrequencyBuffer clientBuffer = TunnelFrequencyBuffer.EMPTY;

    public TileQuantumTunnel(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_QUANTUMCAPACITOR.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this));
        this.addComponent((IComponent)new ComponentContainerProvider("quantumcapacitor", (GenericTile)this).createMenu((id, player) -> new ContainerQuantumTunnel((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        Direction dir;
        if (!TunnelFrequencyManager.doesFrequencyExist((TunnelFrequency)this.frequency.getValue())) {
            this.frequency.setValue((Object)TunnelFrequency.NO_FREQUENCY);
        }
        if (((TunnelFrequency)this.frequency.getValue()).equals(TunnelFrequency.NO_FREQUENCY)) {
            return;
        }
        for (Direction direction : Direction.values()) {
            dir = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)direction);
            if (this.outputCache[dir.ordinal()] != null) continue;
            this.outputCache[dir.ordinal()] = new CachedTileOutput(this.f_58857_, new BlockPos((Vec3i)this.f_58858_).m_142300_(dir));
        }
        for (Direction direction : Direction.values()) {
            dir = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)direction);
            if (this.outputCache[dir.ordinal()].valid()) continue;
            this.outputCache[dir.ordinal()].update(new BlockPos((Vec3i)this.f_58858_).m_142300_(dir));
        }
        if (((TunnelFrequency)this.frequency.getValue()).equals(TunnelFrequency.NO_FREQUENCY)) {
            return;
        }
        for (Direction direction : this.readOutputDirections()) {
            int taken;
            TransferPack bufferedEnergy;
            IEnergyStorage feCap;
            TransferPack taken2;
            TransferPack bufferedEnergy2;
            ICapabilityElectrodynamic electroCap;
            int taken3;
            FluidStack bufferedFluid;
            IFluidHandler fluidCap;
            Direction relative = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)direction);
            CachedTileOutput output = this.outputCache[relative.ordinal()];
            if (!output.valid()) continue;
            BlockEntity tile = (BlockEntity)output.getSafe();
            if (tile == null) {
                return;
            }
            IItemHandler itemCap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, relative.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER);
            if (itemCap != CapabilityUtils.EMPTY_ITEM_HANDLER) {
                ItemStack bufferedItem = FrequencyConnectionManager.getBufferedItem((TunnelFrequency)this.frequency.getValue()).m_41777_();
                ItemStack formerBufferedItem = bufferedItem.m_41777_();
                if (!bufferedItem.m_41619_()) {
                    int delta;
                    for (int i = 0; i < itemCap.getSlots(); ++i) {
                        bufferedItem.m_41764_(bufferedItem.m_41613_() - itemCap.insertItem(i, bufferedItem, false).m_41613_());
                        if (bufferedItem.m_41613_() <= 0) break;
                    }
                    if ((delta = formerBufferedItem.m_41613_() - bufferedItem.m_41613_()) > 0) {
                        formerBufferedItem.m_41764_(delta);
                        FrequencyConnectionManager.extractItem((TunnelFrequency)this.frequency.getValue(), formerBufferedItem, false);
                    }
                }
            }
            if ((fluidCap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, relative.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_FLUID)) != CapabilityUtils.EMPTY_FLUID && !(bufferedFluid = FrequencyConnectionManager.getBufferedFluid((TunnelFrequency)this.frequency.getValue()).copy()).isEmpty() && (taken3 = fluidCap.fill(bufferedFluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                bufferedFluid.setAmount(taken3);
                FrequencyConnectionManager.extractFluid((TunnelFrequency)this.frequency.getValue(), bufferedFluid, IFluidHandler.FluidAction.EXECUTE);
            }
            if ((electroCap = (ICapabilityElectrodynamic)tile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, relative.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO)) != CapabilityUtils.EMPTY_ELECTRO && electroCap.isEnergyReceiver() && (bufferedEnergy2 = FrequencyConnectionManager.getBufferedEnergy((TunnelFrequency)this.frequency.getValue())).getJoules() > 0.0 && (taken2 = electroCap.receivePower(bufferedEnergy2, false)).getJoules() > 0.0) {
                FrequencyConnectionManager.extractEnergy((TunnelFrequency)this.frequency.getValue(), taken2, false);
            }
            if ((feCap = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, relative.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_FE)) == CapabilityUtils.EMPTY_FE || !feCap.canReceive() || !((bufferedEnergy = FrequencyConnectionManager.getBufferedEnergy((TunnelFrequency)this.frequency.getValue())).getJoules() > 0.0) || bufferedEnergy.getVoltage() != 120.0 || (taken = feCap.receiveEnergy((int)bufferedEnergy.getJoules(), false)) <= 0) continue;
            FrequencyConnectionManager.extractEnergy((TunnelFrequency)this.frequency.getValue(), TransferPack.joulesVoltage((double)taken, (double)120.0), false);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (side == null || ((TunnelFrequency)this.frequency.getValue()).equals(TunnelFrequency.NO_FREQUENCY)) {
            return LazyOptional.empty();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            FEHandler storage = this.feHandlers[side.ordinal()];
            return storage == null ? LazyOptional.empty() : LazyOptional.of(() -> storage).cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            ItemHandler handler = this.itemHandlers[side.ordinal()];
            return handler == null ? LazyOptional.empty() : LazyOptional.of(() -> handler).cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            FluidHandler handler = this.fluidHandlers[side.ordinal()];
            return handler == null ? LazyOptional.empty() : LazyOptional.of(() -> handler).cast();
        }
        if (cap == VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK) {
            ElectrodynamicHandler electro = this.electrodynamicHandlers[side.ordinal()];
            return electro == null ? LazyOptional.empty() : LazyOptional.of(() -> electro).cast();
        }
        return LazyOptional.empty();
    }

    public void onLoad() {
        this.refreshCapabilities();
        super.onLoad();
    }

    private void refreshCapabilities() {
        int index;
        this.itemHandlers = new ItemHandler[6];
        this.fluidHandlers = new FluidHandler[6];
        this.electrodynamicHandlers = new ElectrodynamicHandler[6];
        this.feHandlers = new FEHandler[6];
        for (Direction dir : this.readInputDirections()) {
            index = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)dir).ordinal();
            this.itemHandlers[index] = new ItemHandler(true);
            this.fluidHandlers[index] = new FluidHandler(true);
            this.electrodynamicHandlers[index] = new ElectrodynamicHandler(true);
            this.feHandlers[index] = new FEHandler(true);
        }
        for (Direction dir : this.readOutputDirections()) {
            index = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)dir).ordinal();
            this.itemHandlers[index] = new ItemHandler(false);
            this.fluidHandlers[index] = new FluidHandler(false);
            this.electrodynamicHandlers[index] = new ElectrodynamicHandler(false);
            this.feHandlers[index] = new FEHandler(false);
        }
    }

    public List<Direction> readInputDirections() {
        return this.readDirections((Integer)this.inputDirections.getValue(), 1);
    }

    public List<Direction> readOutputDirections() {
        return this.readDirections((Integer)this.outputDirections.getValue(), 2);
    }

    public void writeInputDirection(Direction dir) {
        this.inputDirections.setValue((Object)this.writeDirection((Integer)this.inputDirections.getValue(), dir, 1));
    }

    public void writeOutputDirection(Direction dir) {
        this.outputDirections.setValue((Object)this.writeDirection((Integer)this.outputDirections.getValue(), dir, 2));
    }

    public void removeInputDirection(Direction dir) {
        this.inputDirections.setValue((Object)this.removeDirection((Integer)this.inputDirections.getValue(), dir));
    }

    public void removeOutputDirection(Direction dir) {
        this.outputDirections.setValue((Object)this.removeDirection((Integer)this.outputDirections.getValue(), dir));
    }

    private List<Direction> readDirections(int directions, int checkValue) {
        ArrayList<Direction> values = new ArrayList<Direction>();
        if ((directions & 0xF) >> Direction.DOWN.ordinal() * 4 == checkValue) {
            values.add(Direction.DOWN);
        }
        if ((directions & 0xF0) >> Direction.UP.ordinal() * 4 == checkValue) {
            values.add(Direction.UP);
        }
        if ((directions & 0xF00) >> Direction.NORTH.ordinal() * 4 == checkValue) {
            values.add(Direction.NORTH);
        }
        if ((directions & 0xF000) >> Direction.SOUTH.ordinal() * 4 == checkValue) {
            values.add(Direction.SOUTH);
        }
        if ((directions & 0xF0000) >> Direction.WEST.ordinal() * 4 == checkValue) {
            values.add(Direction.WEST);
        }
        if ((directions & 0xF00000) >> Direction.EAST.ordinal() * 4 == checkValue) {
            values.add(Direction.EAST);
        }
        return values;
    }

    private int writeDirection(int directions, Direction dir, int value) {
        return (switch (dir) {
            case Direction.DOWN -> directions & 0xFFFFFFF0;
            case Direction.UP -> directions & 0xFFFFFF0F;
            case Direction.NORTH -> directions & 0xFFFFF0FF;
            case Direction.SOUTH -> directions & 0xFFFF0FFF;
            case Direction.WEST -> directions & 0xFFF0FFFF;
            case Direction.EAST -> directions & 0xFF0FFFFF;
            default -> 0;
        }) | value << dir.ordinal() * 4;
    }

    private int removeDirection(int directions, Direction dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> directions & 0xFFFFFFF0;
            case Direction.UP -> directions & 0xFFFFFF0F;
            case Direction.NORTH -> directions & 0xFFFFF0FF;
            case Direction.SOUTH -> directions & 0xFFFF0FFF;
            case Direction.WEST -> directions & 0xFFF0FFFF;
            case Direction.EAST -> directions & 0xFF0FFFFF;
        };
    }

    private class ItemHandler
    implements IItemHandler {
        private final boolean isReciever;

        public ItemHandler(boolean isReciever) {
            this.isReciever = isReciever;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return FrequencyConnectionManager.getBufferedItem((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue());
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.isReciever ? FrequencyConnectionManager.recieveItem((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue(), stack, simulate) : ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack buffered = this.getStackInSlot(0);
            if (buffered.m_41619_()) {
                return ItemStack.f_41583_;
            }
            buffered.m_41764_(amount);
            return this.isReciever ? ItemStack.f_41583_ : FrequencyConnectionManager.extractItem((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue(), buffered, simulate);
        }

        public int getSlotLimit(int slot) {
            return 1000;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }
    }

    private class FluidHandler
    implements IFluidHandler {
        private final boolean isReciever;

        public FluidHandler(boolean isReciever) {
            this.isReciever = isReciever;
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return FrequencyConnectionManager.getBufferedFluid((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue());
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.isReciever ? FrequencyConnectionManager.recieveFluid((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue(), resource, action).getAmount() : 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.isReciever ? FluidStack.EMPTY : FrequencyConnectionManager.extractFluid((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue(), resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack buffered = FrequencyConnectionManager.getBufferedFluid((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue());
            if (buffered.isEmpty()) {
                return FluidStack.EMPTY;
            }
            return this.drain(new FluidStack(buffered.getFluid(), maxDrain), action);
        }
    }

    private class ElectrodynamicHandler
    implements ICapabilityElectrodynamic {
        private final boolean isReciever;

        public ElectrodynamicHandler(boolean isReciever) {
            this.isReciever = isReciever;
        }

        public double getJoulesStored() {
            return FrequencyConnectionManager.getBufferedEnergy((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue()).getJoules();
        }

        public double getMaxJoulesStored() {
            return Double.MAX_VALUE;
        }

        public void setJoulesStored(double v) {
        }

        public double getVoltage() {
            return -1.0;
        }

        public double getMinimumVoltage() {
            return -1.0;
        }

        public double getMaximumVoltage() {
            return Double.MAX_VALUE;
        }

        public double getAmpacity() {
            return -1.0;
        }

        public boolean isEnergyReceiver() {
            return this.isReciever;
        }

        public boolean isEnergyProducer() {
            return !this.isReciever;
        }

        public TransferPack extractPower(TransferPack transfer, boolean debug) {
            return FrequencyConnectionManager.extractEnergy((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue(), transfer, debug);
        }

        public TransferPack receivePower(TransferPack transfer, boolean debug) {
            return FrequencyConnectionManager.recieveEnergy((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue(), transfer, debug);
        }

        public void overVoltage(TransferPack transfer) {
        }

        public void onChange() {
        }

        public TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile loadProfile, Direction direction) {
            return this.isReciever ? TransferPack.joulesVoltage((double)(Double.MAX_VALUE - FrequencyConnectionManager.getBufferedEnergy((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue()).getJoules()), (double)-1.0) : TransferPack.EMPTY;
        }
    }

    private class FEHandler
    implements IEnergyStorage {
        private final boolean isReciever;

        public FEHandler(boolean isReciever) {
            this.isReciever = isReciever;
        }

        public int receiveEnergy(int toReceive, boolean simulate) {
            return this.isReciever ? (int)FrequencyConnectionManager.recieveEnergy((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue(), TransferPack.joulesVoltage((double)toReceive, (double)120.0), simulate).getJoules() : 0;
        }

        public int extractEnergy(int toExtract, boolean simulate) {
            return this.isReciever ? 0 : (int)FrequencyConnectionManager.recieveEnergy((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue(), TransferPack.joulesVoltage((double)toExtract, (double)120.0), simulate).getJoules();
        }

        public int getEnergyStored() {
            return (int)FrequencyConnectionManager.getBufferedEnergy((TunnelFrequency)TileQuantumTunnel.this.frequency.getValue()).getJoules();
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return !this.isReciever;
        }

        public boolean canReceive() {
            return this.isReciever;
        }
    }
}

