/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.inventory.container.ContainerRadioactiveProcessor;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceRecipies;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileRadioactiveProcessor
extends GenericTile {
    public static final int MAX_TANK_CAPACITY = 5000;

    public TileRadioactiveProcessor(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_RADIOACTIVEPROCESSOR.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(480.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}));
        this.addComponent((IComponent)new ComponentFluidHandlerMulti((GenericTile)this).setInputTanks(1, new int[]{5000}).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP}).setRecipeType((RecipeType)NuclearScienceRecipies.RADIOACTIVE_PROCESSOR_TYPE.get()));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(1, 1, 1, 0).bucketInputs(1).upgrades(3)).validUpgrades(ContainerRadioactiveProcessor.VALID_UPGRADES).valid(TileRadioactiveProcessor.machineValidator()).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT}).setDirectionsBySlot(Integer.valueOf(1), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess(this::shouldProcessRecipe).process(ComponentProcessor::processFluidItem2ItemRecipe));
        this.addComponent((IComponent)new ComponentContainerProvider("radioactiveprocessor", (GenericTile)this).createMenu((id, player) -> new ContainerRadioactiveProcessor((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private boolean shouldProcessRecipe(ComponentProcessor component, int procNumber) {
        component.consumeBucket();
        boolean canProcess = component.canProcessFluidItem2ItemRecipe(procNumber, (RecipeType)NuclearScienceRecipies.RADIOACTIVE_PROCESSOR_TYPE.get());
        if (BlockEntityUtils.isLit((GenericTile)this) ^ canProcess) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)canProcess);
        }
        if (((ComponentTickable)this.getComponent(IComponentType.Tickable)).getTicks() % 2L == 0L) {
            RadiationUtils.handleRadioactiveFluids((GenericTile)this, (ComponentFluidHandlerMulti)((ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler)), (int)NuclearConstants.RADIOACTIVE_PROCESSOR_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)false);
            RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)((ComponentInventory)this.getComponent(IComponentType.Inventory)), (int)NuclearConstants.RADIOACTIVE_PROCESSOR_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)false);
        }
        return canProcess;
    }

    public int getComparatorSignal() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) ? 15 : 0;
    }
}

