/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import nuclearscience.api.turbine.ISteamReceiver;
import nuclearscience.common.tags.NuclearScienceTags;
import nuclearscience.registers.NuclearScienceFluids;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.network.utils.FluidUtilities;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileSteamFunnel
extends GenericTile
implements ISteamReceiver {
    public static final int INTERNAL_CAPACITY = 10000;
    public static final int MAX_TEMPERATURE = 20000;
    public static final int MAX_PRESSURE = 10;

    public TileSteamFunnel(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_STEAMFUNNEL.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentFluidHandlerSimple(10000, (GenericTile)this, "storedsteam").setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP}).setValidFluidTags(new TagKey[]{NuclearScienceTags.Fluids.STEAM}));
    }

    private void tickServer(ComponentTickable tickable) {
        ComponentFluidHandlerSimple handler = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        if (handler.isEmpty()) {
            return;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        if (blockEntity instanceof ISteamReceiver) {
            ISteamReceiver receiver = (ISteamReceiver)blockEntity;
            handler.drain(receiver.receiveSteam(handler.getFluid().getTag().m_128451_("temperature"), handler.getFluidAmount()), IFluidHandler.FluidAction.EXECUTE);
        }
        FluidUtilities.outputToPipe((GenericTile)this, (FluidTank[])handler.asArray(), (Direction[])new Direction[]{Direction.UP});
    }

    private void tickClient(ComponentTickable tickable) {
        ComponentFluidHandlerSimple handler = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        BlockPos above = this.m_58899_().m_7494_();
        if (!handler.isEmpty() && this.f_58857_.m_7702_(above) instanceof ISteamReceiver && this.f_58857_.f_46441_.nextInt(3) == 0) {
            double offsetFX = (double)above.m_123341_() + this.f_58857_.f_46441_.nextDouble() / 2.0 * (double)(this.f_58857_.f_46441_.nextBoolean() ? -1 : 1);
            double offsetFY = (double)above.m_123342_() + this.f_58857_.f_46441_.nextDouble() / 2.0 * (double)(this.f_58857_.f_46441_.nextBoolean() ? -1 : 1);
            double offsetFZ = (double)above.m_123343_() + this.f_58857_.f_46441_.nextDouble() / 2.0 * (double)(this.f_58857_.f_46441_.nextBoolean() ? -1 : 1);
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int receiveSteam(int temperature, int amount) {
        if (this.f_58857_.m_5776_()) {
            return 0;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("temperature", temperature);
        return ((ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler)).fill(new FluidStack((Fluid)NuclearScienceFluids.FLUID_STEAM.get(), amount, tag), IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public boolean isStillValid() {
        return this.m_58901_();
    }

    public InteractionResult use(Player player, InteractionHand hand, BlockHitResult hit) {
        return InteractionResult.PASS;
    }
}

