/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.server.ServerLifecycleHooks;
import nuclearscience.common.inventory.container.ContainerTeleporter;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileTeleporter
extends GenericTile {
    private static final DimensionManager MANAGER = new DimensionManager();
    public final SingleProperty<BlockPos> destination = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "location", (Object)this.m_58899_()));
    public final SingleProperty<Integer> cooldown = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "cooldown", (Object)0));
    public final SingleProperty<ResourceLocation> dimension = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.RESOURCE_LOCATION, "dimension", (Object)Level.f_46428_.m_135782_()));

    public TileTeleporter(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_TELEPORTER.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).maxJoules(NuclearConstants.TELEPORTER_USAGE_PER_TELEPORT * 20.0).voltage(480.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1)));
        this.addComponent((IComponent)new ComponentContainerProvider("teleporter", (GenericTile)this).createMenu((id, player) -> new ContainerTeleporter((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        boolean powered;
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        boolean bl = powered = electro.getJoulesStored() > NuclearConstants.TELEPORTER_USAGE_PER_TELEPORT;
        if (BlockEntityUtils.isLit((GenericTile)this) ^ powered) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)powered);
        }
        if (((BlockPos)this.destination.getValue()).equals((Object)this.m_58899_()) || electro.getJoulesStored() < electro.getMaxJoulesStored()) {
            return;
        }
        if ((Integer)this.cooldown.getValue() > 0) {
            this.cooldown.setValue((Object)((Integer)this.cooldown.getValue() - 1));
            return;
        }
        AABB entityCheckArea = new AABB(this.m_58899_(), this.m_58899_().m_142082_(1, 2, 1));
        List players = this.m_58904_().m_142425_((EntityTypeTest)EntityType.f_20532_, entityCheckArea, en -> true);
        if (players.isEmpty()) {
            this.cooldown.setValue((Object)5);
            return;
        }
        ServerLevel destinationLevel = this.getDestinationLevel();
        Player player = (Player)players.get(0);
        player.changeDimension(destinationLevel, (ITeleporter)MANAGER);
        BlockPos destPos = (BlockPos)this.destination.getValue();
        player.m_20324_((double)destPos.m_123341_() + 0.5, (double)destPos.m_123342_() + 1.0, (double)destPos.m_123343_() + 0.5);
        this.cooldown.setValue((Object)80);
        electro.joules(electro.getJoulesStored() - NuclearConstants.TELEPORTER_USAGE_PER_TELEPORT);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(3.0);
    }

    private ServerLevel getDestinationLevel() {
        ServerLevel level = ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)((ResourceLocation)this.dimension.getValue())));
        if (level == null) {
            return (ServerLevel)this.m_58904_();
        }
        return level;
    }

    private static final class DimensionManager
    implements ITeleporter {
        private DimensionManager() {
        }

        public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            return repositionEntity.apply(false);
        }

        @Nullable
        public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
            return new PortalInfo(entity.m_20182_(), Vec3.f_82478_, entity.m_146908_(), entity.m_146909_());
        }

        public boolean isVanilla() {
            return false;
        }

        public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
            return false;
        }
    }
}

