/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import nuclearscience.common.inventory.container.ContainerSupplyModule;
import nuclearscience.common.network.ReactorLogisticsNetwork;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.common.tile.reactor.logisticsnetwork.TileReactorLogisticsCable;
import nuclearscience.common.tile.reactor.logisticsnetwork.interfaces.GenericTileInterface;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileInterfaceBound;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.RadiationUtils;

public class TileSupplyModule
extends GenericTileInterfaceBound {
    private Direction relativeBack;

    public TileSupplyModule(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)NuclearScienceTiles.TILE_SUPPLYMODULE.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(9).outputs(9)).setSlotsByDirection(BlockEntityUtils.MachineDirection.TOP, new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8}).setSlotsByDirection(BlockEntityUtils.MachineDirection.FRONT, new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8}).setSlotsByDirection(BlockEntityUtils.MachineDirection.BOTTOM, new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17}).setSlotsByDirection(BlockEntityUtils.MachineDirection.LEFT, new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17}).setSlotsByDirection(BlockEntityUtils.MachineDirection.RIGHT, new Integer[]{9, 10, 11, 12, 13, 14, 15, 16, 17}).valid(TileSupplyModule.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider("supplymodule", (GenericTile)this).createMenu((id, player) -> new ContainerSupplyModule((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        super.tickServer(tickable);
        if (((ComponentTickable)this.getComponent(IComponentType.Tickable)).getTicks() % 2L == 0L) {
            RadiationUtils.handleRadioactiveItems((GenericTile)this, (ComponentInventory)((ComponentInventory)this.getComponent(IComponentType.Inventory)), (int)NuclearConstants.RADIOACTIVE_PROCESSOR_RADIATION_RADIUS, (boolean)true, (int)1, (boolean)false);
        }
    }

    @Override
    public boolean checkLinkedPosition(GenericTileInterface inter) {
        return ((BlockPos)inter.supplyModuleLocation.getValue()).equals((Object)this.m_58899_());
    }

    @Override
    public GenericTileInterface.InterfaceType[] getValidInterfaces() {
        return SUPPLIES;
    }

    @Override
    public Direction getCableLocation() {
        return this.relativeBack;
    }

    public void onBlockStateUpdate(BlockState oldState, BlockState newState) {
        super.onBlockStateUpdate(oldState, newState);
        if (!this.f_58857_.m_5776_() && oldState.m_61138_((Property)VoltaicBlockStates.FACING) && newState.m_61138_((Property)VoltaicBlockStates.FACING) && oldState.m_61143_((Property)VoltaicBlockStates.FACING) != newState.m_61143_((Property)VoltaicBlockStates.FACING)) {
            this.relativeBack = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)BlockEntityUtils.MachineDirection.BACK.mappedDir);
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("relativeback", this.relativeBack.ordinal());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.relativeBack = Direction.values()[compound.m_128451_("relativeback")];
    }

    @Override
    public void onInterfacePropChange(SingleProperty<BlockPos> prop, BlockPos old) {
        GenericTileInterface inter;
        super.onInterfacePropChange(prop, old);
        boolean oldInval = old.equals((Object)BlockEntityUtils.OUT_OF_REACH);
        boolean newInval = ((BlockPos)prop.getValue()).equals((Object)BlockEntityUtils.OUT_OF_REACH);
        if (oldInval && newInval) {
            return;
        }
        if (this.networkCable == null || !this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
            return;
        }
        TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
        if (cable.m_58901_()) {
            return;
        }
        ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
        if (oldInval && !newInval) {
            GenericTileInterface inter2 = network.getInterface((BlockPos)prop.getValue());
            if (inter2 != null) {
                inter2.supplyModuleLocation.setValue((Object)this.m_58899_());
            }
        } else if (!oldInval && newInval && (inter = network.getInterface(old)) != null) {
            inter.supplyModuleLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        }
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (!this.f_58857_.m_5776_()) {
            if (this.networkCable == null || !this.networkCable.valid() || !(this.networkCable.getSafe() instanceof TileReactorLogisticsCable)) {
                return;
            }
            TileReactorLogisticsCable cable = (TileReactorLogisticsCable)((Object)this.networkCable.getSafe());
            if (cable.m_58901_()) {
                return;
            }
            ReactorLogisticsNetwork network = (ReactorLogisticsNetwork)cable.getNetwork();
            GenericTileInterface inter = network.getInterface((BlockPos)this.interfaceLocation.getValue());
            if (inter == null) {
                return;
            }
            inter.supplyModuleLocation.setValue((Object)BlockEntityUtils.OUT_OF_REACH);
        }
    }
}

