/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.logisticsnetwork.interfaces;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.block.subtype.SubtypeNuclearMachine;
import nuclearscience.common.tile.reactor.logisticsnetwork.util.GenericTileLogisticsMember;
import nuclearscience.registers.NuclearScienceItems;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SetProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;

public abstract class GenericTileInterface
extends GenericTileLogisticsMember {
    public CachedTileOutput reactor;
    public final SetProperty<Integer> queuedAnimations = (SetProperty)this.property((AbstractProperty)new SetProperty(PropertyTypes.INTEGER_SET, "queuedanimations", new HashSet()));
    public final SingleProperty<BlockPos> controlRodLocation = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "controlrodlocation", (Object)BlockEntityUtils.OUT_OF_REACH));
    public final SingleProperty<BlockPos> supplyModuleLocation = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BLOCK_POS, "supplymodulelocation", (Object)BlockEntityUtils.OUT_OF_REACH));
    public final HashMap<InterfaceAnimation, Long> clientAnimations = new HashMap();
    protected final HashMap<InterfaceAnimation, Long> serverAnimations = new HashMap();

    public GenericTileInterface(BlockEntityType<?> tileEntityTypeIn, BlockPos worldPos, BlockState blockState) {
        super(tileEntityTypeIn, worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
    }

    @Override
    public void tickServer(ComponentTickable tickable) {
        super.tickServer(tickable);
        this.queuedAnimations.wipeSet();
        if (this.reactor == null) {
            this.reactor = new CachedTileOutput(this.m_58904_(), this.m_58899_().m_142300_(this.getReactorDirection()));
        }
        if (tickable.getTicks() % 20L == 0L && !this.reactor.valid()) {
            this.reactor.update(this.m_58899_().m_142300_(this.getReactorDirection()));
        }
    }

    private void tickClient(ComponentTickable tickable) {
        if (this.reactor == null) {
            this.reactor = new CachedTileOutput(this.m_58904_(), this.m_58899_().m_142300_(this.getReactorDirection()));
        }
        if (tickable.getTicks() % 20L == 0L && !this.reactor.valid()) {
            this.reactor.update(this.m_58899_().m_142300_(this.getReactorDirection()));
        }
        long currTime = tickable.getTicks();
        ((HashSet)this.queuedAnimations.getValue()).forEach(val -> {
            InterfaceAnimation animation = InterfaceAnimation.values()[val];
            if (!this.clientAnimations.containsKey((Object)animation)) {
                this.clientAnimations.put(animation, currTime);
            }
        });
        Iterator<Map.Entry<InterfaceAnimation, Long>> it = this.clientAnimations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<InterfaceAnimation, Long> entry = it.next();
            if (currTime - entry.getValue() <= (long)entry.getKey().animationTime) continue;
            it.remove();
        }
    }

    public abstract Direction getReactorDirection();

    public abstract InterfaceType getInterfaceType();

    protected void handleServerAnimations(ComponentTickable tickable) {
        long currTime = tickable.getTicks();
        ((HashSet)this.queuedAnimations.getValue()).forEach(val -> {
            InterfaceAnimation animation = InterfaceAnimation.values()[val];
            if (!this.serverAnimations.containsKey((Object)animation)) {
                this.serverAnimations.put(animation, currTime);
            }
        });
        Iterator<Map.Entry<InterfaceAnimation, Long>> it = this.serverAnimations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<InterfaceAnimation, Long> entry = it.next();
            if (currTime - entry.getValue() <= (long)entry.getKey().animationTime) continue;
            it.remove();
        }
    }

    public static ItemStack getItemFromType(InterfaceType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case InterfaceType.NONE -> ItemStack.f_41583_;
            case InterfaceType.FISSION -> new ItemStack((ItemLike)NuclearScienceItems.ITEMS_NUCLEARMACHINE.getValue((Object)SubtypeNuclearMachine.fissionreactorcore));
            case InterfaceType.MS -> new ItemStack((ItemLike)NuclearScienceItems.ITEMS_NUCLEARMACHINE.getValue((Object)SubtypeNuclearMachine.msreactorcore));
            case InterfaceType.FUSION -> new ItemStack((ItemLike)NuclearScienceItems.ITEMS_NUCLEARMACHINE.getValue((Object)SubtypeNuclearMachine.fusionreactorcore));
        };
    }

    public static enum InterfaceAnimation {
        FISSION_WASTE_1(80),
        FISSION_WASTE_2(80),
        FISSION_WASTE_3(80),
        FISSION_WASTE_4(80),
        FISSION_TRITIUM_EXTRACT(80),
        FISSION_FUEL_1(80),
        FISSION_FUEL_2(80),
        FISSION_FUEL_3(80),
        FISSION_FUEL_4(80),
        FISSION_DEUTERIUM_INSERT(80),
        FUSION_DEUTERIUM_INSERT(80),
        FUSION_TRITIUM_INSERT(80);

        public final int animationTime;

        private InterfaceAnimation(int timeTicks) {
            this.animationTime = timeTicks;
        }
    }

    public static enum InterfaceType {
        NONE,
        FISSION,
        MS,
        FUSION;

    }
}

