/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.reactor.moltensalt;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import nuclearscience.common.inventory.container.ContainerFreezePlug;
import nuclearscience.common.settings.NuclearConstants;
import nuclearscience.registers.NuclearScienceItems;
import nuclearscience.registers.NuclearScienceTiles;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.TransferPack;

public class TileFreezePlug
extends GenericTile {
    public final SingleProperty<Boolean> isFrozen = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isfrozen", (Object)false));
    public final SingleProperty<Double> saltBonus = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "saltbonus", (Object)1.0));

    public TileFreezePlug(BlockPos pos, BlockState state) {
        super((BlockEntityType)NuclearScienceTiles.TILE_FREEZEPLUG.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(120.0).extractPower((x, y) -> TransferPack.EMPTY).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).maxJoules(NuclearConstants.FREEZEPLUG_USAGE_PER_TICK * 20.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1)).valid((slot, stack, i) -> stack.m_41720_() == NuclearScienceItems.ITEM_FLINAK.get()));
        this.addComponent((IComponent)new ComponentContainerProvider("freezeplug", (GenericTile)this).createMenu((id, player) -> new ContainerFreezePlug((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack stack = inv.m_8020_(0);
        if (stack.m_41619_()) {
            this.isFrozen.setValue((Object)false);
            this.saltBonus.setValue((Object)0.0);
            return;
        }
        if (electro.getJoulesStored() < NuclearConstants.FREEZEPLUG_USAGE_PER_TICK) {
            this.isFrozen.setValue((Object)false);
            this.saltBonus.setValue((Object)0.0);
            return;
        }
        electro.joules(electro.getJoulesStored() - NuclearConstants.FREEZEPLUG_USAGE_PER_TICK);
        this.isFrozen.setValue((Object)true);
        double bonus = 1.0 + (double)(stack.m_41613_() - 1) / 63.0;
        this.saltBonus.setValue((Object)bonus);
    }

    public boolean isFrozen() {
        return (Boolean)this.isFrozen.getValue();
    }

    public double getSaltBonus() {
        return (Double)this.saltBonus.getValue();
    }
}

