/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sauriosalvedos.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.sauriosalvedos.client.model.ModelAllosaurus;
import net.mcreator.sauriosalvedos.client.model.animations.AllosaurusAnimation;
import net.mcreator.sauriosalvedos.entity.AllosaurusEntity;
import net.mcreator.sauriosalvedos.procedures.SprintingAnimationProcedure;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AllosaurusRenderer
extends MobRenderer<AllosaurusEntity, ModelAllosaurus<AllosaurusEntity>> {
    public AllosaurusRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelAllosaurus.LAYER_LOCATION)), 0.8f);
    }

    protected void scale(AllosaurusEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(1.3f, 1.3f, 1.3f);
    }

    public ResourceLocation getTextureLocation(AllosaurusEntity entity) {
        return ResourceLocation.parse((String)"saurios_alvedos:textures/entities/allosaurus.png");
    }

    private static final class AnimatedModel
    extends ModelAllosaurus<AllosaurusEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<AllosaurusEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(AllosaurusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, AllosaurusAnimation.Idle, ageInTicks, 1.0f);
                this.animateWalk(AllosaurusAnimation.Walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                if (SprintingAnimationProcedure.execute((Entity)entity)) {
                    this.animateWalk(AllosaurusAnimation.Sprint, limbSwing, limbSwingAmount, 1.0f, 1.5f);
                }
                this.animate(entity.animationState3, AllosaurusAnimation.Attack, ageInTicks, 1.5f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(AllosaurusEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

