/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sauriosalvedos.entity;

import net.mcreator.sauriosalvedos.init.SauriosAlvedosModEntities;
import net.mcreator.sauriosalvedos.procedures.AttackAnimationProcedure;
import net.mcreator.sauriosalvedos.procedures.Baby_And_Adult_Size_ModelProcedure;
import net.mcreator.sauriosalvedos.procedures.IdleAnimationProcedure;
import net.mcreator.sauriosalvedos.procedures.IsSittingConditionProcedure;
import net.mcreator.sauriosalvedos.procedures.MovementOnEntityTickUpdateProcedure;
import net.mcreator.sauriosalvedos.procedures.SuchomimusIsSittingPlaybackConditionProcedure;
import net.mcreator.sauriosalvedos.procedures.SuchomimusNaturalEntitySpawningConditionProcedure;
import net.mcreator.sauriosalvedos.procedures.SuchomimusRightClickedOnEntityProcedure;
import net.mcreator.sauriosalvedos.procedures.SwimmingPlaybackConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class SuchomimusEntity
extends Animal {
    public static final EntityDataAccessor<Boolean> DATA_Is_Idle = SynchedEntityData.defineId(SuchomimusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_Is_Sitting = SynchedEntityData.defineId(SuchomimusEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();

    public SuchomimusEntity(EntityType<SuchomimusEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new MoveControl((Mob)this){

            public void tick() {
                if (SuchomimusEntity.this.isInWater()) {
                    SuchomimusEntity.this.setDeltaMovement(SuchomimusEntity.this.getDeltaMovement().add(0.0, 0.005, 0.0));
                }
                if (this.operation == MoveControl.Operation.MOVE_TO && !SuchomimusEntity.this.getNavigation().isDone()) {
                    double dx = this.wantedX - SuchomimusEntity.this.getX();
                    double dy = this.wantedY - SuchomimusEntity.this.getY();
                    double dz = this.wantedZ - SuchomimusEntity.this.getZ();
                    float f = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.speedModifier * SuchomimusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                    SuchomimusEntity.this.setYRot(this.rotlerp(SuchomimusEntity.this.getYRot(), f, 10.0f));
                    SuchomimusEntity.this.yBodyRot = SuchomimusEntity.this.getYRot();
                    SuchomimusEntity.this.yHeadRot = SuchomimusEntity.this.getYRot();
                    if (SuchomimusEntity.this.isInWater()) {
                        SuchomimusEntity.this.setSpeed((float)SuchomimusEntity.this.getAttribute(Attributes.MOVEMENT_SPEED).getValue());
                        float f2 = -((float)(Mth.atan2((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.clamp((float)Mth.wrapDegrees((float)f2), (float)-85.0f, (float)85.0f);
                        SuchomimusEntity.this.setXRot(this.rotlerp(SuchomimusEntity.this.getXRot(), f2, 5.0f));
                        float f3 = Mth.cos((float)(SuchomimusEntity.this.getXRot() * ((float)Math.PI / 180)));
                        SuchomimusEntity.this.setZza(f3 * f1);
                        SuchomimusEntity.this.setYya((float)((double)f1 * dy));
                    } else {
                        SuchomimusEntity.this.setSpeed(f1 * 0.05f);
                    }
                } else {
                    SuchomimusEntity.this.setSpeed(0.0f);
                    SuchomimusEntity.this.setYya(0.0f);
                    SuchomimusEntity.this.setZza(0.0f);
                }
            }
        };
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_Is_Idle, (Object)false);
        builder.define(DATA_Is_Sitting, (Object)false);
    }

    protected PathNavigation createNavigation(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.4){

            public boolean canUse() {
                double x = SuchomimusEntity.this.getX();
                double y = SuchomimusEntity.this.getY();
                double z = SuchomimusEntity.this.getZ();
                SuchomimusEntity entity = SuchomimusEntity.this;
                Level world = SuchomimusEntity.this.level();
                return super.canUse() && IsSittingConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, GlowSquid.class, true, true));
        this.targetSelector.addGoal(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Salmon.class, true, true));
        this.targetSelector.addGoal(9, (Goal)new NearestAttackableTargetGoal((Mob)this, Cod.class, true, true));
        this.targetSelector.addGoal(10, (Goal)new NearestAttackableTargetGoal((Mob)this, Squid.class, true, true));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DataIs_Idle", ((Boolean)this.entityData.get(DATA_Is_Idle)).booleanValue());
        compound.putBoolean("DataIs_Sitting", ((Boolean)this.entityData.get(DATA_Is_Sitting)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataIs_Idle")) {
            this.entityData.set(DATA_Is_Idle, (Object)compound.getBoolean("DataIs_Idle"));
        }
        if (compound.contains("DataIs_Sitting")) {
            this.entityData.set(DATA_Is_Sitting, (Object)compound.getBoolean("DataIs_Sitting"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult retval = InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        super.mobInteract(sourceentity, hand);
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        SuchomimusEntity entity = this;
        Level world = this.level();
        SuchomimusRightClickedOnEntityProcedure.execute((Entity)entity);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(IdleAnimationProcedure.execute(this.getX(), this.getY(), this.getZ(), (Entity)this), this.tickCount);
            this.animationState2.animateWhen(AttackAnimationProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(SuchomimusIsSittingPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(SwimmingPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        MovementOnEntityTickUpdateProcedure.execute(this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        SuchomimusEntity retval = (SuchomimusEntity)((EntityType)SauriosAlvedosModEntities.SUCHOMIMUS.get()).create((Level)serverWorld);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), MobSpawnType.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.COD), new ItemStack((ItemLike)Items.SALMON), new ItemStack((ItemLike)Items.INK_SAC), new ItemStack((ItemLike)Items.GLOW_INK_SAC)}).test(stack);
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        SuchomimusEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        SuchomimusEntity entity = this;
        return false;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        SuchomimusEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return super.getDefaultDimensions(pose).scale((float)Baby_And_Adult_Size_ModelProcedure.execute((Entity)entity));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)SauriosAlvedosModEntities.SUCHOMIMUS.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return SuchomimusNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 1.6);
        builder = builder.add(Attributes.MAX_HEALTH, 45.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 10.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(NeoForgeMod.SWIM_SPEED, 1.6);
        return builder;
    }
}

