/*
 * Decompiled with CFR 0.152.
 */
package org.sunny.sMusic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.SoundCategory;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class SMusic
extends JavaPlugin
implements CommandExecutor,
TabCompleter {
    private File musicFolder;
    private File generatedPack;
    private File hashFile;
    private Map<String, String> sanitizedToKey = new HashMap<String, String>();
    private Map<String, String> originalToSanitized = new HashMap<String, String>();
    private List<String> originalNames = new ArrayList<String>();

    public void onEnable() {
        Bukkit.getConsoleSender().sendMessage(new String[]{"\u00a7d     _____  ", "\u00a7d    / ____| ", "\u00a7d   | (___   ", "\u00a7d    \\___ \\  ", "\u00a7d    ____) | ", "\u00a7d   |_____/  ", "", "\u00a77 sMusic \u00a7a[Enabled \u2713]", "\u00a7f by \u00a7dx.com/SunnyAim_", ""});
        Objects.requireNonNull(this.getCommand("music")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("music")).setTabCompleter((TabCompleter)this);
        this.saveDefaultConfig();
        this.setupDefaultConfig();
        this.musicFolder = new File(this.getDataFolder(), "music");
        if (!this.musicFolder.exists()) {
            this.musicFolder.mkdirs();
        }
        String packName = this.sanitizeFileName(this.getConfig().getString("resource_pack_name", "sMusic Resource Pack"));
        this.generatedPack = new File(this.getDataFolder(), packName + ".zip");
        this.hashFile = new File(this.getDataFolder(), "last_generated.txt");
        try (InputStream logoStream = this.getResource("logo.png");){
            if (logoStream != null) {
                File logoFile = new File(this.getDataFolder(), "logo.png");
                if (!logoFile.exists()) {
                    Files.copy(logoStream, logoFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.getLogger().info("\u2705 logo.png copied from resources.");
                }
            } else {
                this.getLogger().warning("\u26a0\ufe0f logo.png not found in resources (src/main/resources/logo.png).");
            }
        }
        catch (IOException e) {
            this.getLogger().warning("\u26a0\ufe0f Error copying logo.png: " + e.getMessage());
        }
        this.generateResourcePack();
        this.loadSounds();
    }

    private void setupDefaultConfig() {
        this.getConfig().options().header("--------------------------\nsMusic Configuration\n--------------------------\n");
        this.getConfig().addDefault("pack_format", (Object)-1);
        this.getConfig().addDefault("resource_pack_name", (Object)"sMusic Resource Pack");
        this.getConfig().addDefault("resource_pack_description", (Object)"\u00a7dsMusic\u00a7f | \u00a77\u00a7lContains the sMusic Files");
        this.getConfig().addDefault("sound_category", (Object)"MASTER");
        this.getConfig().addDefault("messages.show_now_playing", (Object)true);
        this.getConfig().addDefault("messages.now_playing", (Object)"\n\n    &b\u266b &7Estas Escuchando: &d&l%song%&b \u266a\n\n");
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    public void onDisable() {
        Bukkit.getConsoleSender().sendMessage("\u00a77 sMusic \u00a7c[Disabled \u2717]");
    }

    private int getPackFormat() {
        int custom = this.getConfig().getInt("pack_format", -1);
        if (custom != -1) {
            return custom;
        }
        String version = Bukkit.getBukkitVersion();
        if (version.startsWith("1.19")) {
            return 15;
        }
        if (version.startsWith("1.20.2") || version.startsWith("1.20.3") || version.startsWith("1.20.4")) {
            return 26;
        }
        if (version.startsWith("1.21")) {
            return 32;
        }
        return 26;
    }

    private void generateResourcePack() {
        try {
            String previousHash;
            if (!this.musicFolder.exists()) {
                this.musicFolder.mkdirs();
            }
            String currentHash = this.computeFolderHash(this.musicFolder);
            String cfgRelevant = this.getConfig().getString("resource_pack_name", "") + "|" + this.getConfig().getString("resource_pack_description", "") + "|" + this.getConfig().getInt("pack_format", -1) + "|" + this.getConfig().getString("sound_category", "");
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(currentHash.getBytes(StandardCharsets.UTF_8));
            md.update(cfgRelevant.getBytes(StandardCharsets.UTF_8));
            String combinedHash = Base64.getEncoder().encodeToString(md.digest());
            if (this.hashFile.exists() && (previousHash = Files.readString(this.hashFile.toPath())).equals(combinedHash) && this.generatedPack.exists()) {
                this.getLogger().info("\ud83d\udd01 No changes detected (files/config), keeping existing pack.");
                return;
            }
            File tempDir = new File(this.getDataFolder(), "pack_temp");
            if (tempDir.exists()) {
                this.deleteDirectory(tempDir);
            }
            new File(tempDir, "assets/minecraft/sounds").mkdirs();
            File[] files = this.musicFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".ogg"));
            if (files == null || files.length == 0) {
                this.getLogger().warning("\u26a0\ufe0f No .ogg files found in /music. Please convert MP3 to OGG manually using tools like FreeConvert.com or Audacity.");
                return;
            }
            this.sanitizedToKey.clear();
            this.originalToSanitized.clear();
            this.originalNames.clear();
            StringBuilder json = new StringBuilder("{\n");
            int i = 0;
            HashMap<String, Integer> nameCounts = new HashMap<String, Integer>();
            Arrays.sort(files, Comparator.comparing(File::getName));
            for (File ogg : files) {
                String original = ogg.getName().replaceAll("(?i)\\.ogg$", "");
                String lowerOriginal = original.toLowerCase();
                Object sanitized = this.sanitizeSoundKey(original);
                if (nameCounts.containsKey(sanitized)) {
                    int c = (Integer)nameCounts.get(sanitized) + 1;
                    nameCounts.put((String)sanitized, c);
                    sanitized = (String)sanitized + "_" + c;
                } else {
                    nameCounts.put((String)sanitized, 1);
                }
                String key = "custom." + (String)sanitized;
                this.sanitizedToKey.put((String)sanitized, key);
                this.originalToSanitized.put(lowerOriginal, (String)sanitized);
                this.originalNames.add(original);
                File target = new File(tempDir, "assets/minecraft/sounds/" + (String)sanitized + ".ogg");
                Files.copy(ogg.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                json.append("  \"").append(key).append("\": { \"sounds\": [\"").append((String)sanitized).append("\"] }");
                if (i < files.length - 1) {
                    json.append(",");
                }
                json.append("\n");
                ++i;
            }
            json.append("}");
            Files.write(new File(tempDir, "assets/minecraft/sounds.json").toPath(), json.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            int packFormat = this.getPackFormat();
            String description = this.getConfig().getString("resource_pack_description", "\u00a7dsMusic\u00a7f | \u00a77\u00a7lContains the sMusic Files");
            String mcmetaText = "{\n  \"pack\": {\n    \"pack_format\": " + packFormat + ",\n    \"description\": " + this.toJsonString(description) + "\n  }\n}";
            Files.write(new File(tempDir, "pack.mcmeta").toPath(), mcmetaText.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            File logo = new File(this.getDataFolder(), "logo.png");
            if (logo.exists()) {
                Files.copy(logo.toPath(), new File(tempDir, "pack.png").toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.getLogger().info("\ud83d\uddbc\ufe0f Custom logo added to resource pack.");
            } else {
                this.getLogger().warning("\u26a0\ufe0f logo.png not found, skipping pack.png.");
            }
            this.zipFolder(tempDir, this.generatedPack);
            this.deleteDirectory(tempDir);
            Files.writeString(this.hashFile.toPath(), (CharSequence)combinedHash, new OpenOption[0]);
            this.getLogger().info("\u2705 Resource pack generated/updated with " + files.length + " song(s).");
            this.getLogger().info("\u2139\ufe0f To use custom sounds in /playsound, players must have the resource pack. Host '" + this.generatedPack.getName() + "' and set it in server.properties or use /minecraft:resourcepack.");
            this.getLogger().info("\u2139\ufe0f Convert MP3 to OGG using tools like https://www.freeconvert.com/mp3-to-ogg or Audacity before uploading to the music folder.");
        }
        catch (Exception e) {
            this.getLogger().severe("Error generating resource pack: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String toJsonString(String s) {
        return "\"" + s.replace("\"", "\\\"") + "\"";
    }

    private String computeFolderHash(File folder) throws Exception {
        File[] arr;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        ArrayList<File> files = new ArrayList<File>();
        if (folder.exists() && folder.isDirectory() && (arr = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".ogg"))) != null) {
            files.addAll(Arrays.asList(arr));
        }
        files.sort(Comparator.comparing(File::getName));
        for (File f : files) {
            digest.update(f.getName().getBytes(StandardCharsets.UTF_8));
            digest.update(Long.toString(f.length()).getBytes(StandardCharsets.UTF_8));
            digest.update(Long.toString(f.lastModified()).getBytes(StandardCharsets.UTF_8));
        }
        return Base64.getEncoder().encodeToString(digest.digest());
    }

    private void loadSounds() {
        this.sanitizedToKey.clear();
        this.originalToSanitized.clear();
        this.originalNames.clear();
        File[] files = this.musicFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".ogg"));
        if (files != null) {
            HashMap<String, Integer> nameCounts = new HashMap<String, Integer>();
            Arrays.sort(files, Comparator.comparing(File::getName));
            for (File file : files) {
                String original = file.getName().replaceAll("(?i)\\.ogg$", "");
                String lowerOriginal = original.toLowerCase();
                Object sanitized = this.sanitizeSoundKey(original);
                if (nameCounts.containsKey(sanitized)) {
                    int c = (Integer)nameCounts.get(sanitized) + 1;
                    nameCounts.put((String)sanitized, c);
                    sanitized = (String)sanitized + "_" + c;
                } else {
                    nameCounts.put((String)sanitized, 1);
                }
                String key = "custom." + (String)sanitized;
                this.sanitizedToKey.put((String)sanitized, key);
                this.originalToSanitized.put(lowerOriginal, (String)sanitized);
                this.originalNames.add(original);
            }
        }
    }

    private void zipFolder(File sourceFolder, File zipFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            zos.setLevel(1);
            Path sourcePath = sourceFolder.toPath();
            Files.walk(sourcePath, new FileVisitOption[0]).forEach(path -> {
                try {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        return;
                    }
                    String entryName = sourcePath.relativize((Path)path).toString().replace("\\", "/");
                    zos.putNextEntry(new ZipEntry(entryName));
                    Files.copy(path, zos);
                    zos.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    private void deleteDirectory(File dir) throws IOException {
        if (dir.isDirectory()) {
            for (File file : Objects.requireNonNull(dir.listFiles())) {
                this.deleteDirectory(file);
            }
        }
        Files.deleteIfExists(dir.toPath());
    }

    /*
     * WARNING - void declaration
     */
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a7eUsage: \u00a7f/music <reload|play|stop|list>");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("smusic.admin")) {
                    sender.sendMessage("\u00a7cYou do not have permission.");
                    return true;
                }
                this.reloadConfig();
                this.setupDefaultConfig();
                this.generateResourcePack();
                this.loadSounds();
                sender.sendMessage("\u00a7aConfiguration and resource pack reloaded successfully.");
                break;
            }
            case "play": {
                void var9_15;
                Collection<? extends Player> targets;
                String lowerNameArg;
                String string;
                if (args.length < 2) {
                    sender.sendMessage("\u00a7eUsage: \u00a7f/music play <name> [player/@a/@p]");
                    return true;
                }
                String nameArg = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length > 2 ? args.length - 1 : args.length));
                if (args.length > 2 && (args[args.length - 1].equalsIgnoreCase("@a") || args[args.length - 1].equalsIgnoreCase("@p") || Bukkit.getPlayerExact((String)args[args.length - 1]) != null)) {
                    nameArg = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length - 1));
                }
                if (!this.sanitizedToKey.containsKey(string = this.originalToSanitized.getOrDefault(lowerNameArg = nameArg.toLowerCase(), this.sanitizeSoundKey(nameArg)))) {
                    String finalNameArg = nameArg;
                    Optional<String> match = this.originalNames.stream().filter(o -> o.equalsIgnoreCase(finalNameArg)).findFirst();
                    if (match.isPresent()) {
                        lowerNameArg = match.get().toLowerCase();
                        String string2 = this.originalToSanitized.get(lowerNameArg);
                    } else {
                        sender.sendMessage("\u00a7cSong not found: " + nameArg);
                        sender.sendMessage("\u00a77Available songs: \u00a7f" + String.join((CharSequence)", ", this.originalNames));
                        return true;
                    }
                }
                if ((targets = this.getTargetPlayers(sender, args, args.length - 1)).isEmpty()) {
                    return true;
                }
                SoundCategory category = SoundCategory.valueOf((String)this.getConfig().getString("sound_category", "MASTER").toUpperCase());
                String key = this.sanitizedToKey.get(var9_15);
                String finalLowerNameArg = lowerNameArg;
                String displayName = this.originalNames.stream().filter(o -> o.toLowerCase().equals(finalLowerNameArg)).findFirst().orElse(nameArg);
                for (Player player : targets) {
                    try {
                        player.playSound((Entity)player, key, category, 1.0f, 1.0f);
                        boolean showMsg = this.getConfig().getBoolean("messages.show_now_playing", true);
                        if (!showMsg) continue;
                        String baseMsg = this.getConfig().getString("messages.now_playing", "\n\n    &b\u266b &7Estas Escuchando: &d&l%song%&b \u266a\n\n").replace("%song%", displayName).replace("%SONG%", displayName.toUpperCase()).replace("&", "\u00a7").replaceAll("^\\n+|\\n+$", "");
                        player.sendMessage("");
                        player.sendMessage(baseMsg);
                        player.sendMessage("");
                    }
                    catch (Exception e) {
                        sender.sendMessage("\u00a7cError playing song: " + e.getMessage());
                        this.getLogger().warning("Error playing sound '" + key + "' for player " + player.getName() + ": " + e.getMessage());
                    }
                }
                sender.sendMessage("\u00a7aPlaying \u00a7f" + displayName + " \u00a7afor " + targets.size() + " player(s).");
                sender.sendMessage("\u00a77Vanilla command: /playsound " + key + " " + category.name().toLowerCase() + " @p");
                break;
            }
            case "stop": {
                Collection<? extends Player> targets = this.getTargetPlayers(sender, args, 1);
                if (targets.isEmpty()) {
                    return true;
                }
                for (Player player : targets) {
                    player.stopAllSounds();
                }
                sender.sendMessage("\u00a7aMusic stopped for " + targets.size() + " player(s).");
                break;
            }
            case "list": {
                if (this.originalNames.isEmpty()) {
                    sender.sendMessage("\u00a7cNo songs available.");
                    return true;
                }
                sender.sendMessage("\u00a77Available songs:");
                for (String orig : this.originalNames) {
                    String string = orig.toLowerCase();
                    String sanitized = this.originalToSanitized.get(string);
                    String key = this.sanitizedToKey.get(sanitized);
                    sender.sendMessage("\u00a7f- " + orig + " \u00a77(/playsound " + key + ")");
                }
                break;
            }
            default: {
                sender.sendMessage("\u00a7eUsage: \u00a7f/music <reload|play|stop|list>");
            }
        }
        return true;
    }

    private Collection<? extends Player> getTargetPlayers(CommandSender sender, String[] args, int index) {
        if (args.length > index) {
            String targetArg = args[index];
            if (targetArg.equalsIgnoreCase("@a")) {
                return Bukkit.getOnlinePlayers();
            }
            if (targetArg.equalsIgnoreCase("@p") && sender instanceof Player) {
                return List.of((Player)sender);
            }
            Player p = Bukkit.getPlayerExact((String)targetArg);
            if (p != null) {
                return List.of(p);
            }
            sender.sendMessage("\u00a7cPlayer not found: " + targetArg);
            return Collections.emptyList();
        }
        if (sender instanceof Player) {
            return List.of((Player)sender);
        }
        sender.sendMessage("\u00a7cYou must specify a player from console.");
        return Collections.emptyList();
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("reload", "play", "stop", "list");
        }
        if (args.length >= 2 && args[0].equalsIgnoreCase("play")) {
            if (args.length > 2) {
                ArrayList<String> list = new ArrayList<String>();
                Bukkit.getOnlinePlayers().forEach(p -> list.add(p.getName()));
                list.add("@a");
                list.add("@p");
                return list;
            }
            return this.originalNames;
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("stop") || args[0].equalsIgnoreCase("list"))) {
            if (args[0].equalsIgnoreCase("list")) {
                return Collections.emptyList();
            }
            ArrayList<String> list = new ArrayList<String>();
            Bukkit.getOnlinePlayers().forEach(p -> list.add(p.getName()));
            list.add("@a");
            list.add("@p");
            return list;
        }
        return Collections.emptyList();
    }

    private String sanitizeFileName(String s) {
        return s.replaceAll("[\\\\/:*?\"<>|]", "_").trim();
    }

    private String sanitizeSoundKey(String s) {
        String clean = s.toLowerCase().replaceAll("[^a-z0-9_.\\-]", "_");
        if ((clean = clean.replaceAll("_+", "_")).startsWith("_")) {
            clean = clean.substring(1);
        }
        if (clean.endsWith("_")) {
            clean = clean.substring(0, clean.length() - 1);
        }
        if (clean.isEmpty()) {
            clean = "song";
        }
        return clean;
    }
}

