/*
 * Decompiled with CFR 0.152.
 */
package fyi.ramen.passivearmour;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_10191;
import net.minecraft.class_10192;
import net.minecraft.class_10394;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassiveArmour
implements ModInitializer {
    public static final String MOD_ID = "passivearmour";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"passivearmour");
    private static final String EQUIPPABLE_ASSET_ID = "EQUIPPABLE_ASSET_ID";
    private static final String CMD_RESTORE_ARMOUR = "restore_armour";
    private static final String CMD_HIDE_ARMOUR = "hide_armour";
    private static final String INVISIBLE_LORE_TEXT = "Invisible";
    private static final String ASSET_AIR = "air";
    private static final String ASSET_NETHERITE = "netherite";
    private static final String ERROR_NOT_PLAYER = "You must be a player to use this command";
    private static final String ERROR_NO_ITEM = "You must be holding an item";
    private static final String ERROR_NOT_EQUIPPABLE = "This item is not equippable";
    private static final String ERROR_NO_ASSET_ID = "This item does not have an asset id";
    private static final String MSG_VISIBLE = "Equipment now visible";
    private static final String MSG_INVISIBLE = "Equipment now invisible";

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> PassiveArmour.registerCommands((CommandDispatcher<class_2168>)dispatcher));
    }

    private static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)CMD_RESTORE_ARMOUR).executes(PassiveArmour::RestoreArmour));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)CMD_HIDE_ARMOUR).executes(PassiveArmour::HideArmour));
    }

    private static Optional<ValidationResult> validateArmourContext(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            PassiveArmour.sendError(context, ERROR_NOT_PLAYER);
            return Optional.empty();
        }
        class_1799 itemStack = player.method_6047();
        if (itemStack.method_7960()) {
            PassiveArmour.sendError(context, ERROR_NO_ITEM);
            return Optional.empty();
        }
        class_10192 equippable = (class_10192)itemStack.method_58695(class_9334.field_54196, null);
        if (equippable == null) {
            PassiveArmour.sendError(context, ERROR_NOT_EQUIPPABLE);
            return Optional.empty();
        }
        if (equippable.comp_3176().isEmpty()) {
            PassiveArmour.sendError(context, ERROR_NO_ASSET_ID);
            return Optional.empty();
        }
        class_9279 customData = (class_9279)itemStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 nbt = customData.method_57461();
        return Optional.of(new ValidationResult(itemStack, player, equippable, (class_5321<class_10394>)((class_5321)equippable.comp_3176().get()), nbt));
    }

    private static void sendError(CommandContext<class_2168> context, String message) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)message));
    }

    private static void sendSuccess(CommandContext<class_2168> context, String message) {
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)message));
    }

    private static List<class_5321<?>> getNetheriteItemKeys() {
        return List.of(PassiveArmour.registerVanillaItem("netherite_helmet"), PassiveArmour.registerVanillaItem("netherite_chestplate"), PassiveArmour.registerVanillaItem("netherite_leggings"), PassiveArmour.registerVanillaItem("netherite_boots"));
    }

    private static boolean isNetheriteItem(class_1799 itemStack) {
        Optional itemStackId = itemStack.method_41409().method_40230();
        return itemStackId.isPresent() && PassiveArmour.getNetheriteItemKeys().contains(itemStackId.get());
    }

    private static int RestoreArmour(CommandContext<class_2168> context) {
        Optional<ValidationResult> validationResult = PassiveArmour.validateArmourContext(context);
        if (validationResult.isEmpty()) {
            return 0;
        }
        ValidationResult result = validationResult.get();
        class_1799 itemStack = result.itemStack;
        class_10192 equippable = result.component;
        class_2487 nbtCompound = result.nbtCompound;
        Optional val = nbtCompound.method_67491(EQUIPPABLE_ASSET_ID, class_5321.method_39154((class_5321)class_10191.field_55214));
        if (val.isEmpty()) {
            PassiveArmour.sendError(context, ERROR_NO_ASSET_ID);
            return 0;
        }
        class_5321<class_10394> assetId = (class_5321<class_10394>)val.get();
        if (PassiveArmour.isNetheriteItem(itemStack)) {
            assetId = PassiveArmour.registerVanilla(ASSET_NETHERITE);
        }
        itemStack.method_57379(class_9334.field_54196, (Object)PassiveArmour.withAssetId(equippable, assetId));
        nbtCompound.method_10551(EQUIPPABLE_ASSET_ID);
        itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbtCompound));
        itemStack.method_57368(class_9334.field_49632, (Object)class_9290.field_49340, loreComponent -> {
            ArrayList<class_2561> loreList = new ArrayList<class_2561>(loreComponent.comp_2400());
            loreList.removeIf(text -> text.getString().equals(INVISIBLE_LORE_TEXT));
            return new class_9290(loreList);
        });
        PassiveArmour.sendSuccess(context, MSG_VISIBLE);
        return 1;
    }

    private static int HideArmour(CommandContext<class_2168> context) {
        return PassiveArmour.setArmour(context, PassiveArmour.registerVanilla(ASSET_AIR));
    }

    private static int SetArmourCmdArgument(CommandContext<class_2168> context) {
        String assetIdStr = (String)context.getArgument("assetId", String.class);
        class_5321<class_10394> assetIdArg = PassiveArmour.registerVanilla(assetIdStr);
        return PassiveArmour.setArmour(context, assetIdArg);
    }

    private static int setArmour(CommandContext<class_2168> context, class_5321<class_10394> assetIdArg) {
        PassiveArmour.sendSuccess(context, "Asset ID: " + String.valueOf(assetIdArg));
        Optional<ValidationResult> validationResult = PassiveArmour.validateArmourContext(context);
        if (validationResult.isEmpty()) {
            return 0;
        }
        ValidationResult result = validationResult.get();
        class_1799 itemStack = result.itemStack;
        class_10192 equippable = result.component;
        class_2487 nbtCompound = result.nbtCompound;
        Optional val = nbtCompound.method_67491(EQUIPPABLE_ASSET_ID, class_5321.method_39154((class_5321)class_10191.field_55214));
        if (val.isEmpty()) {
            nbtCompound.method_67494(EQUIPPABLE_ASSET_ID, class_5321.method_39154((class_5321)class_10191.field_55214), result.assetId);
        }
        itemStack.method_57379(class_9334.field_54196, (Object)PassiveArmour.withAssetId(equippable, assetIdArg));
        itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbtCompound));
        itemStack.method_57368(class_9334.field_49632, (Object)class_9290.field_49340, loreComponent -> {
            ArrayList<Object> loreList = new ArrayList<Object>(loreComponent.comp_2400());
            loreList.removeIf(text -> text.getString().equals(INVISIBLE_LORE_TEXT));
            loreList.add(class_2561.method_43470((String)INVISIBLE_LORE_TEXT));
            return new class_9290(loreList);
        });
        PassiveArmour.sendSuccess(context, MSG_INVISIBLE);
        return 1;
    }

    private static class_5321<class_10394> registerVanilla(String name) {
        return class_5321.method_29179((class_5321)class_10191.field_55214, (class_2960)class_2960.method_60656((String)name));
    }

    private static class_5321<class_10394> registerVanillaItem(String name) {
        return class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)class_2960.method_60656((String)"item")), (class_2960)class_2960.method_60656((String)name));
    }

    private static class_10192 withAssetId(class_10192 component, class_5321<class_10394> assetId) {
        class_10192.class_10217 builder = class_10192.method_64202((class_1304)component.comp_3174());
        builder.method_64204(assetId);
        builder.method_64210(component.comp_3214());
        builder.method_64207(component.comp_3178());
        builder.method_66701(component.comp_3523());
        builder.method_64209(component.comp_3213());
        builder.method_64205(component.comp_3175());
        builder.method_71772(component.comp_4362());
        builder.method_71771(component.comp_4363());
        if (component.comp_3177().isPresent()) {
            builder.method_64206((class_6885)component.comp_3177().get());
        }
        if (component.comp_3306().isPresent()) {
            builder.method_65009((class_2960)component.comp_3306().get());
        }
        return builder.method_64203();
    }

    private record ValidationResult(class_1799 itemStack, class_3222 player, class_10192 component, class_5321<class_10394> assetId, class_2487 nbtCompound) {
    }
}

