/*
 * Decompiled with CFR 0.152.
 */
package dev.enjarai.blahajtotem.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.enjarai.blahajtotem.BlahajTotem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10443;
import net.minecraft.class_10444;
import net.minecraft.class_10526;
import net.minecraft.class_11566;
import net.minecraft.class_1799;
import net.minecraft.class_638;
import net.minecraft.class_811;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public final class BlahajItemModel
implements class_10439 {
    private final List<Variant> variants;
    private final class_10439 fallback;
    private final LinkedList<Pair<String, Variant>> index;

    public BlahajItemModel(List<Variant> variants, class_10439 fallback) {
        this.variants = variants;
        this.fallback = fallback;
        this.index = new LinkedList(variants.stream().flatMap(type -> type.keywords().stream().map(alt -> Pair.of((Object)alt, (Object)type))).toList());
    }

    public void method_65584(class_10444 state, class_1799 stack, class_10442 resolver, class_811 displayContext, @Nullable class_638 world, @Nullable class_11566 heldItemContext, int seed) {
        if (stack.method_57826(class_9334.field_49631)) {
            HashSet<String> name = new HashSet<String>(Arrays.asList(stack.method_7964().getString().toLowerCase(Locale.ROOT).split("[ \\-_]")));
            Pair type = null;
            for (Pair pair : this.index) {
                String vName = (String)pair.getFirst();
                List<String> vSplit = Arrays.asList(vName.split("[ \\-_]"));
                if (!name.containsAll(vSplit) || type != null && (vName.length() <= ((String)type.getFirst()).length() || ((Variant)pair.getSecond()).lesser()) && !((Variant)type.getSecond()).lesser()) continue;
                type = pair;
            }
            if (type != null) {
                if (this.isLarge(name)) {
                    ((Variant)type.getSecond()).large().method_65584(state, stack, resolver, displayContext, world, heldItemContext, seed);
                } else {
                    ((Variant)type.getSecond()).normal().method_65584(state, stack, resolver, displayContext, world, heldItemContext, seed);
                }
                return;
            }
        }
        this.fallback.method_65584(state, stack, resolver, displayContext, world, heldItemContext, seed);
    }

    private boolean isLarge(Set<String> name) {
        for (String keyword : BlahajTotem.LARGE_KEYWORDS) {
            if (!name.contains(keyword)) continue;
            return true;
        }
        return false;
    }

    public record Variant(List<String> keywords, class_10439 normal, class_10439 large, boolean lesser) {
    }

    public record UnbakedVariant(List<String> keywords, class_10439.class_10441 normal, class_10439.class_10441 large, boolean lesser) {
        public static final MapCodec<UnbakedVariant> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("keywords").forGetter(UnbakedVariant::keywords), (App)class_10443.field_55335.fieldOf("normal").forGetter(UnbakedVariant::normal), (App)class_10443.field_55335.fieldOf("large").forGetter(UnbakedVariant::large), (App)Codec.BOOL.optionalFieldOf("lesser", (Object)false).forGetter(UnbakedVariant::lesser)).apply((Applicative)instance, UnbakedVariant::new));

        public Variant bake(class_10439.class_10440 context) {
            return new Variant(this.keywords(), this.normal().method_65587(context), this.large().method_65587(context), this.lesser());
        }

        public void resolve(class_10526.class_10103 resolver) {
            this.normal().method_62326(resolver);
            this.large().method_62326(resolver);
        }
    }

    public record Unbaked(List<UnbakedVariant> variants, class_10439.class_10441 fallback) implements class_10439.class_10441
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UnbakedVariant.CODEC.codec().listOf().fieldOf("variants").forGetter(Unbaked::variants), (App)class_10443.field_55335.fieldOf("fallback").forGetter(Unbaked::fallback)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<? extends class_10439.class_10441> method_65585() {
            return CODEC;
        }

        public class_10439 method_65587(class_10439.class_10440 context) {
            return new BlahajItemModel(this.variants().stream().map($ -> $.bake(context)).toList(), this.fallback().method_65587(context));
        }

        public void method_62326(class_10526.class_10103 resolver) {
            this.variants().forEach($ -> $.resolve(resolver));
            this.fallback().method_62326(resolver);
        }
    }
}

