/*
 * Decompiled with CFR 0.152.
 */
package net.verotek.libanalog.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.voegl.analogkey4j.key.HidKey;

public final class KeyMapper {
    private static final Map<HidKey, Integer> HID_TO_GLFW = Collections.unmodifiableMap(new HashMap<HidKey, Integer>(){
        {
            this.put(HidKey.A, 65);
            this.put(HidKey.B, 66);
            this.put(HidKey.C, 67);
            this.put(HidKey.D, 68);
            this.put(HidKey.E, 69);
            this.put(HidKey.F, 70);
            this.put(HidKey.G, 71);
            this.put(HidKey.H, 72);
            this.put(HidKey.I, 73);
            this.put(HidKey.J, 74);
            this.put(HidKey.K, 75);
            this.put(HidKey.L, 76);
            this.put(HidKey.M, 77);
            this.put(HidKey.N, 78);
            this.put(HidKey.O, 79);
            this.put(HidKey.P, 80);
            this.put(HidKey.Q, 81);
            this.put(HidKey.R, 82);
            this.put(HidKey.S, 83);
            this.put(HidKey.T, 84);
            this.put(HidKey.U, 85);
            this.put(HidKey.V, 86);
            this.put(HidKey.W, 87);
            this.put(HidKey.X, 88);
            this.put(HidKey.Y, 89);
            this.put(HidKey.Z, 90);
            this.put(HidKey.N0, 48);
            this.put(HidKey.N1, 49);
            this.put(HidKey.N2, 50);
            this.put(HidKey.N3, 51);
            this.put(HidKey.N4, 52);
            this.put(HidKey.N5, 53);
            this.put(HidKey.N6, 54);
            this.put(HidKey.N7, 55);
            this.put(HidKey.N8, 56);
            this.put(HidKey.N9, 57);
            this.put(HidKey.Space, 32);
            this.put(HidKey.Comma, 44);
            this.put(HidKey.Minus, 45);
            this.put(HidKey.Period, 46);
            this.put(HidKey.Slash, 47);
            this.put(HidKey.Semicolon, 59);
            this.put(HidKey.Equal, 61);
            this.put(HidKey.BracketLeft, 91);
            this.put(HidKey.Backslash, 92);
            this.put(HidKey.BracketRight, 93);
            this.put(HidKey.Backquote, 96);
            this.put(HidKey.Escape, 256);
            this.put(HidKey.Enter, 257);
            this.put(HidKey.Tab, 258);
            this.put(HidKey.Backspace, 259);
            this.put(HidKey.Insert, 260);
            this.put(HidKey.Delete, 261);
            this.put(HidKey.ArrowRight, 262);
            this.put(HidKey.ArrowLeft, 263);
            this.put(HidKey.ArrowDown, 264);
            this.put(HidKey.ArrowUp, 265);
            this.put(HidKey.PageUp, 266);
            this.put(HidKey.PageDown, 267);
            this.put(HidKey.Home, 268);
            this.put(HidKey.End, 269);
            this.put(HidKey.CapsLock, 280);
            this.put(HidKey.ScrollLock, 281);
            this.put(HidKey.NumLock, 282);
            this.put(HidKey.PrintScreen, 283);
            this.put(HidKey.PauseBreak, 284);
            this.put(HidKey.F1, 290);
            this.put(HidKey.F2, 291);
            this.put(HidKey.F3, 292);
            this.put(HidKey.F4, 293);
            this.put(HidKey.F5, 294);
            this.put(HidKey.F6, 295);
            this.put(HidKey.F7, 296);
            this.put(HidKey.F8, 297);
            this.put(HidKey.F9, 298);
            this.put(HidKey.F10, 299);
            this.put(HidKey.F11, 300);
            this.put(HidKey.F12, 301);
            this.put(HidKey.F13, 302);
            this.put(HidKey.F14, 303);
            this.put(HidKey.F15, 304);
            this.put(HidKey.F16, 305);
            this.put(HidKey.F17, 306);
            this.put(HidKey.F18, 307);
            this.put(HidKey.F19, 308);
            this.put(HidKey.F20, 309);
            this.put(HidKey.F21, 310);
            this.put(HidKey.F22, 311);
            this.put(HidKey.F23, 312);
            this.put(HidKey.F24, 313);
            this.put(HidKey.Numpad1, 321);
            this.put(HidKey.Numpad2, 322);
            this.put(HidKey.Numpad3, 323);
            this.put(HidKey.Numpad4, 324);
            this.put(HidKey.Numpad5, 325);
            this.put(HidKey.Numpad6, 326);
            this.put(HidKey.Numpad7, 327);
            this.put(HidKey.Numpad8, 328);
            this.put(HidKey.Numpad9, 329);
            this.put(HidKey.Numpad0, 320);
            this.put(HidKey.NumpadDecimal, 330);
            this.put(HidKey.NumpadDivide, 331);
            this.put(HidKey.NumpadMultiply, 332);
            this.put(HidKey.NumpadSubtract, 333);
            this.put(HidKey.NumpadAdd, 334);
            this.put(HidKey.NumpadEnter, 335);
            this.put(HidKey.NumpadEqual, 336);
            this.put(HidKey.LeftCtrl, 341);
            this.put(HidKey.LeftShift, 340);
            this.put(HidKey.LeftAlt, 342);
            this.put(HidKey.LeftMeta, 343);
            this.put(HidKey.RightCtrl, 345);
            this.put(HidKey.RightShift, 344);
            this.put(HidKey.RightAlt, 346);
            this.put(HidKey.RightMeta, 347);
            this.put(HidKey.ContextMenu, 348);
        }
    });
    private static final Map<Integer, HidKey> GLFW_TO_HID = Collections.unmodifiableMap(KeyMapper.reverseMap(HID_TO_GLFW));

    private KeyMapper() {
        throw new UnsupportedOperationException();
    }

    private static <T, S> Map<T, S> reverseMap(Map<S, T> map) {
        HashMap<T, S> reversedHashMap = new HashMap<T, S>();
        for (S key : map.keySet()) {
            reversedHashMap.put(map.get(key), key);
        }
        return reversedHashMap;
    }

    public static int hidToGlfw(HidKey key) {
        return HID_TO_GLFW.getOrDefault((Object)key, -1);
    }

    public static HidKey glfwToHid(int code) {
        return GLFW_TO_HID.get(code);
    }
}

