/*
 * Decompiled with CFR 0.152.
 */
package org.voegl.analogkey4j.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.voegl.analogkey4j.event.AnalogKeyState;
import org.voegl.analogkey4j.event.AnalogKeyboardListener;
import org.voegl.analogkey4j.plugins.AnalogKeyboardDevice;

public class AnalogKeyboardListenerList {
    private final Set<AnalogKeyboardListener> listeners = Collections.synchronizedSet(new HashSet());
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setName("Analog keyboard event thread");
        thread.setDaemon(true);
        return thread;
    });

    public void add(AnalogKeyboardListener listener) {
        this.listeners.add(listener);
    }

    public void remove(AnalogKeyboardListener listener) {
        this.listeners.remove(listener);
    }

    public void fireKeyboardAdded(AnalogKeyboardDevice hidDevice) {
        this.executorService.submit(() -> this.listeners.forEach(listener -> listener.keyboardAdded(hidDevice)));
    }

    public void fireKeyboardRemoved(AnalogKeyboardDevice hidDevice) {
        this.executorService.submit(() -> this.listeners.forEach(listener -> listener.keyboardRemoved(hidDevice)));
    }

    public void fireKeyboardOpened(AnalogKeyboardDevice hidDevice) {
        this.executorService.submit(() -> this.listeners.forEach(listener -> listener.keyboardOpened(hidDevice)));
    }

    public void fireKeyboardClosed(AnalogKeyboardDevice hidDevice) {
        this.executorService.submit(() -> this.listeners.forEach(listener -> listener.keyboardClosed(hidDevice)));
    }

    public void fireKeyboardError(AnalogKeyboardDevice hidDevice, String message) {
        this.executorService.submit(() -> this.listeners.forEach(listener -> listener.keyboardError(hidDevice, message)));
    }

    public void fireKeyPressed(AnalogKeyboardDevice hidDevice, Set<AnalogKeyState> states) {
        this.executorService.submit(() -> this.listeners.forEach(listener -> listener.keyPressed(hidDevice, Collections.unmodifiableSet(states))));
    }
}

