/*
 * Decompiled with CFR 0.152.
 */
package org.voegl.analogkey4j.event;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.HidServicesSpecification;
import org.hid4java.event.HidServicesEvent;
import org.voegl.analogkey4j.event.AnalogKeyboardListener;
import org.voegl.analogkey4j.event.AnalogKeyboardListenerList;
import org.voegl.analogkey4j.plugins.AnalogKeyboardDevice;
import org.voegl.analogkey4j.plugins.AnalogKeyboardDeviceUtil;

public class HidServicesListenerImpl
implements HidServicesListener {
    private final AnalogKeyboardListenerList listeners = new AnalogKeyboardListenerList();
    private HidServices hidServices;
    private final Set<AnalogKeyboardDevice> keyboardDevices = new HashSet<AnalogKeyboardDevice>();

    public void start() {
        HidServicesSpecification hidServicesSpecification = new HidServicesSpecification();
        hidServicesSpecification.setAutoStart(false);
        hidServicesSpecification.setAutoDataRead(false);
        this.hidServices = HidManager.getHidServices(hidServicesSpecification);
        this.hidServices.addHidServicesListener(this);
        this.hidServices.start();
        for (HidDevice hidDevice : this.hidServices.getAttachedHidDevices()) {
            Optional<AnalogKeyboardDevice> keyboardDevice = AnalogKeyboardDeviceUtil.getAvailablePlugin(hidDevice, this.listeners);
            keyboardDevice.ifPresent(this.keyboardDevices::add);
        }
    }

    public void stop() {
        for (AnalogKeyboardDevice device : this.keyboardDevices) {
            if (device.isReadDone() || device.isClosed()) continue;
            device.close();
        }
        long startTime = System.currentTimeMillis();
        long timeout = 60000L;
        while (this.keyboardDevices.stream().anyMatch(d -> !d.isClosed())) {
            if (System.currentTimeMillis() - startTime > timeout) {
                throw new RuntimeException("Some keyboard devices did not close after 60 seconds.");
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        for (AnalogKeyboardDevice keyboardDevice : this.keyboardDevices) {
            this.keyboardDevices.remove(keyboardDevice);
            this.listeners.fireKeyboardRemoved(keyboardDevice);
        }
        this.hidServices.stop();
    }

    public void addListener(AnalogKeyboardListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AnalogKeyboardListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void hidDeviceAttached(HidServicesEvent event) {
        Optional<AnalogKeyboardDevice> optionalKeyboard = AnalogKeyboardDeviceUtil.getAvailablePlugin(event.getHidDevice(), this.listeners);
        if (optionalKeyboard.isPresent()) {
            AnalogKeyboardDevice keyboard = optionalKeyboard.get();
            this.listeners.fireKeyboardAdded(keyboard);
            this.keyboardDevices.add(keyboard);
        }
    }

    @Override
    public void hidDeviceDetached(HidServicesEvent event) {
        for (AnalogKeyboardDevice keyboardDevice : this.keyboardDevices) {
            if (!keyboardDevice.getDevice().equals(event.getHidDevice())) continue;
            if (!keyboardDevice.isClosed()) {
                keyboardDevice.close();
            }
            this.keyboardDevices.remove(keyboardDevice);
            this.listeners.fireKeyboardRemoved(keyboardDevice);
        }
    }

    @Override
    public void hidFailure(HidServicesEvent event) {
        AnalogKeyboardDevice plugin = null;
        for (AnalogKeyboardDevice savedPlugins : this.keyboardDevices) {
            if (!savedPlugins.getDevice().equals(event.getHidDevice())) continue;
            plugin = savedPlugins;
            break;
        }
        if (plugin != null) {
            this.listeners.fireKeyboardError(plugin, event.getHidDevice().getLastErrorMessage());
        }
    }

    @Override
    public void hidDataReceived(HidServicesEvent event) {
    }

    @Generated
    public Set<AnalogKeyboardDevice> getKeyboardDevices() {
        return this.keyboardDevices;
    }
}

