/*
 * Decompiled with CFR 0.152.
 */
package org.voegl.analogkey4j.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.voegl.analogkey4j.event.AnalogKeyState;
import org.voegl.analogkey4j.key.HidKey;
import org.voegl.analogkey4j.key.HidKeyMap;

public class HidParser {
    private static final float SAFE_ZERO = 0.0019607844f;
    protected Set<AnalogKeyState> lastKeyStates = Collections.emptySet();
    private final HidKeyMap keyMap;

    public HidParser(HidKeyMap keyMap) {
        this.keyMap = keyMap;
    }

    private synchronized void resetLastKeys(Set<AnalogKeyState> states) {
        HashSet<HidKey> keys = new HashSet<HidKey>();
        for (AnalogKeyState state : states) {
            keys.add(state.key());
        }
        for (AnalogKeyState state : this.lastKeyStates) {
            if (!(state.value() > 0.0019607844f) || keys.contains((Object)state.key())) continue;
            states.add(new AnalogKeyState(state.key(), 0.0f));
        }
    }

    public synchronized Set<AnalogKeyState> parse(byte[] data, int len) {
        HashSet<AnalogKeyState> states = new HashSet<AnalogKeyState>();
        for (int i = 0; i < len - 2; i += 3) {
            byte type = data[i];
            if (type != 0) continue;
            byte key = data[i + 1];
            if (key == 0) break;
            byte value = data[i + 2];
            float pressed = (float)(value & 0xFF) / 255.0f;
            states.add(new AnalogKeyState(this.keyMap.getKey(key), pressed));
        }
        this.resetLastKeys(states);
        this.lastKeyStates = states;
        return states;
    }
}

